/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.entity;

import com.dainxt.dungeonsmod.config.DungeonsModConfig;
import com.dainxt.dungeonsmod.difficulty.DifficultyManager;
import com.dainxt.dungeonsmod.entity.EntityPitcher;
import com.dainxt.dungeonsmod.handlers.EntityRegistries;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;

public class EntityWinterHunter
extends Monster
implements RangedAttackMob {
    DifficultyManager difficultyManager = new DifficultyManager();
    private final ServerBossEvent bossInfo = (ServerBossEvent)new ServerBossEvent(this.m_7755_(), BossEvent.BossBarColor.WHITE, BossEvent.BossBarOverlay.PROGRESS).m_7003_(true);

    public EntityWinterHunter(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
        this.f_21364_ = 1000;
    }

    protected ResourceLocation m_7582_() {
        return DungeonsModConfig.COMMON.winterhunter.getDefaultLootTable();
    }

    public ItemEntity m_5552_(ItemStack stack, float offsetY) {
        if (stack.m_41720_() instanceof BowItem) {
            // empty if block
        }
        return super.m_5552_(stack, offsetY);
    }

    public static boolean canSpawn(EntityType<? extends Monster> type, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, Random randomIn) {
        if (worldIn.m_46857_(pos).m_47567_() == Biome.BiomeCategory.ICY) {
            return Monster.m_33023_(type, (LevelAccessor)worldIn, (MobSpawnType)reason, (BlockPos)pos, (Random)randomIn);
        }
        if (randomIn.nextInt(30) == 0) {
            return Monster.m_33023_(type, (LevelAccessor)worldIn, (MobSpawnType)reason, (BlockPos)pos, (Random)randomIn);
        }
        return false;
    }

    protected void m_6851_(DifficultyInstance difficulty) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficulty, MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag) {
        SpawnGroupData data = super.m_6518_(worldIn, difficulty, reason, spawnDataIn, dataTag);
        this.m_6851_(difficulty);
        return data;
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 220.0).m_22268_(Attributes.f_22281_, 40.0).m_22268_(Attributes.f_22279_, 0.6).m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22284_, 15.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(3, (Goal)new RangedBowAttackGoal((Monster)this, 1.0, 0, 40.0f));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 0, true, true, (Predicate)((com.google.common.base.Predicate)null)));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 0, true, true, (Predicate)((Object)new WinterHunterTargetSelector(this))));
    }

    public boolean causeFallDamage(float distance, float damageMultiplier) {
        return false;
    }

    public boolean m_6072_() {
        return false;
    }

    protected void m_8024_() {
        ServerLevel serverworld;
        EntityPitcher traveler;
        super.m_8024_();
        if (((Boolean)DungeonsModConfig.COMMON.scalingDifficulty.get()).booleanValue()) {
            this.difficultyManager.adjustDifficulty((LivingEntity)this, 0.5f, 0.5f, 0.5f, 0.5f, this.bossInfo.m_8324_());
        }
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
        if (this.f_19797_ % 300 == 0 && !this.f_19853_.f_46443_) {
            for (Player player : this.bossInfo.m_8324_()) {
                if (player.m_7500_() || player.m_5833_()) continue;
                traveler = new EntityPitcher(EntityRegistries.PITCHER, this.f_19853_);
                serverworld = (ServerLevel)this.f_19853_;
                traveler.m_7678_(player.m_20185_(), player.m_20186_(), player.m_20189_(), 0.0f, 0.0f);
                traveler.m_6518_((ServerLevelAccessor)serverworld, this.f_19853_.m_6436_(traveler.m_142538_()), MobSpawnType.MOB_SUMMONED, null, null);
                this.f_19853_.m_7967_((Entity)traveler);
                this.f_19853_.m_7785_(traveler.m_20185_(), traveler.m_20186_(), traveler.m_20189_(), SoundEvents.f_11991_, SoundSource.HOSTILE, 1.0f, 5.0f, false);
            }
        }
        if (this.f_19797_ % 400 == 0 && !this.f_19853_.f_46443_) {
            for (Player player : this.bossInfo.m_8324_()) {
                if (player.m_7500_() || player.m_5833_()) continue;
                traveler = new Wolf(EntityType.f_20499_, this.f_19853_);
                serverworld = (ServerLevel)this.f_19853_;
                traveler.m_7678_(player.m_20185_(), player.m_20186_(), player.m_20189_(), 0.0f, 0.0f);
                traveler.m_6518_((ServerLevelAccessor)serverworld, this.f_19853_.m_6436_(traveler.m_142538_()), MobSpawnType.MOB_SUMMONED, null, null);
                this.f_19853_.m_7967_((Entity)traveler);
                traveler.m_6710_((LivingEntity)player);
                this.f_19853_.m_7785_(traveler.m_20185_(), traveler.m_20186_(), traveler.m_20189_(), SoundEvents.f_12620_, SoundSource.HOSTILE, 1.0f, 5.0f, false);
            }
        }
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
        if (this.bossInfo.m_8324_().isEmpty()) {
            this.m_21153_((float)this.m_21051_(Attributes.f_22276_).m_22115_());
        }
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        ItemStack itemstack;
        if (distanceFactor <= 0.35f) {
            this.m_7327_((Entity)target);
            this.m_6674_(InteractionHand.OFF_HAND);
        }
        if (!(itemstack = this.m_6298_(this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem)))).m_41619_()) {
            itemstack = Items.f_42738_.m_7968_();
        }
        AbstractArrow abstractarrowentity = this.fireArrow(itemstack, distanceFactor);
        if (this.m_21205_().m_41720_() instanceof BowItem) {
            abstractarrowentity = ((BowItem)this.m_21205_().m_41720_()).customArrow(abstractarrowentity);
        }
        double d0 = target.m_20185_() - this.m_20185_();
        double d1 = target.m_20227_(0.3333333333) - abstractarrowentity.m_20186_();
        double d2 = target.m_20189_() - this.m_20189_();
        double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
        abstractarrowentity.m_36781_(this.m_21133_(Attributes.f_22281_) * (double)0.3f);
        abstractarrowentity.m_6686_(d0, d1 + d3 * (double)0.05f, d2, 5.0f, 1.0f);
        this.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (this.m_21187_().nextFloat() * 0.4f + 0.8f));
        this.f_19853_.m_7967_((Entity)abstractarrowentity);
    }

    protected AbstractArrow fireArrow(ItemStack arrowStack, float distanceFactor) {
        return ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)arrowStack, (float)distanceFactor);
    }

    public boolean m_5886_(ProjectileWeaponItem p_230280_1_) {
        return p_230280_1_ == Items.f_42411_;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * 0.7f;
    }

    public List<ServerPlayer> getPlayers() {
        return this.bossInfo.m_8324_().stream().filter(EntitySelector.f_20406_).collect(Collectors.toList());
    }

    public boolean m_21532_() {
        return !this.bossInfo.m_8324_().isEmpty();
    }

    public void m_6043_() {
        if (this.bossInfo.m_8324_().isEmpty()) {
            super.m_6043_();
        }
    }

    public static class WinterHunterTargetSelector
    implements com.google.common.base.Predicate<LivingEntity> {
        private final EntityWinterHunter parentEntity;

        public WinterHunterTargetSelector(EntityWinterHunter guardian) {
            this.parentEntity = guardian;
        }

        public boolean apply(@Nullable LivingEntity p_apply_1_) {
            return !(p_apply_1_ instanceof EntityWinterHunter) && !(p_apply_1_ instanceof EnderMan) && !(p_apply_1_ instanceof EntityPitcher);
        }
    }
}

