/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.entity.boss;

import com.dainxt.dungeonsmod.ai.AIScheduledTimedAction;
import com.dainxt.dungeonsmod.config.DungeonsModConfig;
import com.dainxt.dungeonsmod.difficulty.DifficultyManager;
import com.dainxt.dungeonsmod.items.CrawlerArmorItem;
import com.dainxt.dungeonsmod.util.EntityUtils;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT, _interface=PowerableMob.class)
public class EntityCrawler
extends Monster
implements PowerableMob {
    DifficultyManager difficultyManager = new DifficultyManager();
    int MAX_DISTANCE = 10;
    private final ServerBossEvent bossInfo = (ServerBossEvent)new ServerBossEvent(this.m_7755_(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS).m_7003_(true);
    private static final EntityDataAccessor<Boolean> Buffed = SynchedEntityData.m_135353_(EntityCrawler.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HEAVY_ATTACK = SynchedEntityData.m_135353_(EntityCrawler.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FINISHER_ATTACK = SynchedEntityData.m_135353_(EntityCrawler.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public ArrayList<BlockPos> HEART_PLACES;

    public EntityCrawler(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
        this.f_21364_ = 1500;
        this.m_21530_();
        this.f_19811_ = true;
        if (!worldIn.f_46443_) {
            this.HEART_PLACES = new ArrayList();
        }
    }

    protected ResourceLocation m_7582_() {
        return DungeonsModConfig.COMMON.crawler.getDefaultLootTable();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(Buffed, (Object)false);
        this.f_19804_.m_135372_(HEAVY_ATTACK, (Object)false);
        this.f_19804_.m_135372_(FINISHER_ATTACK, (Object)false);
    }

    public ItemEntity m_5552_(ItemStack stack, float offsetY) {
        if (stack.m_41720_() instanceof CrawlerArmorItem) {
            long totalPlayers = this.bossInfo.m_8324_().stream().filter(EntitySelector.f_20406_).count();
            float totalChance = Mth.m_14036_((float)((float)((Double)DungeonsModConfig.COMMON.legendaryLootChance.get() * (double)totalPlayers)), (float)0.0f, (float)100.0f);
            if (this.f_19853_.m_5822_().nextFloat() < totalChance / 100.0f) {
                return super.m_5552_(stack, offsetY);
            }
            return super.m_5552_(ItemStack.f_41583_, offsetY);
        }
        return super.m_5552_(stack, offsetY);
    }

    public boolean isBuffed() {
        return (Boolean)this.m_20088_().m_135370_(Buffed);
    }

    public void setBuffed(boolean attack) {
        this.m_20088_().m_135381_(Buffed, (Object)attack);
    }

    public boolean isHeavyAttacking() {
        return (Boolean)this.m_20088_().m_135370_(HEAVY_ATTACK);
    }

    public void setHeavyAttack(boolean attack) {
        this.m_20088_().m_135381_(HEAVY_ATTACK, (Object)attack);
    }

    public boolean isFinisherAttacking() {
        return (Boolean)this.m_20088_().m_135370_(FINISHER_ATTACK);
    }

    public void setFinisherAttack(boolean attack) {
        this.m_20088_().m_135381_(FINISHER_ATTACK, (Object)attack);
    }

    public boolean m_7327_(Entity entityIn) {
        boolean flag = false;
        if (this.isHeavyAttacking()) {
            float heavyDamage = ((LivingEntity)entityIn).m_21223_() * 0.85f * DifficultyManager.getTotalAttributePPP((LivingEntity)this, Attributes.f_22281_);
            flag = entityIn.m_6469_(DamageSource.m_19370_((LivingEntity)this).m_19389_(), heavyDamage);
        } else if (this.isFinisherAttacking()) {
            float modAmount = 0.0f;
            if (entityIn instanceof Player) {
                for (ItemStack stack : ((Player)entityIn).m_150109_().f_35974_) {
                    if (stack.m_41619_()) continue;
                    modAmount = (float)((double)modAmount + 0.1);
                }
            }
            float finisherDamage = (modAmount += this.m_20270_(entityIn) * 1.5f + 5.0f) * DifficultyManager.getTotalAttributePPP((LivingEntity)this, Attributes.f_22281_);
            flag = entityIn.m_6469_(DamageSource.m_19370_((LivingEntity)this).m_19389_(), finisherDamage);
        } else {
            flag = super.m_7327_(entityIn);
        }
        return flag;
    }

    public void m_20258_(CompoundTag compound) {
        this.setHeavyAttack(compound.m_128471_("HeavyAttack"));
        if (!this.f_19853_.f_46443_) {
            CompoundTag nbt = compound.m_128469_("heartPos");
            for (int i = 0; i < nbt.m_128451_("index"); ++i) {
                this.HEART_PLACES.add(BlockPos.m_122022_((long)nbt.m_128454_("heart_" + i)));
            }
        }
        super.m_20258_(compound);
    }

    public CompoundTag m_20240_(CompoundTag compound) {
        compound.m_128379_("HeavyAttack", this.isHeavyAttacking());
        if (!this.f_19853_.f_46443_) {
            CompoundTag nbt = compound.m_128469_("heartPos");
            nbt.m_128405_("index", this.HEART_PLACES.size());
            for (int i = 0; i < this.HEART_PLACES.size(); ++i) {
                nbt.m_128356_("heart_" + i, this.HEART_PLACES.get(i).m_121878_());
            }
            compound.m_128365_("heartPos", (Tag)nbt);
        }
        return super.m_20240_(compound);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new AIDoFinisherAttack(this, 60, 240));
        this.f_21345_.m_25352_(2, (Goal)new AIDoHeavyAttack(this, 40, 120, 2));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 0, true, true, (Predicate)((com.google.common.base.Predicate)null)));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_7640_() instanceof Arrow) {
            ((Arrow)source.m_7640_()).m_36735_(0);
        }
        return super.m_6469_(source, amount);
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 300.0).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource p_147189_) {
        List entities = this.f_19853_.m_45976_(LivingEntity.class, this.m_142469_().m_82400_(25.0));
        if (!entities.isEmpty()) {
            for (LivingEntity entity : entities) {
                if (entity instanceof EntityCrawler) continue;
                if (entity instanceof Player) {
                    this.m_5496_(SoundEvents.f_11913_, 10.0f, 1.0f);
                    this.m_21373_();
                }
                this.m_7327_((Entity)entity);
            }
        }
        return super.m_142535_(distance, damageMultiplier, p_147189_);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.f_19853_.f_46443_) {
            for (int i = 0; i < 2; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123784_, this.m_20208_(0.5), this.m_20187_() - 0.25, this.m_20262_(0.5), (this.f_19796_.nextDouble() - 0.5) * 2.0, -this.f_19796_.nextDouble(), (this.f_19796_.nextDouble() - 0.5) * 2.0);
            }
        }
    }

    protected float m_6118_() {
        return 0.8f;
    }

    protected void m_21226_() {
        this.f_21364_ = (int)((long)this.f_21364_ + (long)Mth.m_14167_((float)((float)this.f_21364_ * 0.1f)) * this.bossInfo.m_8324_().stream().filter(EntitySelector.f_20406_).count());
        super.m_21226_();
    }

    public boolean m_6072_() {
        return false;
    }

    protected void m_8024_() {
        long hearts;
        super.m_8024_();
        if (((Boolean)DungeonsModConfig.COMMON.scalingDifficulty.get()).booleanValue()) {
            this.difficultyManager.adjustDifficulty((LivingEntity)this, 0.3f, 0.1f, 0.1f, 0.1f, this.bossInfo.m_8324_());
        }
        this.setBuffed((hearts = this.HEART_PLACES.stream().filter(pos -> !pos.equals((Object)BlockPos.f_121853_) && this.f_19853_.m_8055_(pos).m_60734_() == Blocks.f_50330_).count()) > 0L);
        this.m_5634_((float)hearts * 2.0f);
        if (this.f_19797_ % 20 == 0) {
            EntityUtils.scanBlocksInAABB((LivingEntity)this, this.m_142469_().m_82400_((double)0.1f), (blockPos, blockState) -> {
                int hardness = Mth.m_14045_((int)Mth.m_14143_((float)(blockState.m_60800_((BlockGetter)this.f_19853_, blockPos) * 0.33f)), (int)3, (int)Integer.MAX_VALUE);
                if (!blockState.m_60734_().equals(Blocks.f_50752_) && (double)blockPos.m_123342_() > this.m_20227_(0.1f) && this.f_19853_.f_46441_.nextInt(hardness) == 0) {
                    this.f_19853_.m_46961_(blockPos, false);
                }
                return false;
            });
        }
        float distance = Float.MAX_VALUE;
        for (Player player : this.getPlayers()) {
            distance = Math.min(player.m_20270_((Entity)this), distance);
        }
        if (distance > (float)this.MAX_DISTANCE) {
            this.m_5634_(0.5f);
        }
        this.m_5634_(0.25f * DifficultyManager.getTotalAttributePPP((LivingEntity)this, Attributes.f_22276_));
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
        if (this.bossInfo.m_8324_().isEmpty()) {
            this.m_21153_(this.m_21233_());
        }
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public List<ServerPlayer> getPlayers() {
        return this.bossInfo.m_8324_().stream().filter(EntitySelector.f_20406_).collect(Collectors.toList());
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12032_;
    }

    protected SoundEvent m_5896_(int heightIn) {
        return SoundEvents.f_11913_;
    }

    public boolean m_7090_() {
        return this.isBuffed();
    }

    public void m_6043_() {
    }

    class AIDoFinisherAttack
    extends AIScheduledTimedAction {
        EntityCrawler crawler;

        public AIDoFinisherAttack(EntityCrawler entity, int maxDuration, int maxCooldown) {
            super((LivingEntity)entity, maxDuration, maxCooldown);
            this.crawler = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        @Override
        public boolean m_8036_() {
            if (this.crawler.m_5448_() != null) {
                return super.m_8036_();
            }
            return false;
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            this.crawler.setFinisherAttack(true);
        }

        @Override
        public void onStartCycle() {
            List entities = this.crawler.f_19853_.m_45976_(LivingEntity.class, this.attacker.m_142469_().m_82400_(50.0));
            if (!entities.isEmpty()) {
                for (LivingEntity entity : entities) {
                    if (entity instanceof EntityCrawler) continue;
                    this.attacker.m_7327_((Entity)entity);
                }
            }
        }

        @Override
        public void m_8041_() {
            super.m_8041_();
            this.crawler.setFinisherAttack(false);
        }
    }

    class AIDoHeavyAttack
    extends AIScheduledTimedAction {
        EntityCrawler crawler;

        public AIDoHeavyAttack(EntityCrawler entity, int maxDuration, int maxCooldown, int times) {
            super((LivingEntity)entity, maxDuration, maxCooldown, ++times);
            this.crawler = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        @Override
        public boolean m_8036_() {
            if (this.crawler.m_5448_() != null) {
                return super.m_8036_();
            }
            return false;
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            this.crawler.m_20260_(true);
        }

        @Override
        public void onStartCycle() {
            this.crawler.setHeavyAttack(true);
            if (this.times > 0) {
                this.crawler.m_21569_().m_24901_();
            }
        }

        @Override
        public void m_8041_() {
            super.m_8041_();
            this.crawler.setHeavyAttack(false);
            this.crawler.m_20260_(false);
        }
    }
}

