/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.entity.boss;

import com.dainxt.dungeonsmod.ai.AITimedAction;
import com.dainxt.dungeonsmod.config.DungeonsModConfig;
import com.dainxt.dungeonsmod.difficulty.DifficultyManager;
import com.dainxt.dungeonsmod.items.ItemSandBucket;
import com.dainxt.dungeonsmod.util.EntityUtils;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT, _interface=PowerableMob.class)
public class EntityDeserted
extends Monster
implements PowerableMob,
RangedAttackMob {
    DifficultyManager difficultyManager = new DifficultyManager();
    private static final EntityDataAccessor<Integer> FIRE_ARMOR_TIME = SynchedEntityData.m_135353_(EntityDeserted.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final ServerBossEvent bossInfo = (ServerBossEvent)new ServerBossEvent(this.m_7755_(), BossEvent.BossBarColor.YELLOW, BossEvent.BossBarOverlay.PROGRESS).m_7003_(true);

    public EntityDeserted(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
        this.f_21364_ = 250;
        this.m_21530_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FIRE_ARMOR_TIME, (Object)0);
    }

    public int getFireArmor() {
        return (Integer)this.m_20088_().m_135370_(FIRE_ARMOR_TIME);
    }

    public void setHaveFireArmor(int time) {
        this.m_20088_().m_135381_(FIRE_ARMOR_TIME, (Object)time);
    }

    protected ResourceLocation m_7582_() {
        return DungeonsModConfig.COMMON.deserted.getDefaultLootTable();
    }

    public ItemEntity m_5552_(ItemStack stack, float offsetY) {
        if (stack.m_41720_() instanceof ItemSandBucket) {
            long totalPlayers = this.bossInfo.m_8324_().stream().filter(EntitySelector.f_20406_).count();
            float totalChance = Mth.m_14036_((float)((float)((Double)DungeonsModConfig.COMMON.legendaryLootChance.get() * (double)totalPlayers)), (float)0.0f, (float)100.0f);
            if (this.f_19853_.m_5822_().nextFloat() < totalChance / 100.0f) {
                return super.m_5552_(stack, offsetY);
            }
            return super.m_5552_(ItemStack.f_41583_, offsetY);
        }
        return super.m_5552_(stack, offsetY);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.getFireArmor() > 0) {
            amount *= 0.25f;
        }
        if (source.equals(DamageSource.f_19310_)) {
            EntityUtils.destroyBlocksInAABB((LivingEntity)this, null);
        }
        if (source.m_7640_() instanceof Arrow) {
            ((Arrow)source.m_7640_()).m_36735_(0);
        }
        if (source.m_19384_()) {
            this.setHaveFireArmor(100);
            this.m_5634_(amount * 2.0f);
            EntityUtils.destroyBlocksInAABB((LivingEntity)this, 2.0, Blocks.f_50083_, Blocks.f_49991_);
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_6063_() {
        return true;
    }

    public boolean m_6128_() {
        return true;
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 150.0).m_22268_(Attributes.f_22281_, 20.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22284_, 30.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    private double getHeadX(int p_82214_1_) {
        if (p_82214_1_ <= 0) {
            float f = (this.f_20883_ + 90.0f) * ((float)Math.PI / 180);
            float f1 = Mth.m_14089_((float)f);
            return this.m_20185_() + (double)f1 * 1.0;
        }
        float f = (this.f_20883_ + (float)(180 * (p_82214_1_ - 1))) * ((float)Math.PI / 180);
        float f1 = Mth.m_14089_((float)f);
        return this.m_20185_() + (double)f1 * 1.3;
    }

    private double getHeadY(int p_82208_1_) {
        return p_82208_1_ <= 0 ? this.m_20186_() + 1.9 : this.m_20186_() + 2.2;
    }

    private double getHeadZ(int p_82213_1_) {
        if (p_82213_1_ <= 0) {
            float f = (this.f_20883_ + 90.0f) * ((float)Math.PI / 180);
            float f1 = Mth.m_14031_((float)f);
            return this.m_20189_() + (double)f1 * 1.0;
        }
        float f = (this.f_20883_ + (float)(180 * (p_82213_1_ - 1))) * ((float)Math.PI / 180);
        float f1 = Mth.m_14031_((float)f);
        return this.m_20189_() + (double)f1 * 1.3;
    }

    private void launchProjectiletoEntity(int p_82216_1_, LivingEntity p_82216_2_) {
        this.launchProjectiletoCoords(p_82216_1_, p_82216_2_.m_20185_(), p_82216_2_.m_20186_() + (double)p_82216_2_.m_20192_() * 0.5, p_82216_2_.m_20189_(), p_82216_1_ == 0 && this.f_19796_.nextFloat() < 0.001f);
    }

    private void launchProjectiletoCoords(int p_82209_1_, double x, double y, double z, boolean invulnerable) {
        if (!this.m_20067_()) {
            this.f_19853_.m_5898_((Player)null, 1024, this.m_142538_(), 0);
        }
        double d0 = this.getHeadX(p_82209_1_);
        double d1 = this.getHeadY(p_82209_1_);
        double d2 = this.getHeadZ(p_82209_1_);
        double d3 = x - d0;
        double d4 = y - d1;
        double d5 = z - d2;
        LargeFireball witherskullentity = new LargeFireball(this.f_19853_, (LivingEntity)this, d3, d4, d5, 0);
        witherskullentity.m_5602_((Entity)this);
        witherskullentity.m_20343_(d0, d1, d2);
        this.f_19853_.m_7967_((Entity)witherskullentity);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new AIDoNothing(this, 240, 60));
        this.f_21345_.m_25352_(1, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 7, 20.0f));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 16.0f));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 0, true, true, (Predicate)((com.google.common.base.Predicate)null)));
    }

    protected void m_7324_(Entity entityIn) {
    }

    public boolean m_6094_() {
        return false;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag) {
        this.m_6034_((int)this.m_20185_(), this.m_20186_(), (int)this.m_20189_());
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.f_19853_.f_46443_) {
            for (int i = 0; i < 2; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123790_, this.m_20208_(0.5), this.m_20187_() - 0.25, this.m_20262_(0.5), (this.f_19796_.nextDouble() - 0.5) * 2.0, -this.f_19796_.nextDouble(), (this.f_19796_.nextDouble() - 0.5) * 2.0);
            }
        }
        this.m_6210_();
        if (!this.f_19853_.f_46443_ && this.getFireArmor() > 0) {
            int time = this.getFireArmor();
            this.setHaveFireArmor(--time);
        }
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        if (distanceFactor <= 0.35f) {
            this.m_7327_((Entity)target);
        }
        this.m_6674_(InteractionHand.OFF_HAND);
        this.launchProjectiletoEntity(0, target);
    }

    protected void m_6763_(BlockState blockstate) {
        Block block = blockstate.m_60734_();
        if (block == Blocks.f_49992_) {
            EntityUtils.destroyBlocksInAABB((LivingEntity)this, Blocks.f_49992_);
            this.m_5634_(10.0f);
        }
        if (block instanceof FallingBlock) {
            EntityUtils.destroyBlocksInAABB((LivingEntity)this, block);
        }
        super.m_6763_(blockstate);
    }

    protected void m_21226_() {
        this.f_21364_ = (int)((long)this.f_21364_ + (long)Mth.m_14167_((float)((float)this.f_21364_ * 0.1f)) * this.bossInfo.m_8324_().stream().filter(EntitySelector.f_20406_).count());
        super.m_21226_();
    }

    public boolean m_6072_() {
        return false;
    }

    protected void m_8024_() {
        super.m_8024_();
        if (((Boolean)DungeonsModConfig.COMMON.scalingDifficulty.get()).booleanValue()) {
            this.difficultyManager.adjustDifficulty((LivingEntity)this, 0.2f, 0.0f, 0.5f, 0.0f, this.bossInfo.m_8324_());
        }
        if (!this.m_21536_()) {
            this.m_21446_(this.m_142538_(), 3);
        }
        BlockPos pos = this.m_21534_();
        this.m_6034_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        this.m_20256_(Vec3.f_82478_);
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
        if (this.bossInfo.m_8324_().isEmpty()) {
            this.m_21153_(this.m_21233_());
        }
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12325_;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12331_;
    }

    public boolean m_7090_() {
        return this.getFireArmor() > 0;
    }

    public EntityDimensions m_6972_(Pose entityPose) {
        if (this.m_21051_(Attributes.f_22284_).m_22135_() == 0.0) {
            return EntityDimensions.m_20395_((float)1.0f, (float)1.0f);
        }
        return EntityDimensions.m_20395_((float)1.5f, (float)2.5f);
    }

    public void m_6043_() {
    }

    class AIDoNothing
    extends AITimedAction {
        EntityDeserted deserted;

        public AIDoNothing(EntityDeserted entity, int maxDuration, int maxCooldown) {
            super((LivingEntity)entity, maxDuration, maxCooldown);
            this.deserted = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        @Override
        public void m_8041_() {
            super.m_8041_();
            EntityUtils.destroyBlocksInAABB(this.attacker, 3.0, Blocks.f_49990_);
            this.attacker.m_5496_(SoundEvents.f_11937_, 10.0f, 0.1f);
            this.deserted.setHaveFireArmor(this.maxCooldown);
            this.attacker.m_21051_(Attributes.f_22284_).m_22100_(30.0);
        }

        @Override
        public boolean m_8045_() {
            return super.m_8045_();
        }

        @Override
        public boolean m_8036_() {
            if (this.attacker.m_20069_() && this.deserted.getFireArmor() > 0) {
                EntityUtils.destroyBlocksInAABB(this.attacker, 1.0, Blocks.f_49990_);
                this.attacker.m_5496_(SoundEvents.f_11937_, 10.0f, 0.1f);
            }
            return super.m_8036_() && this.attacker.m_20069_();
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            this.attacker.m_21051_(Attributes.f_22284_).m_22100_(0.0);
        }
    }
}

