/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.entity.boss;

import com.dainxt.dungeonsmod.config.DungeonsModConfig;
import com.dainxt.dungeonsmod.difficulty.DifficultyManager;
import com.dainxt.dungeonsmod.items.ItemOreDetector;
import com.dainxt.dungeonsmod.util.EntityUtils;
import java.util.EnumSet;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ToolActions;

public class EntityIronSlime
extends Monster {
    DifficultyManager difficultyManager = new DifficultyManager();
    private static final EntityDataAccessor<Integer> PHASE = SynchedEntityData.m_135353_(EntityIronSlime.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> OUTER_SHELL_INTEGRITY = SynchedEntityData.m_135353_(EntityIronSlime.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> LAST_MINED_TICK = SynchedEntityData.m_135353_(EntityIronSlime.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final float homeRange = 7.0f;
    private final float maxPhase = 5.0f;
    private int MaxTimeBreak = 28;
    private final ServerBossEvent bossInfo = (ServerBossEvent)new ServerBossEvent(this.m_7755_(), BossEvent.BossBarColor.WHITE, BossEvent.BossBarOverlay.PROGRESS).m_7003_(true);

    public EntityIronSlime(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
        this.f_21342_ = new MoveHelperController(this);
        this.f_21364_ = 375;
        this.m_21530_();
    }

    public boolean m_6063_() {
        return false;
    }

    protected ResourceLocation m_7582_() {
        return DungeonsModConfig.COMMON.ironslime.getDefaultLootTable();
    }

    public ItemEntity m_5552_(ItemStack stack, float offsetY) {
        if (stack.m_41720_() instanceof ItemOreDetector) {
            long totalPlayers = this.bossInfo.m_8324_().stream().filter(EntitySelector.f_20406_).count();
            float totalChance = Mth.m_14036_((float)((float)((Double)DungeonsModConfig.COMMON.legendaryLootChance.get() * (double)totalPlayers)), (float)0.0f, (float)100.0f);
            if (this.f_19853_.m_5822_().nextFloat() < totalChance / 100.0f) {
                return super.m_5552_(stack, offsetY);
            }
            return super.m_5552_(ItemStack.f_41583_, offsetY);
        }
        return super.m_5552_(stack, offsetY);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(LAST_MINED_TICK, (Object)0);
        this.f_19804_.m_135372_(PHASE, (Object)5);
        this.f_19804_.m_135372_(OUTER_SHELL_INTEGRITY, (Object)28);
    }

    public void setLastMinedTick(int phase) {
        this.m_20088_().m_135381_(LAST_MINED_TICK, (Object)phase);
    }

    public int getLastMinedTick() {
        return (Integer)this.m_20088_().m_135370_(LAST_MINED_TICK);
    }

    public void setPhase(int phase) {
        this.m_20088_().m_135381_(PHASE, (Object)phase);
    }

    public int getPhase() {
        return (Integer)this.m_20088_().m_135370_(PHASE);
    }

    public void setShellIntegrity(int integrity) {
        this.m_20088_().m_135381_(OUTER_SHELL_INTEGRITY, (Object)integrity);
    }

    public int getShellIntegrity() {
        return (Integer)this.m_20088_().m_135370_(OUTER_SHELL_INTEGRITY);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new AIReturnHome(this));
        this.f_21345_.m_25352_(2, (Goal)new AttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new FaceRandomGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new HopGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 0, true, true, null));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 0, true, true, null));
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22278_, 1.0);
    }

    public void m_20258_(CompoundTag compound) {
        super.m_20258_(compound);
        BlockPos homePos = BlockPos.m_122022_((long)compound.m_128454_("HomePosition"));
        if (!homePos.equals((Object)BlockPos.f_121853_)) {
            this.m_21446_(homePos, 7);
        }
    }

    public CompoundTag m_20240_(CompoundTag compound) {
        if (this.m_21536_()) {
            compound.m_128356_("HomePosition", this.m_21534_().m_121878_());
        }
        super.m_7380_(compound);
        return super.m_20240_(compound);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_7639_() instanceof Player) {
            Player player = (Player)source.m_7639_();
            if (this.getPhase() >= 2 && player.m_21205_().canPerformAction(ToolActions.PICKAXE_DIG)) {
                if (!this.f_19853_.f_46443_ && 0.0f == player.m_36335_().m_41521_(player.m_21205_().m_41720_(), 1.0f)) {
                    player.m_36335_().m_41524_(player.m_21205_().m_41720_(), 10);
                    this.setLastMinedTick(this.f_19797_);
                    int shell = this.getShellIntegrity();
                    int reduce = this.m_6060_() ? 2 : 1;
                    this.setShellIntegrity(shell - reduce);
                    return true;
                }
                if (player.m_36335_().m_41521_(player.m_21205_().m_41720_(), 1.0f) != 0.0f) {
                    this.m_5496_(SoundEvents.f_12386_, 1.0f, 1.0f);
                    return true;
                }
            }
        }
        if (source.m_19378_()) {
            return super.m_6469_(source, amount);
        }
        if (this.getPhase() >= 2) {
            if (!this.f_19853_.f_46443_ && !this.m_6060_()) {
                this.m_5496_(SoundEvents.f_12386_, 0.1f, 0.1f);
            }
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public void m_6123_(Player entityIn) {
        super.m_6123_(entityIn);
        this.m_7327_((Entity)entityIn);
    }

    public void m_7334_(Entity entityIn) {
        super.m_7334_(entityIn);
        this.m_7327_(entityIn);
    }

    public boolean m_7327_(Entity entityIn) {
        boolean flag = super.m_7327_(entityIn);
        if (flag) {
            if (entityIn instanceof LivingEntity) {
                for (ItemStack itemstack : entityIn.m_6168_()) {
                    if (itemstack.m_41720_() instanceof ArmorItem && ((ArmorItem)itemstack.m_41720_()).m_40401_().equals(ArmorMaterials.IRON)) {
                        itemstack.m_41629_(30, ((LivingEntity)entityIn).m_21187_(), entityIn instanceof ServerPlayer ? (ServerPlayer)entityIn : null);
                    }
                    if (!itemstack.canPerformAction(ToolActions.PICKAXE_DIG)) continue;
                    if (itemstack.m_41720_() instanceof PickaxeItem) {
                        if (((PickaxeItem)itemstack.m_41720_()).m_43314_().equals(Tiers.IRON)) {
                            itemstack.m_41629_(75, ((LivingEntity)entityIn).m_21187_(), entityIn instanceof ServerPlayer ? (ServerPlayer)entityIn : null);
                            continue;
                        }
                        itemstack.m_41629_(5, ((LivingEntity)entityIn).m_21187_(), entityIn instanceof ServerPlayer ? (ServerPlayer)entityIn : null);
                        continue;
                    }
                    itemstack.m_41629_(25, ((LivingEntity)entityIn).m_21187_(), entityIn instanceof ServerPlayer ? (ServerPlayer)entityIn : null);
                }
                if (this.m_6060_()) {
                    entityIn.m_20254_(2);
                }
            }
            ((LivingEntity)entityIn).m_147240_((double)(2.0f * (float)this.getPhase()), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
            ((LivingEntity)entityIn).m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 2 + Mth.m_14143_((float)(this.maxPhase + 1.0f - (float)this.getPhase()))));
        }
        return flag;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag) {
        if (!this.m_21536_()) {
            this.m_21446_(this.m_142538_(), 7);
        }
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public boolean func_241845_aY() {
        return this.m_6084_();
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.f_19853_.f_46443_ && this.m_21187_().nextInt(20) == 0) {
            for (int i = 0; i < 2; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123764_, this.m_20208_(0.5), this.m_20187_() - 0.25, this.m_20262_(0.5), (this.f_19796_.nextDouble() - 0.5) * 2.0, -this.f_19796_.nextDouble(), (this.f_19796_.nextDouble() - 0.5) * 2.0);
            }
        }
        this.m_6210_();
        if (!this.f_19853_.f_46443_ && this.f_19797_ - this.getLastMinedTick() > 20) {
            this.setShellIntegrity(this.MaxTimeBreak);
        }
        if (this.getShellIntegrity() <= 0) {
            int actualPhase = this.getPhase();
            this.setPhase(--actualPhase);
            this.m_6034_(this.m_20185_(), this.m_20186_() + 0.25, this.m_20189_());
            if (actualPhase == 1) {
                this.m_6034_(this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_());
            }
            this.setShellIntegrity(this.MaxTimeBreak);
        }
    }

    protected void m_6763_(BlockState blockstate) {
        Block block = blockstate.m_60734_();
        if (block == Blocks.f_50033_) {
            EntityUtils.destroyBlocksInAABB((LivingEntity)this, block);
        }
        super.m_6763_(blockstate);
    }

    private void faceBlockPos(BlockPos pos) {
        double d0 = (double)pos.m_123341_() - this.m_20185_();
        double d2 = (double)pos.m_123343_() - this.m_20189_();
        double d1 = (double)pos.m_123342_() - this.m_20186_();
        double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
        float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
        float f1 = (float)(-(Mth.m_14136_((double)d1, (double)d3) * 57.29577951308232));
        this.m_146926_(f1);
        this.m_146922_(f);
    }

    public int getJumpDelay() {
        return 40;
    }

    public boolean makesSoundOnJump() {
        return true;
    }

    public boolean canDamagePlayer() {
        return true;
    }

    protected float m_6118_() {
        return this.m_20077_() ? 2.0f : 0.42f;
    }

    protected void m_21226_() {
        this.f_21364_ = (int)((long)this.f_21364_ + (long)Mth.m_14167_((float)((float)this.f_21364_ * 0.1f)) * this.bossInfo.m_8324_().stream().filter(EntitySelector.f_20406_).count());
        super.m_21226_();
    }

    public boolean m_6072_() {
        return false;
    }

    protected void m_8024_() {
        super.m_8024_();
        if (((Boolean)DungeonsModConfig.COMMON.scalingDifficulty.get()).booleanValue()) {
            this.difficultyManager.adjustDifficulty((LivingEntity)this, 0.5f, 0.0f, 0.2f, 0.0f, this.bossInfo.m_8324_());
            this.MaxTimeBreak = Mth.m_14143_((float)(8.0f * DifficultyManager.getTotalAttributePPP((LivingEntity)this, Attributes.f_22276_)));
        }
        float bonusDamage = 0.0f;
        if ((double)this.getPhase() <= 1.0) {
            bonusDamage = 11.0f;
            this.bossInfo.m_142711_(((float)this.getPhase() - (1.0f - this.m_21223_() / (float)this.MaxTimeBreak)) / this.maxPhase);
        } else {
            this.bossInfo.m_142711_(((float)this.getPhase() - (1.0f - (float)this.getShellIntegrity() / (float)this.MaxTimeBreak)) / this.maxPhase);
        }
        this.m_21051_(Attributes.f_22279_).m_22100_((double)((this.maxPhase + 1.0f - (float)this.getPhase()) * 0.08f + 0.5f));
        this.m_21051_(Attributes.f_22281_).m_22100_((double)((this.maxPhase + 1.0f - (float)this.getPhase()) * 2.0f + bonusDamage));
        if (this.f_19797_ % 20 == 0) {
            EntityUtils.scanBlocksInAABB((LivingEntity)this, this.m_142469_().m_82400_((double)0.1f), (blockPos, blockState) -> {
                int hardness = Mth.m_14045_((int)Mth.m_14143_((float)(blockState.m_60800_((BlockGetter)this.f_19853_, blockPos) * 0.66f)), (int)3, (int)Integer.MAX_VALUE);
                if (!blockState.m_60734_().equals(Blocks.f_50752_) && (double)blockPos.m_123342_() > this.m_20227_(0.1f) && this.f_19853_.f_46441_.nextInt(hardness) == 0) {
                    this.f_19853_.m_46961_(blockPos, false);
                }
                return false;
            });
        }
        float distance = Float.MAX_VALUE;
        for (Player player : this.bossInfo.m_8324_()) {
            distance = Math.min(player.m_20270_((Entity)this), distance);
            if (!(player.m_20270_((Entity)this) < 15.0f)) continue;
            player.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 100, 2));
        }
        if (distance > 7.0f) {
            this.m_5634_(1.0f);
        }
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
        if (this.bossInfo.m_8324_().isEmpty()) {
            this.m_21153_(this.m_21233_());
            Objects.requireNonNull(this);
            this.setPhase(5);
        }
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    protected SoundEvent getJumpSound() {
        return SoundEvents.f_12010_;
    }

    protected SoundEvent m_5896_(int heightIn) {
        return SoundEvents.f_11668_;
    }

    public EntityDimensions m_6972_(Pose entityPose) {
        return EntityDimensions.m_20395_((float)((float)this.getPhase() * 0.5f + 0.5f), (float)((float)this.getPhase() * 0.5f + 0.5f));
    }

    public void m_6043_() {
    }

    static class MoveHelperController
    extends MoveControl {
        private float yRot;
        private int jumpDelay;
        private final EntityIronSlime slime;
        private boolean isAggressive;

        public MoveHelperController(EntityIronSlime slimeIn) {
            super((Mob)slimeIn);
            this.slime = slimeIn;
            this.yRot = 180.0f * slimeIn.m_146908_() / (float)Math.PI;
        }

        public void setDirection(float yRotIn, boolean aggressive) {
            this.yRot = yRotIn;
            this.isAggressive = aggressive;
        }

        public void setSpeed(double speedIn) {
            this.f_24978_ = speedIn;
            this.f_24981_ = MoveControl.Operation.MOVE_TO;
        }

        public void m_8126_() {
            this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), this.yRot, 90.0f));
            this.f_24974_.f_20885_ = this.f_24974_.m_146908_();
            this.f_24974_.f_20883_ = this.f_24974_.m_146908_();
            if (this.f_24981_ != MoveControl.Operation.MOVE_TO) {
                this.f_24974_.m_21564_(0.0f);
            } else {
                this.f_24981_ = MoveControl.Operation.WAIT;
                if (this.f_24974_.m_20096_()) {
                    this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
                    if (this.jumpDelay-- <= 0) {
                        this.jumpDelay = this.slime.getJumpDelay();
                        if (this.isAggressive) {
                            this.jumpDelay /= 3;
                        }
                        this.slime.m_21569_().m_24901_();
                        if (this.slime.makesSoundOnJump()) {
                            this.slime.m_5496_(this.slime.getJumpSound(), this.slime.m_6121_() * 0.2f, 1.0f);
                        }
                    } else {
                        this.slime.f_20900_ = 0.0f;
                        this.slime.f_20902_ = 0.0f;
                        this.f_24974_.m_7910_(0.0f);
                    }
                } else {
                    this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
                }
            }
        }
    }

    static class FloatGoal
    extends Goal {
        private final EntityIronSlime slime;

        public FloatGoal(EntityIronSlime slimeIn) {
            this.slime = slimeIn;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
            slimeIn.m_21573_().m_7008_(true);
        }

        public boolean m_8036_() {
            return (this.slime.m_20069_() || this.slime.m_20077_()) && this.slime.m_21566_() instanceof MoveHelperController;
        }

        public void m_8037_() {
            if (this.slime.m_21187_().nextFloat() < 0.8f) {
                this.slime.m_21569_().m_24901_();
            }
            ((MoveHelperController)this.slime.m_21566_()).setSpeed(1.2);
        }
    }

    static class AIReturnHome
    extends Goal {
        private final EntityIronSlime slime;
        private int inflateTieredTimer;

        public AIReturnHome(EntityIronSlime slimeIn) {
            this.slime = slimeIn;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return !this.slime.m_21533_() && !this.slime.m_142538_().equals((Object)this.slime.m_21534_());
        }

        public void m_8056_() {
            super.m_8056_();
        }

        public boolean m_8045_() {
            boolean flag = false;
            flag = new AABB(this.slime.m_21534_()).m_82381_(this.slime.m_142469_());
            return !flag;
        }

        public void m_8037_() {
            this.slime.faceBlockPos(this.slime.m_21534_());
            ((MoveHelperController)this.slime.m_21566_()).setDirection(this.slime.m_146908_(), this.slime.canDamagePlayer());
        }
    }

    static class AttackGoal
    extends Goal {
        private final EntityIronSlime slime;
        private int inflateTieredTimer;

        public AttackGoal(EntityIronSlime slimeIn) {
            this.slime = slimeIn;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.slime.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            return livingentity instanceof Player && ((Player)livingentity).m_150110_().f_35934_ ? false : this.slime.m_21566_() instanceof MoveHelperController;
        }

        public void m_8056_() {
            this.inflateTieredTimer = 300;
            super.m_8056_();
        }

        public boolean m_8045_() {
            LivingEntity livingentity = this.slime.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            if (livingentity instanceof Player && ((Player)livingentity).m_150110_().f_35934_) {
                return false;
            }
            return --this.inflateTieredTimer > 0;
        }

        public void m_8037_() {
            this.slime.m_21391_((Entity)this.slime.m_5448_(), 10.0f, 10.0f);
            ((MoveHelperController)this.slime.m_21566_()).setDirection(this.slime.m_146908_(), this.slime.canDamagePlayer());
        }
    }

    static class FaceRandomGoal
    extends Goal {
        private final EntityIronSlime slime;
        private float chosenDegrees;
        private int nextRandomizeTime;

        public FaceRandomGoal(EntityIronSlime slimeIn) {
            this.slime = slimeIn;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.slime.m_5448_() == null && (this.slime.f_19861_ || this.slime.m_20069_() || this.slime.m_20077_() || this.slime.m_21023_(MobEffects.f_19620_)) && this.slime.m_21566_() instanceof MoveHelperController;
        }

        public void m_8037_() {
            if (--this.nextRandomizeTime <= 0) {
                this.nextRandomizeTime = 40 + this.slime.m_21187_().nextInt(60);
                this.chosenDegrees = this.slime.m_21187_().nextInt(360);
            }
            ((MoveHelperController)this.slime.m_21566_()).setDirection(this.chosenDegrees, false);
        }
    }

    static class HopGoal
    extends Goal {
        private final EntityIronSlime slime;

        public HopGoal(EntityIronSlime slimeIn) {
            this.slime = slimeIn;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return !this.slime.m_20159_();
        }

        public void m_8037_() {
            ((MoveHelperController)this.slime.m_21566_()).setSpeed(1.0);
        }
    }
}

