/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.entity.boss;

import com.dainxt.dungeonsmod.ai.AIScheduledTimedAction;
import com.dainxt.dungeonsmod.ai.AIToggableMultipleTargetGoal;
import com.dainxt.dungeonsmod.config.DungeonsModConfig;
import com.dainxt.dungeonsmod.difficulty.DifficultyManager;
import com.dainxt.dungeonsmod.entity.projectile.EntityItemThrow;
import com.dainxt.dungeonsmod.interfaces.IMultiTargetEntity;
import com.dainxt.dungeonsmod.items.KingsCrownItem;
import com.dainxt.dungeonsmod.util.EntityUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityKing
extends Monster
implements IMultiTargetEntity {
    DifficultyManager difficultyManager = new DifficultyManager();
    static final int MAX_HOME = 7;
    public ArrayList<BlockPos> SACRIFICE_PLACES;
    public ArrayList<BlockPos> BOOKSHELFS;
    public Map<BlockPos, BlockState> DESTROY_BLOCKS_2;
    public Map<BlockPos, BlockState> FIX_BLOCKS_2;
    public ArrayList<LivingEntity> otherAttackTargets = new ArrayList();
    private static final EntityDataAccessor<Boolean> THROWING = SynchedEntityData.m_135353_(EntityKing.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> REST = SynchedEntityData.m_135353_(EntityKing.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HEAVY_ATTACK = SynchedEntityData.m_135353_(EntityKing.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_WAITING_FOR_SACRIFICE = SynchedEntityData.m_135353_(EntityKing.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final ServerBossEvent bossInfo = (ServerBossEvent)new ServerBossEvent(this.m_7755_(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.NOTCHED_6).m_7003_(true);
    public AIReturnHome returnHome;
    public ThrowWeaponGoal throwGoal;
    public AIToggableMultipleTargetGoal<? extends LivingEntity> throwTarget;
    public AIToggableMultipleTargetGoal<? extends LivingEntity> bookShelfTarget;

    public EntityKing(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
        if (!worldIn.f_46443_) {
            this.DESTROY_BLOCKS_2 = new ConcurrentHashMap<BlockPos, BlockState>();
            this.FIX_BLOCKS_2 = new ConcurrentHashMap<BlockPos, BlockState>();
            this.SACRIFICE_PLACES = new ArrayList();
            this.BOOKSHELFS = new ArrayList();
            this.otherAttackTargets = new ArrayList();
        }
        this.m_21409_(EquipmentSlot.HEAD, 2.0f);
        this.m_21409_(EquipmentSlot.CHEST, 2.0f);
        this.m_21409_(EquipmentSlot.LEGS, 2.0f);
        this.m_21409_(EquipmentSlot.FEET, 2.0f);
        this.f_21364_ = 1000;
        this.m_21530_();
    }

    protected ResourceLocation m_7582_() {
        return DungeonsModConfig.COMMON.king.getDefaultLootTable();
    }

    protected void m_6851_(DifficultyInstance difficulty) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42434_));
        this.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
        this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42432_));
        this.m_21409_(EquipmentSlot.OFFHAND, 0.0f);
    }

    public ItemEntity m_5552_(ItemStack stack, float offsetY) {
        if (stack.m_41720_() instanceof KingsCrownItem) {
            long totalPlayers = this.bossInfo.m_8324_().stream().filter(EntitySelector.f_20406_).count();
            float totalChance = Mth.m_14036_((float)((float)((Double)DungeonsModConfig.COMMON.legendaryLootChance.get() * (double)totalPlayers)), (float)0.0f, (float)100.0f);
            if (this.f_19853_.m_5822_().nextFloat() < totalChance / 100.0f) {
                return super.m_5552_(stack, offsetY);
            }
            return super.m_5552_(ItemStack.f_41583_, offsetY);
        }
        return super.m_5552_(stack, offsetY);
    }

    public boolean m_7327_(Entity entityIn) {
        boolean flag = false;
        if (this.isHeavyAttacking()) {
            EquipmentSlot randomSlot;
            Item wearedItem;
            Player target;
            flag = entityIn.m_6469_(DamageSource.m_19370_((LivingEntity)this).m_19389_(), (float)this.m_21133_(Attributes.f_22281_));
            if (entityIn instanceof Player && !(target = (Player)entityIn).m_21254_() && (wearedItem = target.m_6844_(randomSlot = EquipmentSlot.m_20744_((EquipmentSlot.Type)EquipmentSlot.Type.ARMOR, (int)this.f_19853_.m_5822_().nextInt(4))).m_41720_()) instanceof ArmorItem && !((ArmorItem)wearedItem).m_40401_().equals(ArmorMaterials.GOLD)) {
                if (randomSlot.m_20750_() == 4) {
                    this.m_8061_(EquipmentSlot.HEAD, target.m_6844_(randomSlot));
                    ItemStack newPiece = new ItemStack((ItemLike)Items.f_42476_);
                    newPiece.m_41663_(Enchantments.f_44975_, 1);
                    target.m_8061_(EquipmentSlot.HEAD, newPiece);
                } else if (randomSlot.m_20750_() == 3) {
                    this.m_8061_(EquipmentSlot.CHEST, target.m_6844_(randomSlot));
                    ItemStack newPiece = new ItemStack((ItemLike)Items.f_42477_);
                    newPiece.m_41663_(Enchantments.f_44975_, 1);
                    target.m_8061_(EquipmentSlot.CHEST, newPiece);
                } else if (randomSlot.m_20750_() == 2) {
                    this.m_8061_(EquipmentSlot.LEGS, target.m_6844_(randomSlot));
                    ItemStack newPiece = new ItemStack((ItemLike)Items.f_42478_);
                    newPiece.m_41663_(Enchantments.f_44975_, 1);
                    target.m_8061_(EquipmentSlot.LEGS, newPiece);
                } else if (randomSlot.m_20750_() == 1) {
                    this.m_8061_(EquipmentSlot.FEET, target.m_6844_(randomSlot));
                    ItemStack newPiece = new ItemStack((ItemLike)Items.f_42479_);
                    newPiece.m_41663_(Enchantments.f_44975_, 1);
                    target.m_8061_(EquipmentSlot.FEET, newPiece);
                }
            }
            this.setHeavyAttack(false);
        } else {
            flag = super.m_7327_(entityIn);
        }
        LivingEntity a = (LivingEntity)entityIn;
        a.m_20184_().m_82526_(Vec3.f_82478_);
        return flag;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(THROWING, (Object)false);
        this.f_19804_.m_135372_(HEAVY_ATTACK, (Object)false);
        this.f_19804_.m_135372_(IS_WAITING_FOR_SACRIFICE, (Object)false);
        this.f_19804_.m_135372_(REST, (Object)true);
    }

    public boolean isHeavyAttacking() {
        return (Boolean)this.m_20088_().m_135370_(HEAVY_ATTACK);
    }

    public void setHeavyAttack(boolean attack) {
        this.m_20088_().m_135381_(HEAVY_ATTACK, (Object)attack);
    }

    public boolean isWaitingSacrifice() {
        return (Boolean)this.m_20088_().m_135370_(IS_WAITING_FOR_SACRIFICE);
    }

    public void setWaitingSacrifice(boolean attack) {
        this.m_20088_().m_135381_(IS_WAITING_FOR_SACRIFICE, (Object)attack);
    }

    public boolean isResting() {
        return (Boolean)this.m_20088_().m_135370_(REST);
    }

    public void setRest(boolean attack) {
        this.m_20088_().m_135381_(REST, (Object)attack);
    }

    public boolean isThrowingWeapon() {
        return (Boolean)this.m_20088_().m_135370_(THROWING);
    }

    public void setThrowingWeapon(boolean attack) {
        this.m_20088_().m_135381_(THROWING, (Object)attack);
    }

    @Override
    public void setAttackTargets(ArrayList<LivingEntity> players) {
        this.otherAttackTargets = players;
    }

    @Override
    public ArrayList<LivingEntity> getAttackTargets() {
        return this.otherAttackTargets;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficulty, MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag) {
        this.m_6034_((int)this.m_20185_(), this.m_20186_(), (int)this.m_20189_());
        if (!this.m_21536_()) {
            this.m_21446_(this.m_142538_(), 7);
        }
        this.m_6851_(difficulty);
        return super.m_6518_(worldIn, difficulty, reason, spawnDataIn, dataTag);
    }

    public void m_20258_(CompoundTag compound) {
        int i;
        CompoundTag nbt;
        super.m_20258_(compound);
        BlockPos homePos = BlockPos.m_122022_((long)compound.m_128454_("HomePosition"));
        if (!homePos.equals((Object)BlockPos.f_121853_)) {
            this.m_21446_(homePos, 7);
        }
        this.setWaitingSacrifice(compound.m_128471_("WaitSac"));
        this.setHeavyAttack(compound.m_128471_("HeavyAttack"));
        if (!this.f_19853_.f_46443_) {
            nbt = compound.m_128469_("sacPos");
            for (i = 0; i < nbt.m_128451_("index"); ++i) {
                this.SACRIFICE_PLACES.add(BlockPos.m_122022_((long)nbt.m_128454_("sacrifice_" + i)));
            }
        }
        if (!this.f_19853_.f_46443_) {
            nbt = compound.m_128469_("shelfPos");
            for (i = 0; i < nbt.m_128451_("index"); ++i) {
                this.BOOKSHELFS.add(BlockPos.m_122022_((long)nbt.m_128454_("shelf_" + i)));
            }
        }
    }

    public CompoundTag m_20240_(CompoundTag compound) {
        int i;
        CompoundTag nbt;
        if (this.m_21536_()) {
            compound.m_128356_("HomePosition", this.m_21534_().m_121878_());
        }
        compound.m_128379_("WaitSac", this.isWaitingSacrifice());
        compound.m_128379_("HeavyAttack", this.isHeavyAttacking());
        if (!this.f_19853_.f_46443_) {
            nbt = compound.m_128469_("sacPos");
            nbt.m_128405_("index", this.SACRIFICE_PLACES.size());
            for (i = 0; i < this.SACRIFICE_PLACES.size(); ++i) {
                nbt.m_128356_("sacrifice_" + i, this.SACRIFICE_PLACES.get(i).m_121878_());
            }
            compound.m_128365_("sacPos", (Tag)nbt);
        }
        if (!this.f_19853_.f_46443_) {
            nbt = compound.m_128469_("shelfPos");
            nbt.m_128405_("index", this.BOOKSHELFS.size());
            for (i = 0; i < this.BOOKSHELFS.size(); ++i) {
                nbt.m_128356_("shelf_" + i, this.BOOKSHELFS.get(i).m_121878_());
            }
            compound.m_128365_("shelfPos", (Tag)nbt);
        }
        return super.m_20240_(compound);
    }

    protected float m_6118_() {
        return this.isHeavyAttacking() ? 10.0f : super.m_6118_();
    }

    protected void m_8099_() {
        this.throwGoal = new ThrowWeaponGoal(this, 40, 100);
        this.throwTarget = new AIToggableMultipleTargetGoal<Player>((Mob)this, Player.class);
        this.bookShelfTarget = new AIToggableMultipleTargetGoal<Player>((Mob)this, Player.class);
        this.f_21345_.m_25352_(0, (Goal)new AIFellMad(this, 1200, 800));
        this.f_21345_.m_25352_(1, (Goal)new AIDoHeavyAttack(this, 60, 180));
        this.f_21345_.m_25352_(1, (Goal)this.throwGoal);
        this.returnHome = new AIReturnHome(this);
        this.f_21345_.m_25352_(2, (Goal)this.returnHome);
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f, 0.0f));
        this.f_21345_.m_25352_(6, (Goal)new BookShelfAttackGoal(this, 40, 200, 3));
        this.f_21346_.m_25352_(1, this.throwTarget);
        this.f_21346_.m_25352_(2, this.bookShelfTarget);
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 0, true, true, null));
        this.f_21346_.m_25352_(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 80.0).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22279_, 0.22).m_22268_(Attributes.f_22277_, 18.0).m_22268_(Attributes.f_22284_, 15.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_7640_() instanceof Arrow) {
            ((Arrow)source.m_7640_()).m_36735_(0);
        }
        if (source.equals(DamageSource.f_19310_)) {
            EntityUtils.scanBlocksInAABB((LivingEntity)this, (blockPos, blockState) -> {
                Block block = blockState.m_60734_();
                if (!block.equals(Blocks.f_50752_)) {
                    this.f_19853_.m_46597_(blockPos, Blocks.f_50016_.m_49966_());
                }
                return false;
            });
        }
        return super.m_6469_(source, amount);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.f_19853_.f_46443_) {
            for (int i = 0; i < 2; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123809_, this.m_20208_(0.5), this.m_20187_() - 0.25, this.m_20262_(0.5), (this.f_19796_.nextDouble() - 0.5) * 2.0, -this.f_19796_.nextDouble(), (this.f_19796_.nextDouble() - 0.5) * 2.0);
            }
        }
    }

    private void destroyPosInAABB(AABB axisBB, Map<BlockPos, BlockState> blockPos, boolean shouldDrop) {
        for (Map.Entry<BlockPos, BlockState> entrySet : blockPos.entrySet()) {
            if (!axisBB.m_82381_(new AABB(entrySet.getKey()))) continue;
            if (!this.SACRIFICE_PLACES.contains(entrySet.getKey()) || !this.isWaitingSacrifice() || Blocks.f_50074_ == entrySet.getValue().m_60734_()) {
                this.m_6674_(InteractionHand.MAIN_HAND);
                this.f_19853_.m_46961_(entrySet.getKey(), false);
            }
            blockPos.remove(entrySet.getKey());
        }
    }

    private void placePosInAABB(AABB axisBB, Map<BlockPos, BlockState> blockPos, boolean shouldDrop) {
        for (Map.Entry<BlockPos, BlockState> entrySet : blockPos.entrySet()) {
            if (!axisBB.m_82381_(new AABB(entrySet.getKey()))) continue;
            if (!this.SACRIFICE_PLACES.contains(entrySet.getKey()) || !this.isWaitingSacrifice() || Blocks.f_50074_ == entrySet.getValue().m_60734_()) {
                this.m_6674_(InteractionHand.MAIN_HAND);
                this.f_19853_.m_46597_(entrySet.getKey(), entrySet.getValue());
            }
            blockPos.remove(entrySet.getKey());
        }
    }

    public boolean goHome(float speed) {
        BlockPos pos = this.m_21534_();
        if (!this.m_142538_().equals((Object)pos) && !this.m_21573_().m_26519_((double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), (double)speed)) {
            this.m_20256_(Vec3.f_82478_);
            this.m_6034_(pos.m_123341_(), (float)pos.m_123342_() + 0.1f, pos.m_123343_());
        }
        return new AABB(this.m_21534_()).m_82381_(this.m_142469_());
    }

    protected void m_6763_(BlockState blockstate) {
        Block block = blockstate.m_60734_();
        if (block == Blocks.f_50125_ || block instanceof LiquidBlock) {
            EntityUtils.scanBlocksInAABB((LivingEntity)this, this.m_142469_().m_82400_(1.0), (blockPos, blockState) -> {
                if (!blockState.m_60734_().equals(Blocks.f_50752_) && block.equals(blockState.m_60734_())) {
                    this.f_19853_.m_46597_(blockPos, Blocks.f_50016_.m_49966_());
                }
                return false;
            });
            this.m_6674_(InteractionHand.MAIN_HAND);
        }
        super.m_6763_(blockstate);
    }

    public static DamageSource causeKingDamage(Entity source, @Nullable Entity indirectEntityIn) {
        return new IndirectEntityDamageSource("kingRuleBreak", source, indirectEntityIn).m_19380_().m_19389_();
    }

    public void m_6667_(DamageSource cause) {
        if (!this.f_19853_.f_46443_ && this.isWaitingSacrifice()) {
            this.m_21409_(EquipmentSlot.HEAD, 0.0f);
            this.m_21409_(EquipmentSlot.CHEST, 0.0f);
            this.m_21409_(EquipmentSlot.LEGS, 0.0f);
            this.m_21409_(EquipmentSlot.FEET, 0.0f);
            BlockPos pos = this.m_142538_();
            this.f_20890_ = true;
            this.f_19853_.m_46511_((Entity)this, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 40.0f, Explosion.BlockInteraction.DESTROY);
            this.f_19853_.m_7731_(pos, Blocks.f_50087_.m_49966_(), 3);
            Arrays.stream(Direction.values()).forEach(facing -> this.f_19853_.m_7731_(pos.m_142300_(facing), Blocks.f_50080_.m_49966_(), 3));
            BlockEntity tileentity = this.f_19853_.m_7702_(pos);
            if (tileentity instanceof ChestBlockEntity) {
                ((ChestBlockEntity)tileentity).m_6836_(11, this.m_6844_(EquipmentSlot.HEAD));
                ((ChestBlockEntity)tileentity).m_6836_(12, this.m_6844_(EquipmentSlot.CHEST));
                ((ChestBlockEntity)tileentity).m_6836_(14, this.m_6844_(EquipmentSlot.LEGS));
                ((ChestBlockEntity)tileentity).m_6836_(15, this.m_6844_(EquipmentSlot.FEET));
            }
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        super.m_6667_(cause);
    }

    protected void m_21226_() {
        this.f_21364_ = (int)((long)this.f_21364_ + (long)Mth.m_14167_((float)((float)this.f_21364_ * 0.1f)) * this.bossInfo.m_8324_().stream().filter(EntitySelector.f_20406_).count());
        super.m_21226_();
    }

    public boolean m_6072_() {
        return false;
    }

    protected void m_8024_() {
        super.m_8024_();
        if (((Boolean)DungeonsModConfig.COMMON.scalingDifficulty.get()).booleanValue()) {
            this.difficultyManager.adjustDifficulty((LivingEntity)this, 0.3f, 0.1f, 0.05f, 0.1f, this.bossInfo.m_8324_());
        }
        if (this.m_5448_() != null) {
            this.setRest(false);
        }
        if (this.isResting()) {
            this.m_146922_(-90.0f);
            this.f_20885_ = -90.0f;
        }
        if (!this.DESTROY_BLOCKS_2.isEmpty()) {
            this.destroyPosInAABB(this.m_142469_().m_82400_(3.5), this.DESTROY_BLOCKS_2, true);
        }
        if (!this.FIX_BLOCKS_2.isEmpty()) {
            this.placePosInAABB(this.m_142469_().m_82400_(3.5), this.FIX_BLOCKS_2, true);
        }
        float distance = Float.MAX_VALUE;
        for (Player player : this.getPlayers()) {
            if (player.m_21211_().m_41720_().m_41472_()) {
                this.throwGoal.setLethalEnemy((LivingEntity)player);
            }
            distance = Math.min(player.m_20270_((Entity)this), distance);
        }
        if (distance > 7.0f && this.returnHome != null) {
            this.returnHome.forceUpdate();
            if (!this.isWaitingSacrifice()) {
                this.m_5634_(this.m_21233_() * 5.0E-4f);
            }
        }
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
        if (this.bossInfo.m_8324_().isEmpty()) {
            this.m_21153_(this.m_21233_());
        }
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public List<ServerPlayer> getPlayers() {
        return this.bossInfo.m_8324_().stream().filter(EntitySelector.f_20406_).collect(Collectors.toList());
    }

    public float m_6100_() {
        return 0.2f;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12509_;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12507_;
    }

    public void m_6043_() {
    }

    static class ThrowWeaponGoal
    extends AIScheduledTimedAction {
        private final EntityKing goalOwner;
        private LivingEntity target = null;
        private boolean isLethal = false;

        public ThrowWeaponGoal(EntityKing entity, int maxDuration, int maxCooldown) {
            super((LivingEntity)entity, maxDuration, maxCooldown);
            this.goalOwner = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        @Override
        public boolean m_8036_() {
            return this.goalOwner.m_5448_() != null && super.m_8036_() || this.isLethal;
        }

        public void setLethalEnemy(LivingEntity enemy) {
            this.target = enemy;
            this.isLethal = true;
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            this.goalOwner.throwTarget.func_220783_a(true);
            this.goalOwner.setThrowingWeapon(true);
        }

        public void m_8037_() {
            super.m_8037_();
            if (this.target == null) {
                LivingEntity potential;
                if (!this.goalOwner.getAttackTargets().isEmpty() && (potential = this.goalOwner.getAttackTargets().get(this.goalOwner.f_19796_.nextInt(this.goalOwner.getAttackTargets().size()))) != null && this.target != this.goalOwner.m_5448_()) {
                    this.target = potential;
                }
            } else {
                this.goalOwner.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
            }
        }

        @Override
        public void onStartCycle() {
            if (this.target != null) {
                if (!this.goalOwner.m_20067_()) {
                    SoundEvent soundevent = SoundEvents.f_11877_;
                    this.goalOwner.m_5496_(soundevent, 20.0f, 0.2f);
                }
                Vec3 originalPos = this.goalOwner.m_20299_(1.0f);
                Vec3 direction = Vec3.f_82478_.m_82520_(1.0, -0.75, 1.0).m_82490_(1.5).m_82524_(-this.goalOwner.f_20883_ * ((float)Math.PI / 180));
                Vec3 finalPos = originalPos.m_82549_(direction);
                Vec3 difference = this.target.m_20299_(1.0f).m_82546_(finalPos);
                EntityItemThrow projectile = new EntityItemThrow(this.goalOwner.f_19853_, this.goalOwner.m_6844_(EquipmentSlot.OFFHAND), (impactProjectile, entity) -> {
                    if (!this.isLethal) {
                        entity.m_6469_(DamageSource.m_19367_((Entity)impactProjectile, (Entity)this.goalOwner), 1.0f * entity.m_20270_((Entity)this.goalOwner));
                    } else {
                        entity.m_6469_(EntityKing.causeKingDamage(impactProjectile, (Entity)this.goalOwner).m_19382_().m_19380_(), entity.m_21233_() * 0.75f);
                    }
                });
                projectile.m_6034_(finalPos.f_82479_, finalPos.f_82480_, finalPos.f_82481_);
                projectile.m_5602_((Entity)this.goalOwner);
                projectile.m_6686_(difference.f_82479_, difference.f_82480_, difference.f_82481_, this.isLethal ? 4.5f : 1.5f, 0.0f);
                this.goalOwner.f_19853_.m_7967_((Entity)projectile);
            }
        }

        @Override
        public void m_8041_() {
            super.m_8041_();
            this.isLethal = false;
            this.target = null;
            this.goalOwner.throwTarget.func_220783_a(false);
            this.goalOwner.setThrowingWeapon(false);
        }
    }

    class AIFellMad
    extends AIScheduledTimedAction {
        EntityKing king;
        float initialHealth;

        public AIFellMad(EntityKing entity, int maxDuration, int maxCooldown) {
            super((LivingEntity)entity, maxDuration, maxCooldown);
            this.king = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        @Override
        public boolean m_8036_() {
            if (this.king.m_5448_() != null) {
                return super.m_8036_();
            }
            return false;
        }

        @Override
        public boolean m_8045_() {
            return super.m_8045_() && this.king.isWaitingSacrifice();
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            this.king.setWaitingSacrifice(true);
            this.king.m_20260_(true);
            this.initialHealth = this.king.m_21223_();
        }

        public void m_8037_() {
            super.m_8037_();
            if (this.king.goHome(2.0f)) {
                for (BlockPos pos : this.king.SACRIFICE_PLACES) {
                    if (Blocks.f_50074_ != this.attacker.f_19853_.m_8055_(pos).m_60734_()) continue;
                    this.king.setWaitingSacrifice(false);
                    this.attacker.f_19853_.m_46961_(pos, false);
                    break;
                }
                if (this.king.isWaitingSacrifice()) {
                    this.king.m_6469_(DamageSource.f_19319_, 10.0f);
                }
            }
        }

        @Override
        public void m_8041_() {
            super.m_8041_();
            this.king.setWaitingSacrifice(false);
            this.king.m_20260_(false);
            this.attacker.m_21153_(this.initialHealth);
        }
    }

    class AIDoHeavyAttack
    extends AIScheduledTimedAction {
        EntityKing king;

        public AIDoHeavyAttack(EntityKing entity, int maxDuration, int maxCooldown) {
            super((LivingEntity)entity, maxDuration, maxCooldown);
            this.king = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        @Override
        public boolean m_8036_() {
            if (this.king.m_5448_() != null) {
                return super.m_8036_();
            }
            return false;
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            this.king.setHeavyAttack(true);
        }

        public void m_8037_() {
            super.m_8037_();
            Vec3 originalPos = this.king.m_20299_(1.0f);
            Vec3 direction = this.king.m_20252_(1.0f).m_82490_(2.5);
            Vec3 finalPos = originalPos.m_82549_(direction);
            ((ServerLevel)this.king.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123759_, finalPos.m_7096_(), finalPos.m_7098_() - 0.5, finalPos.m_7094_(), 4, (this.king.f_19796_.nextDouble() - 0.5) * 2.0, -this.king.f_19796_.nextDouble(), (this.king.f_19796_.nextDouble() - 0.5) * 2.0, (this.king.f_19796_.nextDouble() - 0.5) * 2.0);
        }

        @Override
        public void onStartCycle() {
            super.onStartCycle();
        }

        @Override
        public void m_8041_() {
            super.m_8041_();
        }
    }

    static class AIReturnHome
    extends Goal {
        private boolean force;
        private final EntityKing slime;

        public void forceUpdate() {
            this.force = true;
        }

        public AIReturnHome(EntityKing slimeIn) {
            this.slime = slimeIn;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return !this.slime.m_21533_() && !this.slime.m_142538_().equals((Object)this.slime.m_21534_()) || this.force;
        }

        public void m_8056_() {
            this.force = false;
            super.m_8056_();
        }

        public boolean m_8045_() {
            boolean flag;
            boolean bl = flag = !this.slime.goHome(1.5f);
            if (!flag) {
                this.slime.setRest(true);
            }
            return flag;
        }

        public void m_8041_() {
            super.m_8041_();
        }
    }

    static class BookShelfAttackGoal
    extends AIScheduledTimedAction {
        private final EntityKing goalOwner;
        List<LivingEntity> targets;

        public BookShelfAttackGoal(EntityKing entity, int maxDuration, int maxCooldown, int times) {
            super((LivingEntity)entity, maxDuration, maxCooldown, times);
            this.goalOwner = entity;
            this.targets = new ArrayList<LivingEntity>();
        }

        @Override
        public boolean m_8036_() {
            return this.goalOwner.m_5448_() != null && super.m_8036_();
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            this.goalOwner.bookShelfTarget.func_220783_a(true);
        }

        public void m_8037_() {
            super.m_8037_();
            int maxShelfs = Mth.m_14143_((float)(6.0f * (1.0f - this.goalOwner.m_21223_() / this.goalOwner.m_21233_()))) + 1;
            if (this.targets.isEmpty()) {
                this.targets = this.goalOwner.getAttackTargets().stream().collect(Collectors.toList());
            }
            if (this.goalOwner.BOOKSHELFS.isEmpty()) {
                for (int i = 1; i <= maxShelfs; ++i) {
                    BlockPos shelfPos;
                    Collections.shuffle(this.targets);
                    LivingEntity target = null;
                    if (!this.targets.isEmpty()) {
                        target = this.targets.get(0);
                    }
                    if (target == null || (shelfPos = new BlockPos(target.m_20208_(3.0), target.m_20186_() + 5.0, this.goalOwner.m_20262_(3.0))) == null || this.goalOwner.f_19853_.m_8055_(shelfPos).m_60734_() == Blocks.f_50078_) continue;
                    if (!this.goalOwner.m_20067_()) {
                        this.goalOwner.f_19853_.m_5594_(null, shelfPos, SoundEvents.f_12632_, SoundSource.HOSTILE, 20.0f, 0.5f);
                    }
                    ((ServerLevel)this.goalOwner.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123759_, (double)shelfPos.m_123341_(), (double)shelfPos.m_123342_(), (double)shelfPos.m_123343_(), 4, (this.goalOwner.f_19796_.nextDouble() - 0.5) * 2.0, -this.goalOwner.f_19796_.nextDouble(), (this.goalOwner.f_19796_.nextDouble() - 0.5) * 2.0, (this.goalOwner.f_19796_.nextDouble() - 0.5) * 2.0);
                    this.goalOwner.f_19853_.m_46597_(shelfPos, Blocks.f_50078_.m_49966_());
                    this.goalOwner.BOOKSHELFS.add(shelfPos);
                }
            }
        }

        @Override
        public void onStartCycle() {
            this.goalOwner.BOOKSHELFS.forEach(shelfPos -> {
                Collections.shuffle(this.targets);
                LivingEntity target = null;
                if (!this.targets.isEmpty()) {
                    target = this.targets.get(0);
                }
                if (target != null) {
                    EntityItemThrow projectile = new EntityItemThrow(this.goalOwner.f_19853_, new ItemStack((ItemLike)Items.f_42517_), (impactProjectile, entity) -> entity.m_6469_(EntityKing.causeKingDamage(impactProjectile, (Entity)this.goalOwner), 10.0f));
                    if (!this.goalOwner.m_20067_()) {
                        this.goalOwner.f_19853_.m_5594_(null, shelfPos, SoundEvents.f_11887_, SoundSource.HOSTILE, 20.0f, 0.5f);
                    }
                    Vec3 finalPos = new Vec3((double)shelfPos.m_123341_(), (double)((float)shelfPos.m_123342_() - 1.0f), (double)shelfPos.m_123343_());
                    Vec3 difference = target.m_20299_(1.0f).m_82546_(finalPos);
                    projectile.m_6034_(finalPos.f_82479_, finalPos.f_82480_, finalPos.f_82481_);
                    projectile.m_5602_((Entity)this.goalOwner);
                    projectile.m_6686_(difference.f_82479_, difference.f_82480_, difference.f_82481_, 0.75f, 0.0f);
                    this.goalOwner.f_19853_.m_7967_((Entity)projectile);
                }
            });
        }

        @Override
        public void m_8041_() {
            super.m_8041_();
            this.goalOwner.BOOKSHELFS.forEach(shelfPos -> {
                if (shelfPos != null) {
                    this.goalOwner.f_19853_.m_46597_(shelfPos, Blocks.f_50016_.m_49966_());
                    if (!this.goalOwner.m_20067_()) {
                        this.goalOwner.f_19853_.m_5594_(null, shelfPos, SoundEvents.f_12631_, SoundSource.HOSTILE, 20.0f, 0.5f);
                    }
                    ((ServerLevel)this.goalOwner.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123759_, (double)shelfPos.m_123341_(), (double)shelfPos.m_123342_(), (double)shelfPos.m_123343_(), 4, (this.goalOwner.f_19796_.nextDouble() - 0.5) * 2.0, -this.goalOwner.f_19796_.nextDouble(), (this.goalOwner.f_19796_.nextDouble() - 0.5) * 2.0, (this.goalOwner.f_19796_.nextDouble() - 0.5) * 2.0);
                }
            });
            this.goalOwner.BOOKSHELFS.clear();
            this.targets.clear();
            this.goalOwner.bookShelfTarget.func_220783_a(false);
        }
    }
}

