/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.entity.boss;

import com.dainxt.dungeonsmod.config.DungeonsModConfig;
import com.dainxt.dungeonsmod.difficulty.DifficultyManager;
import com.dainxt.dungeonsmod.entity.EntityExtraPart;
import com.dainxt.dungeonsmod.interfaces.IEntityExtraPart;
import com.dainxt.dungeonsmod.util.EntityUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

public class EntityKraken
extends Monster
implements IEntityExtraPart {
    DifficultyManager difficultyManager = new DifficultyManager();
    public ArrayList<EntityExtraPart> extraParts;
    private final ServerBossEvent bossInfo = (ServerBossEvent)new ServerBossEvent(this.m_7755_(), BossEvent.BossBarColor.BLUE, BossEvent.BossBarOverlay.PROGRESS).m_7003_(true);
    protected KrakenMoveRandomGoal wander;

    public EntityKraken(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
        this.extraParts = new ArrayList();
        this.f_19811_ = true;
        this.f_21364_ = 700;
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.OPEN, -1.0f);
        this.f_21342_ = new MoveHelperController(this);
        this.m_21530_();
    }

    protected ResourceLocation m_7582_() {
        return DungeonsModConfig.COMMON.kraken.getDefaultLootTable();
    }

    public ItemEntity m_5552_(ItemStack stack, float offsetY) {
        if (stack.m_41720_() instanceof ShieldItem) {
            long totalPlayers = this.bossInfo.m_8324_().stream().filter(EntitySelector.f_20406_).count();
            float totalChance = Mth.m_14036_((float)((float)((Double)DungeonsModConfig.COMMON.legendaryLootChance.get() * (double)totalPlayers)), (float)0.0f, (float)100.0f);
            if (this.f_19853_.m_5822_().nextFloat() < totalChance / 100.0f) {
                return super.m_5552_(stack, offsetY);
            }
            return super.m_5552_(ItemStack.f_41583_, offsetY);
        }
        return super.m_5552_(stack, offsetY);
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new WaterBoundPathNavigation((Mob)this, worldIn);
    }

    public boolean m_5842_() {
        return this.m_20069_();
    }

    public boolean m_6040_() {
        return true;
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public float m_5610_(BlockPos pos, LevelReader worldIn) {
        return worldIn.m_6425_(pos).m_76153_((Tag)FluidTags.f_13131_) ? 10.0f + worldIn.m_46863_(pos) - 0.5f : super.m_5610_(pos, worldIn);
    }

    protected void m_7324_(Entity entityIn) {
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean isNotColliding(LevelReader worldIn) {
        return true;
    }

    public boolean m_7327_(Entity entityIn) {
        boolean flag = super.m_7327_(entityIn);
        if (flag && entityIn instanceof Player && this.getCustomParts().stream().anyMatch(part -> part.isAlivePart()) && this.m_21187_().nextInt(3) == 0) {
            entityIn.m_20256_(entityIn.m_20184_().m_82549_(new Vec3(0.0, 30.0, 0.0)));
            ((LivingEntity)entityIn).m_7292_(new MobEffectInstance(MobEffects.f_19604_, 200, 1));
            ((LivingEntity)entityIn).m_7292_(new MobEffectInstance(MobEffects.f_19612_, 100, 5));
        }
        return flag;
    }

    protected void m_8099_() {
        super.m_8099_();
        MoveTowardsRestrictionGoal movetowardsrestrictiongoal = new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0);
        this.wander = new KrakenMoveRandomGoal((PathfinderMob)this, 1.0, 60);
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(5, (Goal)movetowardsrestrictiongoal);
        this.f_21345_.m_25352_(7, (Goal)this.wander);
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 20.0f, 1.0f));
        this.wander.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        movetowardsrestrictiongoal.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 0, false, false, (Predicate)((Object)new KrakenTargetSelector(this))));
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_6142_()) {
            this.m_19920_(0.1f, travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5448_() == null) {
                if (this.m_21691_() && this.f_19800_) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, 0.01, 0.0));
                }
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            } else if (this.f_19800_) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, 0.001 * (this.m_5448_().m_20186_() - this.m_20182_().m_7098_()), 0.0));
            }
        } else {
            super.m_7023_(travelVector);
        }
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 200.0).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22277_, 30.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag) {
        EntityExtraPart krakenPartTentacle1 = new EntityExtraPart((Mob)this, "tentacle1", 6.0f, 6.0f);
        EntityExtraPart krakenPartTentacle2 = new EntityExtraPart((Mob)this, "tentacle2", 6.0f, 6.0f);
        EntityExtraPart krakenPartTentacle3 = new EntityExtraPart((Mob)this, "tentacle3", 6.0f, 6.0f);
        EntityExtraPart krakenPartTentacle4 = new EntityExtraPart((Mob)this, "tentacle4", 6.0f, 6.0f);
        EntityExtraPart krakenPartTentacle5 = new EntityExtraPart((Mob)this, "tentacle5", 6.0f, 6.0f);
        EntityExtraPart krakenPartTentacle6 = new EntityExtraPart((Mob)this, "tentacle6", 6.0f, 6.0f);
        EntityExtraPart krakenPartTentacle7 = new EntityExtraPart((Mob)this, "tentacle7", 6.0f, 6.0f);
        EntityExtraPart krakenPartTentacle8 = new EntityExtraPart((Mob)this, "tentacle8", 6.0f, 6.0f);
        this.extraParts.addAll(Arrays.asList(krakenPartTentacle1, krakenPartTentacle2, krakenPartTentacle3, krakenPartTentacle4, krakenPartTentacle5, krakenPartTentacle6, krakenPartTentacle7, krakenPartTentacle8));
        this.spawnExtraParts(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void spawnExtraParts(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag) {
        for (EntityExtraPart extraPart : this.extraParts) {
            extraPart.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
            extraPart.m_6518_(worldIn, difficultyIn, reason, new EntityExtraPart.GroupData(EntityExtraPart.ExtraPartType.TENTACLE), dataTag);
            worldIn.m_7967_((Entity)extraPart);
        }
    }

    public Vec3 getPositionFromVector(Vec3 origin, float yawOffset, float pitchOffset, double distanceOrigin) {
        float yaw = this.f_20883_ + yawOffset;
        float pitch = this.f_19860_ + pitchOffset;
        float yawSin = Mth.m_14031_((float)((float)((double)yaw * (Math.PI / 180))));
        float yawCos = Mth.m_14089_((float)((float)((double)yaw * (Math.PI / 180))));
        float pitchSin = Mth.m_14031_((float)((float)((double)pitch * (Math.PI / 180))));
        float pitchCos = Mth.m_14089_((float)((float)((double)pitch * (Math.PI / 180))));
        double tentaclePosX = origin.f_82479_ - (double)yawSin * (distanceOrigin * (double)Mth.m_14154_((float)pitchCos));
        double tentaclePosZ = origin.f_82481_ + (double)yawCos * (distanceOrigin * (double)Mth.m_14154_((float)pitchCos));
        double tentaclePosY = origin.f_82480_ - (double)pitchSin * distanceOrigin;
        return new Vec3(tentaclePosX, tentaclePosY, tentaclePosZ);
    }

    public void setPartBoundingPosition(EntityExtraPart tentacle, float yawOffset, float pitchOffset, double distanceOrigin) {
        Vec3 origin = this.m_20182_();
        origin = origin.m_82520_(0.0, (this.m_142469_().f_82292_ - this.m_142469_().f_82289_) / 2.0, 0.0);
        this.setPartBoundingPosition(tentacle, origin, yawOffset, pitchOffset, distanceOrigin);
    }

    public void setPartBoundingPosition(EntityExtraPart tentacle, Vec3 origin, float yawOffset, float pitchOffset, double distanceOrigin) {
        if (tentacle != null && tentacle.m_6084_()) {
            Vec3 finalPos = this.getPositionFromVector(origin, yawOffset, pitchOffset, distanceOrigin);
            Vec3 finalTentaclePos = new Vec3(finalPos.f_82479_, finalPos.f_82480_ - (double)(tentacle.m_20206_() / 2.0f), finalPos.f_82481_);
            tentacle.m_20256_(Vec3.f_82478_);
            tentacle.m_19890_(finalTentaclePos.f_82479_, finalTentaclePos.f_82480_, finalTentaclePos.f_82481_, 0.0f, 0.0f);
            tentacle.m_20256_(Vec3.f_82478_);
        }
    }

    public void m_8107_() {
        super.m_8107_();
        for (EntityExtraPart extraPart : this.getCustomParts()) {
            switch (extraPart.getPartName()) {
                case "tentacle1": {
                    this.setPartBoundingPosition(extraPart, 20.0f, 0.0f, 4.5);
                    break;
                }
                case "tentacle2": {
                    this.setPartBoundingPosition(extraPart, -20.0f, 0.0f, 4.5);
                    break;
                }
                case "tentacle3": {
                    this.setPartBoundingPosition(extraPart, 0.0f, 20.0f, 4.5);
                    break;
                }
                case "tentacle4": {
                    this.setPartBoundingPosition(extraPart, 0.0f, -25.0f, 4.5);
                    break;
                }
                case "tentacle5": {
                    this.setPartBoundingPosition(extraPart, 20.0f, -20.0f, 4.5);
                    break;
                }
                case "tentacle6": {
                    this.setPartBoundingPosition(extraPart, -20.0f, -20.0f, 4.5);
                    break;
                }
                case "tentacle7": {
                    this.setPartBoundingPosition(extraPart, 20.0f, 20.0f, 4.5);
                    break;
                }
                case "tentacle8": {
                    this.setPartBoundingPosition(extraPart, -20.0f, 20.0f, 4.5);
                }
            }
        }
    }

    public void m_6667_(DamageSource cause) {
        this.getCustomParts().forEach(extraPart -> extraPart.m_21153_(0.0f));
        super.m_6667_(cause);
    }

    @Override
    public ArrayList<EntityExtraPart> getCustomParts() {
        return this.extraParts;
    }

    protected void m_21226_() {
        this.f_21364_ = (int)((long)this.f_21364_ + (long)Mth.m_14167_((float)((float)this.f_21364_ * 0.1f)) * this.bossInfo.m_8324_().stream().filter(EntitySelector.f_20406_).count());
        super.m_21226_();
    }

    public boolean m_6072_() {
        return false;
    }

    protected void m_8024_() {
        super.m_8024_();
        if (((Boolean)DungeonsModConfig.COMMON.scalingDifficulty.get()).booleanValue()) {
            this.difficultyManager.adjustDifficulty((LivingEntity)this, 0.25f, 0.1f, 0.1f, 0.05f, this.bossInfo.m_8324_());
        }
        EntityUtils.scanBlocksInAABB((LivingEntity)this, this.m_142469_().m_82400_((double)0.1f), (blockPos, blockState) -> {
            int hardness = Mth.m_14045_((int)Mth.m_14143_((float)(blockState.m_60800_((BlockGetter)this.f_19853_, blockPos) * 0.5f)), (int)3, (int)Integer.MAX_VALUE);
            if (!blockState.m_60734_().equals(Blocks.f_50752_) && !blockState.m_60734_().equals(Blocks.f_50016_) && (double)blockPos.m_123342_() > this.m_20227_(0.1f) && this.f_19853_.f_46441_.nextInt(hardness) == 0) {
                this.f_19853_.m_46597_(blockPos, Blocks.f_49990_.m_49966_());
            }
            return false;
        });
        float totalCurrentHealth = this.m_21223_();
        float totalMaxHealth = this.m_21233_();
        for (EntityExtraPart extraPart : this.extraParts) {
            if (extraPart.isAlivePart()) {
                this.m_5634_(0.01f);
            }
            totalCurrentHealth += extraPart.m_21223_();
            totalMaxHealth += extraPart.m_21233_();
        }
        this.bossInfo.m_142711_(totalCurrentHealth / totalMaxHealth);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
        if (this.bossInfo.m_8324_().isEmpty()) {
            this.m_21153_(this.m_21233_());
        }
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public List<ServerPlayer> getPlayers() {
        return this.bossInfo.m_8324_().stream().filter(EntitySelector.f_20406_).collect(Collectors.toList());
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12438_;
    }

    public void m_6043_() {
    }

    static class MoveHelperController
    extends MoveControl {
        private final EntityKraken entityGuardian;

        public MoveHelperController(EntityKraken guardian) {
            super((Mob)guardian);
            this.entityGuardian = guardian;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.entityGuardian.m_21573_().m_26571_()) {
                Vec3 vector3d = new Vec3(this.f_24975_ - this.entityGuardian.m_20185_(), this.f_24976_ - this.entityGuardian.m_20186_(), this.f_24977_ - this.entityGuardian.m_20189_());
                double d0 = vector3d.m_82553_();
                double d1 = vector3d.f_82479_ / d0;
                double d2 = vector3d.f_82480_ / d0;
                double d3 = vector3d.f_82481_ / d0;
                float f = (float)(Mth.m_14136_((double)vector3d.f_82481_, (double)vector3d.f_82479_) * 57.2957763671875) - 90.0f;
                this.entityGuardian.m_146922_(this.m_24991_(this.entityGuardian.m_146908_(), f, 90.0f));
                this.entityGuardian.f_20883_ = this.entityGuardian.m_146908_();
                float f1 = (float)(this.f_24978_ * this.entityGuardian.m_21133_(Attributes.f_22279_));
                float f2 = Mth.m_14179_((float)0.125f, (float)this.entityGuardian.m_6113_(), (float)f1);
                this.entityGuardian.m_7910_(f2);
                LookControl lookcontroller = this.entityGuardian.m_21563_();
                double d8 = this.entityGuardian.m_20185_() + d1 * 2.0;
                double d9 = this.entityGuardian.m_20188_() + d2 / d0;
                double d10 = this.entityGuardian.m_20189_() + d3 * 2.0;
                double d11 = lookcontroller.m_24969_();
                double d12 = lookcontroller.m_24970_();
                double d13 = lookcontroller.m_24971_();
                if (!lookcontroller.m_24968_()) {
                    d11 = d8;
                    d12 = d9;
                    d13 = d10;
                }
                this.entityGuardian.m_21563_().m_24950_(Mth.m_14139_((double)0.125, (double)d11, (double)d8), Mth.m_14139_((double)0.125, (double)d12, (double)d9), Mth.m_14139_((double)0.125, (double)d13, (double)d10), 10.0f, 40.0f);
            } else {
                this.entityGuardian.m_7910_(0.0f);
            }
        }
    }

    public class KrakenMoveRandomGoal
    extends RandomSwimmingGoal {
        public KrakenMoveRandomGoal(PathfinderMob creature, double speed, int chance) {
            super(creature, speed, chance);
        }

        protected Vec3 blockPosition() {
            return BehaviorUtils.m_147444_((PathfinderMob)this.f_25725_, (int)10, (int)7);
        }
    }

    public static class KrakenTargetSelector
    implements com.google.common.base.Predicate<LivingEntity> {
        private final EntityKraken parentEntity;

        public KrakenTargetSelector(EntityKraken guardian) {
            this.parentEntity = guardian;
        }

        public boolean apply(@Nullable LivingEntity p_apply_1_) {
            return p_apply_1_ instanceof Player && p_apply_1_.m_20280_((Entity)this.parentEntity) > 4.0;
        }
    }
}

