/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.entity.boss;

import com.dainxt.dungeonsmod.ai.AIScheduledTimedAction;
import com.dainxt.dungeonsmod.ai.AIToggableMultipleTargetGoal;
import com.dainxt.dungeonsmod.config.DungeonsModConfig;
import com.dainxt.dungeonsmod.difficulty.DifficultyManager;
import com.dainxt.dungeonsmod.entity.projectile.EntitySunPlanet;
import com.dainxt.dungeonsmod.handlers.ItemRegistries;
import com.dainxt.dungeonsmod.interfaces.IMultiTargetEntity;
import com.dainxt.dungeonsmod.util.EntityUtils;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT, _interface=PowerableMob.class)
public class EntitySun
extends Mob
implements PowerableMob,
IMultiTargetEntity,
Enemy {
    DifficultyManager difficultyManager = new DifficultyManager();
    public ArrayList<EntitySunPlanet> planets;
    public ArrayList<LivingEntity> otherAttackTargets = new ArrayList();
    public float gravityPullYaw = 0.0f;
    private static final EntityDataAccessor<Boolean> SOLAR_WIND = SynchedEntityData.m_135353_(EntitySun.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final ServerBossEvent bossInfo = (ServerBossEvent)new ServerBossEvent(this.m_7755_(), BossEvent.BossBarColor.PINK, BossEvent.BossBarOverlay.NOTCHED_12).m_7003_(true);
    public AIToggableMultipleTargetGoal<? extends LivingEntity> windTarget;

    public EntitySun(EntityType<? extends Mob> type, Level worldIn) {
        super(type, worldIn);
        this.planets = new ArrayList();
        this.f_21364_ = 3000;
        this.f_19811_ = true;
        this.f_21342_ = new MoveHelperController(this);
    }

    protected ResourceLocation m_7582_() {
        return DungeonsModConfig.COMMON.sun.getDefaultLootTable();
    }

    public ItemEntity m_5552_(ItemStack stack, float offsetY) {
        if (stack.m_41720_().equals(ItemRegistries.SUNCORE_BLOCK)) {
            long totalPlayers = this.bossInfo.m_8324_().stream().filter(EntitySelector.f_20406_).count();
            float totalChance = Mth.m_14036_((float)((float)((Double)DungeonsModConfig.COMMON.legendaryLootChance.get() * (double)totalPlayers)), (float)0.0f, (float)100.0f);
            if (this.f_19853_.m_5822_().nextFloat() < totalChance / 100.0f) {
                return super.m_5552_(stack, offsetY);
            }
            return super.m_5552_(ItemStack.f_41583_, offsetY);
        }
        return super.m_5552_(stack, offsetY);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SOLAR_WIND, (Object)false);
    }

    public boolean isSolarWinding() {
        return (Boolean)this.m_20088_().m_135370_(SOLAR_WIND);
    }

    public void setSolarWinding(boolean attack) {
        this.m_20088_().m_135381_(SOLAR_WIND, (Object)attack);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.f_19326_.equals("blueDamage")) {
            return super.m_6469_(source, amount);
        }
        return super.m_6469_(source, amount * 0.05f);
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 1000.0).m_22268_(Attributes.f_22277_, 200.0).m_22268_(Attributes.f_22279_, 0.75).m_22268_(Attributes.f_22284_, 30.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    public boolean causeFallDamage(float distance, float damageMultiplier) {
        return false;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void m_7023_(Vec3 travelVector) {
        if (!this.f_19853_.f_46443_) {
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_21043_((LivingEntity)this, false);
        }
    }

    protected void m_8099_() {
        this.windTarget = new AIToggableMultipleTargetGoal<LivingEntity>(this, LivingEntity.class);
        this.f_21345_.m_25352_(2, (Goal)new AIAttack(this));
        this.f_21345_.m_25352_(4, (Goal)new AIDoSolarWind(this, 20, 200));
        this.f_21345_.m_25352_(5, (Goal)new RandomFlyGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new AIIgniteTargets(this, 20, 100));
        this.f_21346_.m_25352_(1, this.windTarget);
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 0, true, true, null));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 0, true, true, null));
    }

    protected void m_7324_(Entity entityIn) {
    }

    public boolean m_6094_() {
        return false;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11936_;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_11937_;
    }

    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    protected float m_6121_() {
        return 40.0f;
    }

    public int getMaxSpawnedInChunk() {
        return 1;
    }

    protected void m_21226_() {
        this.f_21364_ = (int)((long)this.f_21364_ + (long)Mth.m_14167_((float)((float)this.f_21364_ * 0.1f)) * this.bossInfo.m_8324_().stream().filter(EntitySelector.f_20406_).count());
        super.m_21226_();
    }

    public boolean m_6072_() {
        return false;
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_6210_();
        if (this.f_19853_.f_46443_) {
            for (int i = 0; i < 2; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123756_, this.m_20208_(0.75), this.m_20187_() - 0.25, this.m_20262_(0.75), (this.f_19796_.nextDouble() - 0.5) * 2.0, -this.f_19796_.nextDouble(), (this.f_19796_.nextDouble() - 0.5) * 2.0);
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20208_(0.75), this.m_20187_() - 0.25, this.m_20262_(0.75), (this.f_19796_.nextDouble() - 0.5) * 2.0, -this.f_19796_.nextDouble(), (this.f_19796_.nextDouble() - 0.5) * 2.0);
            }
        }
    }

    public static DamageSource causePlanetDamage(Entity source, @Nullable Entity indirectEntityIn) {
        return new IndirectEntityDamageSource("sunPlanet", source, indirectEntityIn).m_19380_().m_19389_();
    }

    public static DamageSource causeBlueDamage() {
        return new DamageSource("blueDamage").m_19380_().m_19389_();
    }

    protected void m_8024_() {
        super.m_8024_();
        if (((Boolean)DungeonsModConfig.COMMON.scalingDifficulty.get()).booleanValue()) {
            this.difficultyManager.adjustDifficulty((LivingEntity)this, 1.0f, 0.2f, 0.2f, 0.2f, this.bossInfo.m_8324_());
        }
        this.gravityPullYaw = (float)this.f_19797_ * 2.0f;
        Vec3 gravityPull = Vec3.m_82498_((float)0.0f, (float)this.gravityPullYaw);
        int maxPlanets = Mth.m_14143_((float)(12.0f * (1.0f - this.m_21223_() / this.m_21233_()))) + 1;
        if (this.f_19797_ % 100 == 0 && this.planets.size() < maxPlanets) {
            EntitySunPlanet projectile = new EntitySunPlanet(this.f_19853_, new ItemStack((ItemLike)Items.f_41999_), (impactProjectile, entity) -> entity.m_6469_(EntitySun.causePlanetDamage(impactProjectile, (Entity)this), 10.0f));
            Vec3 finalPos = this.m_20299_(0.5f).m_82549_(gravityPull.m_82490_(5.5));
            projectile.m_6034_(finalPos.f_82479_, finalPos.f_82480_, finalPos.f_82481_);
            projectile.m_5602_((Entity)this);
            this.f_19853_.m_7967_((Entity)projectile);
            this.planets.add(projectile);
        } else {
            this.planets.removeIf(planet -> planet == null || this.f_19853_.m_6815_(planet.m_142049_()) == null);
            this.planets.forEach(planet -> {
                if (!planet.isShooted) {
                    Vec3 difference = planet.m_20299_(1.0f).m_82546_(this.m_20299_(1.0f));
                    float accelerationX = (float)(-difference.f_82479_ * (double)0.001f);
                    float accelerationZ = (float)(-difference.f_82481_ * (double)0.001f);
                    Vec3 resultant = difference.m_82490_(0.5).m_82537_(new Vec3(0.0, (double)0.05f, 0.0));
                    resultant = resultant.m_82520_(0.0, -difference.f_82480_ * (double)0.1f, 0.0);
                    planet.m_20256_(resultant.m_82520_((double)accelerationX, 0.0, (double)accelerationZ));
                }
            });
        }
        if (this.f_19797_ % 600 == 0) {
            this.planets.forEach(planet -> {
                if (planet != null) {
                    LivingEntity potential;
                    Vec3 targetPosition = Vec3.f_82478_;
                    if (this.m_5448_() != null) {
                        targetPosition = this.m_5448_().m_20299_(1.0f);
                    } else if (!this.getAttackTargets().isEmpty() && (potential = this.getAttackTargets().get(this.f_19796_.nextInt(this.getAttackTargets().size()))) != null) {
                        targetPosition = potential.m_20299_(1.0f);
                    }
                    if (!targetPosition.equals((Object)Vec3.f_82478_)) {
                        Vec3 difference = targetPosition.m_82546_(planet.m_20182_());
                        planet.m_6686_(difference.f_82479_, difference.f_82480_, difference.f_82481_, 3.0f, 0.0f);
                    }
                }
            });
        }
        this.destroyNearBlocks();
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public void destroyNearBlocks() {
        if (this.f_19797_ % 600 == 0) {
            boolean doSound = false;
            float maxDistance = 5.0f;
            doSound = EntityUtils.scanBlocksInAABB((LivingEntity)this, this.m_142469_().m_82400_((double)maxDistance), (blockPos, blockState) -> {
                double distance;
                Block block = blockState.m_60734_();
                boolean flag = false;
                if (!block.equals(Blocks.f_50752_) && (distance = blockPos.m_123331_((Vec3i)new BlockPos(this.m_142469_().m_82399_()))) < (double)(maxDistance * maxDistance)) {
                    flag = this.f_19853_.m_46597_(blockPos, Blocks.f_50016_.m_49966_()) || flag;
                }
                return flag;
            });
            if (doSound) {
                this.m_5496_(SoundEvents.f_12031_, 40.0f, 1.0f);
                this.m_5496_(SoundEvents.f_11913_, 40.0f, 1.0f);
            }
        }
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
        if (this.bossInfo.m_8324_().isEmpty()) {
            this.m_21153_(this.m_21233_());
        }
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * 0.5f;
    }

    public ArrayList<ServerPlayer> getPlayers() {
        return new ArrayList<ServerPlayer>(this.bossInfo.m_8324_().stream().collect(Collectors.toList()));
    }

    public boolean m_7090_() {
        return true;
    }

    public EntityDimensions m_6972_(Pose entityPose) {
        float scaleFactor = 20.0f * (1.0f - 0.8f * this.m_21223_() / this.m_21233_());
        return EntityDimensions.m_20395_((float)scaleFactor, (float)scaleFactor);
    }

    public boolean m_21532_() {
        return !this.bossInfo.m_8324_().isEmpty();
    }

    public void m_6043_() {
        if (this.bossInfo.m_8324_().isEmpty()) {
            super.m_6043_();
        }
    }

    @Override
    public void setAttackTargets(ArrayList<LivingEntity> players) {
        this.otherAttackTargets.addAll(players);
    }

    @Override
    public ArrayList<LivingEntity> getAttackTargets() {
        return this.otherAttackTargets;
    }

    static class MoveHelperController
    extends MoveControl {
        private final EntitySun parentEntity;
        private int courseChangeCooldown;

        public MoveHelperController(EntitySun ghast) {
            super((Mob)ghast);
            this.parentEntity = ghast;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && this.courseChangeCooldown-- <= 0) {
                this.courseChangeCooldown = 60;
                this.f_24981_ = MoveControl.Operation.WAIT;
                Vec3 vector3d = new Vec3(this.f_24975_ - this.parentEntity.m_20185_(), this.f_24976_ - this.parentEntity.m_20186_(), this.f_24977_ - this.parentEntity.m_20189_());
                vector3d = vector3d.m_82541_();
                this.parentEntity.m_20256_(this.parentEntity.m_20184_().m_82549_(vector3d.m_82490_(0.1)));
            }
        }
    }

    static class AIAttack
    extends Goal {
        private final EntitySun parentEntity;

        public AIAttack(EntitySun Sun) {
            this.parentEntity = Sun;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return this.parentEntity.m_5448_() != null && this.parentEntity.m_20280_((Entity)this.parentEntity.m_5448_()) > 256.0;
        }

        public void m_8056_() {
        }

        public void m_8041_() {
        }

        public void m_8037_() {
            LivingEntity LivingEntity2 = this.parentEntity.m_5448_();
            if (LivingEntity2.m_20280_((Entity)this.parentEntity) < 4096.0 && this.parentEntity.m_142582_((Entity)LivingEntity2)) {
                double d2 = LivingEntity2.m_20185_();
                double d3 = LivingEntity2.m_20186_();
                double d4 = LivingEntity2.m_20189_();
                float f = (float)this.parentEntity.m_21133_(Attributes.f_22279_);
                this.parentEntity.m_21566_().m_6849_(d2, d3, d4, (double)f);
            }
        }
    }

    class AIDoSolarWind
    extends AIScheduledTimedAction {
        EntitySun sun;

        public AIDoSolarWind(EntitySun entity, int maxDuration, int maxCooldown) {
            super((LivingEntity)entity, maxDuration, maxCooldown);
            this.sun = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_();
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            this.sun.setSolarWinding(true);
            EntitySun.this.windTarget.func_220783_a(true);
            SoundEvent soundevent = SoundEvents.f_11874_;
            this.sun.m_5496_(soundevent, 20.0f, 0.2f);
        }

        public void m_8037_() {
            super.m_8037_();
        }

        @Override
        public void onStartCycle() {
            super.onStartCycle();
            this.sun.getAttackTargets().forEach(target -> {
                if (this.shouldBeDamaged((LivingEntity)target)) {
                    target.m_6469_(DamageSource.m_19370_((LivingEntity)this.sun).m_19380_().m_19383_(), target.m_21233_() * 0.25f);
                }
            });
        }

        private boolean shouldBeDamaged(LivingEntity player) {
            Vec3 Vec32 = this.sun.m_20252_(1.0f).m_82541_();
            Vec3 Vec31 = new Vec3(player.m_20185_() - this.sun.m_20185_(), player.m_142469_().f_82289_ + (double)player.m_20192_() - (this.sun.m_20186_() + (double)this.sun.m_20192_()), player.m_20189_() - this.sun.m_20189_());
            double d1 = Vec32.m_82526_(Vec31 = Vec31.m_82548_().m_82541_());
            return d1 > 0.6 ? player.m_142582_((Entity)player) : false;
        }

        @Override
        public void m_8041_() {
            super.m_8041_();
            this.sun.setSolarWinding(false);
            EntitySun.this.windTarget.func_220783_a(false);
            this.sun.m_146922_(this.sun.m_146908_() + 90.0f);
        }
    }

    static class RandomFlyGoal
    extends Goal {
        private final EntitySun parentEntity;

        public RandomFlyGoal(EntitySun ghast) {
            this.parentEntity = ghast;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            double d2;
            double d1;
            MoveControl movementcontroller = this.parentEntity.m_21566_();
            if (!movementcontroller.m_24995_()) {
                return true;
            }
            double d0 = movementcontroller.m_25000_() - this.parentEntity.m_20185_();
            double d3 = d0 * d0 + (d1 = movementcontroller.m_25001_() - this.parentEntity.m_20186_()) * d1 + (d2 = movementcontroller.m_25002_() - this.parentEntity.m_20189_()) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            Random random = this.parentEntity.m_21187_();
            double d0 = this.parentEntity.m_20185_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.parentEntity.m_20186_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 8.0f);
            double d2 = this.parentEntity.m_20189_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            float f = (float)this.parentEntity.m_21133_(Attributes.f_22279_);
            this.parentEntity.m_21566_().m_6849_(d0, d1, d2, (double)f);
        }
    }

    static class AIIgniteTargets
    extends AIScheduledTimedAction {
        private final EntitySun parentEntity;

        public AIIgniteTargets(EntitySun entity, int maxDuration, int maxCooldown) {
            super((LivingEntity)entity, maxDuration, maxCooldown);
            this.parentEntity = entity;
        }

        @Override
        public boolean m_8036_() {
            return this.parentEntity.m_5448_() != null;
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            this.parentEntity.windTarget.func_220783_a(true);
        }

        @Override
        public void onStartCycle() {
            super.onStartCycle();
            this.parentEntity.getAttackTargets().forEach(target -> {
                if (target != this.parentEntity) {
                    target.m_20254_(5);
                    double distance = target.m_20182_().m_82554_(this.parentEntity.m_20182_()) + 1.0;
                    target.m_6469_(DamageSource.m_19370_((LivingEntity)this.parentEntity).m_19380_().m_19383_(), (float)(60.0 / distance));
                }
            });
        }

        @Override
        public void m_8041_() {
            super.m_8041_();
            this.parentEntity.windTarget.func_220783_a(false);
        }
    }
}

