/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.entity.boss;

import com.dainxt.dungeonsmod.DungeonsMod;
import com.dainxt.dungeonsmod.ai.AIMultipleTargetGoal;
import com.dainxt.dungeonsmod.ai.AIScheduledTimedAction;
import com.dainxt.dungeonsmod.config.DungeonsModConfig;
import com.dainxt.dungeonsmod.difficulty.DifficultyManager;
import com.dainxt.dungeonsmod.entity.EntityExtraPart;
import com.dainxt.dungeonsmod.entity.projectile.EntityVoidLaser;
import com.dainxt.dungeonsmod.handlers.EntityRegistries;
import com.dainxt.dungeonsmod.interfaces.IMultiTargetEntity;
import com.dainxt.dungeonsmod.items.VoidTomeItem;
import com.dainxt.dungeonsmod.sclasses.EntityMultiPart;
import com.dainxt.dungeonsmod.util.EntityUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT, _interface=PowerableMob.class)
public class EntityVoidMaster
extends EntityMultiPart
implements PowerableMob,
IMultiTargetEntity {
    DifficultyManager difficultyManager = new DifficultyManager();
    private static final EntityDataAccessor<Boolean> NULLIFY = SynchedEntityData.m_135353_(EntityVoidMaster.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> BLACK_HOLE = SynchedEntityData.m_135353_(EntityVoidMaster.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> HAND_ANIMATION = SynchedEntityData.m_135353_(EntityVoidMaster.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<CompoundTag> PLAYERS_POSITIONS = SynchedEntityData.m_135353_(EntityVoidMaster.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private final ServerBossEvent bossInfo = (ServerBossEvent)new ServerBossEvent(this.m_7755_(), BossEvent.BossBarColor.GREEN, BossEvent.BossBarOverlay.PROGRESS).m_7003_(true);
    public Map<String, BlockPos> cementeryPositions;

    public EntityVoidMaster(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
        if (!worldIn.f_46443_) {
            this.cementeryPositions = new ConcurrentHashMap<String, BlockPos>();
        }
        this.f_21364_ = 9000;
        this.f_19811_ = true;
        this.m_21530_();
    }

    protected ResourceLocation m_7582_() {
        return DungeonsModConfig.COMMON.voidmaster.getDefaultLootTable();
    }

    public ItemEntity m_5552_(ItemStack stack, float offsetY) {
        if (stack.m_41720_() instanceof VoidTomeItem) {
            long totalPlayers = this.bossInfo.m_8324_().stream().filter(EntitySelector.f_20406_).count();
            float totalChance = Mth.m_14036_((float)((float)((Double)DungeonsModConfig.COMMON.legendaryLootChance.get() * (double)totalPlayers)), (float)0.0f, (float)100.0f);
            if (this.f_19853_.m_5822_().nextFloat() < totalChance / 100.0f) {
                return super.m_5552_(stack, offsetY);
            }
            return super.m_5552_(ItemStack.f_41583_, offsetY);
        }
        if (stack.m_41720_() instanceof EnchantedBookItem) {
            List enchantments = ForgeRegistries.ENCHANTMENTS.getValues().stream().filter(entry -> !entry.m_6589_()).collect(Collectors.toList());
            Collections.shuffle(enchantments);
            enchantments.stream().limit(this.bossInfo.m_8324_().size()).forEach(enchantment -> {
                ItemStack stackCopy = stack.m_41777_();
                EnchantedBookItem.m_41153_((ItemStack)stackCopy, (EnchantmentInstance)new EnchantmentInstance(enchantment, 50));
                super.m_5552_(stackCopy, offsetY);
            });
            return super.m_5552_(ItemStack.f_41583_, offsetY);
        }
        return super.m_5552_(stack, offsetY);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(NULLIFY, (Object)false);
        this.f_19804_.m_135372_(BLACK_HOLE, (Object)-1);
        this.f_19804_.m_135372_(PLAYERS_POSITIONS, (Object)new CompoundTag());
        this.f_19804_.m_135372_(HAND_ANIMATION, (Object)0);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_19378_()) {
            return super.m_6469_(source, amount);
        }
        if (amount > 30.0f) {
            if (source.m_7639_() instanceof LivingEntity) {
                source.m_7639_().m_6469_(DamageSource.m_19370_((LivingEntity)this).m_19389_(), amount * 2.0f);
            }
            return false;
        }
        if (this.getPhase() == 3) {
            amount *= 2.0f;
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_7327_(Entity entityIn) {
        boolean flag = super.m_7327_(entityIn);
        if (flag && entityIn instanceof LivingEntity) {
            ((LivingEntity)entityIn).m_7292_(new MobEffectInstance(MobEffects.f_19610_, 20, 5));
        }
        return super.m_7327_(entityIn);
    }

    @Override
    public void setAttackTargets(ArrayList<LivingEntity> players) {
        CompoundTag nbt = new CompoundTag().m_128469_("playerPositions");
        nbt.m_128405_("index", players.size());
        for (int i = 0; i < players.size(); ++i) {
            nbt.m_128405_("player_" + i, players.get(i).m_142049_());
        }
        this.m_20088_().m_135381_(PLAYERS_POSITIONS, (Object)nbt);
    }

    @Override
    public ArrayList<LivingEntity> getAttackTargets() {
        CompoundTag incomingTag;
        ArrayList<LivingEntity> incomingArray = new ArrayList<LivingEntity>();
        CompoundTag nbt = incomingTag = (CompoundTag)this.m_20088_().m_135370_(PLAYERS_POSITIONS);
        for (int i = 0; i < nbt.m_128451_("index"); ++i) {
            int entityId = nbt.m_128451_("player_" + i);
            if (!(this.f_19853_.m_6815_(entityId) instanceof LivingEntity)) continue;
            incomingArray.add((LivingEntity)this.f_19853_.m_6815_(entityId));
        }
        return incomingArray;
    }

    public void setHandAnimation(int handAnimation) {
        this.m_20088_().m_135381_(HAND_ANIMATION, (Object)handAnimation);
    }

    public int getHandAnimation() {
        return (Integer)this.m_20088_().m_135370_(HAND_ANIMATION);
    }

    public void setBlackHole(int state) {
        this.m_20088_().m_135381_(BLACK_HOLE, (Object)state);
    }

    public int getBlackHole() {
        return (Integer)this.m_20088_().m_135370_(BLACK_HOLE);
    }

    public void setNullify(boolean activate) {
        this.m_20088_().m_135381_(NULLIFY, (Object)activate);
    }

    public boolean getNullify() {
        return (Boolean)this.m_20088_().m_135370_(NULLIFY);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        CompoundTag nbt = compound.m_128469_("cementeryPositions");
        for (int i = 0; i < nbt.m_128451_("index"); ++i) {
            String name = nbt.m_128461_("name_" + i);
            BlockPos pos = BlockPos.m_122022_((long)nbt.m_128454_("position_" + i));
            this.cementeryPositions.put(name, pos);
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        CompoundTag nbt = compound.m_128469_("cementeryPositions");
        nbt.m_128405_("index", this.cementeryPositions.size());
        for (int i = 0; i < this.cementeryPositions.size(); ++i) {
            String name = (String)((Map.Entry)this.cementeryPositions.entrySet().toArray()[i]).getKey();
            BlockPos pos = (BlockPos)((Map.Entry)this.cementeryPositions.entrySet().toArray()[i]).getValue();
            nbt.m_128359_("name_" + i, name);
            nbt.m_128356_("position_" + i, pos.m_121878_());
        }
        compound.m_128365_("cementeryPositions", (Tag)nbt);
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 750.0).m_22268_(Attributes.f_22277_, 200.0).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22284_, 20.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag) {
        this.m_146922_(270.0f);
        this.f_20885_ = 270.0f;
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new LaserAttackGoal(this, 1, 100, 20));
        this.f_21345_.m_25352_(2, (Goal)new BlackHoleAttackGoal(this, 100, 1200));
        this.f_21345_.m_25352_(3, (Goal)new NullifyAttackGoal(this, 40, 600, 3));
        this.f_21345_.m_25352_(4, (Goal)new MeleeMultiAttackGoal(this, 10, 20));
        this.f_21346_.m_25352_(1, new AIMultipleTargetGoal<Player>(this, Player.class));
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        this.f_20885_ = 270.0f;
        if (this.getBlackHole() > 0) {
            if (this.getBlackHole() == 1) {
                this.getAttackTargets().forEach(nearEntity -> {
                    Vec3 offset = this.m_20154_().m_82490_(22.0);
                    Vec3 direction = this.m_20182_().m_82549_(offset).m_82546_(nearEntity.m_20182_());
                    if (direction.m_82553_() >= 1.5) {
                        double invDistance = 1.0 / direction.m_82553_() * 5.0;
                        nearEntity.m_20256_(nearEntity.m_20184_().m_82549_(direction.m_82541_().m_82542_(invDistance, invDistance, invDistance)));
                    } else {
                        nearEntity.m_20256_(Vec3.f_82478_);
                    }
                });
            } else if (this.getBlackHole() > 1) {
                this.getAttackTargets().forEach(nearEntity -> {
                    Vec3 offset = this.m_20154_().m_82490_(22.0);
                    double distance = this.m_20182_().m_82549_(offset).m_82554_(nearEntity.m_20182_());
                    double power = 15.0;
                    Vec3 motionDirection = this.m_20154_().m_82520_(0.0, (double)0.1f, 0.0).m_82490_(power);
                    if (distance < 2.0) {
                        nearEntity.m_20256_(motionDirection);
                    }
                });
                if (!this.f_19853_.f_46443_) {
                    if (this.getBlackHole() == 2) {
                        this.setBlackHole(3);
                    } else if (this.getBlackHole() == 3) {
                        this.setBlackHole(-1);
                    }
                }
            }
        }
    }

    public void tombPlayer(Player player) {
        BlockPos cementery1 = this.cementeryPositions.get("leftCementery1");
        BlockPos cementery2 = this.cementeryPositions.get("leftCementery2");
        if (cementery1 == null || cementery2 == null) {
            return;
        }
        BlockPos difference = cementery2.m_141950_((Vec3i)cementery1);
        BlockPos crossProduct = BlockPos.f_121853_.m_5484_(Direction.UP, 1).m_7724_((Vec3i)difference);
        boolean leftCementery = true;
        block0: for (int row = 0; row <= 16; ++row) {
            int column = 0;
            while (column <= 16) {
                if (leftCementery) {
                    cementery1 = this.cementeryPositions.get("leftCementery1");
                    cementery2 = this.cementeryPositions.get("leftCementery2");
                } else {
                    cementery1 = this.cementeryPositions.get("rightCementery1");
                    cementery2 = this.cementeryPositions.get("rightCementery2");
                }
                difference = cementery2.m_141950_((Vec3i)cementery1);
                crossProduct = BlockPos.f_121853_.m_5484_(Direction.UP, leftCementery ? 1 : -1).m_7724_((Vec3i)difference);
                Direction signFacing = Direction.m_122372_((float)crossProduct.m_123341_(), (float)crossProduct.m_123342_(), (float)crossProduct.m_123343_());
                if (signFacing == null) {
                    DungeonsMod.LOGGER.info("Warning!: Failed to make a tomb for player c1:{} c2:{} cross:{}", (Object)cementery1, (Object)cementery2, (Object)crossProduct);
                    return;
                }
                Direction expansionFacing = signFacing.m_122424_();
                Direction fromNormal = Direction.m_122378_((int)difference.m_123341_(), (int)difference.m_123342_(), (int)difference.m_123343_());
                if (fromNormal == null) {
                    DungeonsMod.LOGGER.info("Warning!: Failed to make a tomb for player c1:{} c2:{} cross:{}", (Object)cementery1, (Object)cementery2, (Object)crossProduct);
                    return;
                }
                BlockPos crossPosition = cementery1.m_5484_(fromNormal, column * 4);
                crossPosition = crossPosition.m_5484_(expansionFacing, row * 5);
                BlockPos signPos = crossPosition.m_6630_(3).m_5484_(signFacing, 1);
                if (!leftCementery) {
                    ++column;
                }
                boolean bl = leftCementery = !leftCementery;
                if (this.f_19853_.m_8055_(signPos).m_60734_() == Blocks.f_50160_) continue;
                for (int i = 0; i <= 4; ++i) {
                    this.f_19853_.m_46597_(crossPosition.m_6630_(i), Blocks.f_50652_.m_49966_());
                    if (i != 3) continue;
                    this.f_19853_.m_46597_(crossPosition.m_6630_(i).m_5484_(signFacing, 1), Blocks.f_50652_.m_49966_());
                    this.f_19853_.m_46597_(crossPosition.m_6630_(i).m_5484_(signFacing, -1), Blocks.f_50652_.m_49966_());
                    this.f_19853_.m_46597_(signPos, (BlockState)Blocks.f_50160_.m_49966_().m_61124_((Property)WallSignBlock.f_58064_, (Comparable)signFacing));
                    ((SignBlockEntity)this.f_19853_.m_7702_(signPos)).m_59732_(1, player.m_7755_());
                }
                break block0;
            }
        }
    }

    private double getHeadX(int p_82214_1_) {
        if (p_82214_1_ <= 0) {
            float f = (this.f_20883_ + 90.0f) * ((float)Math.PI / 180);
            float f1 = Mth.m_14089_((float)f);
            return this.m_20185_() + (double)f1 * 5.0;
        }
        float f = (this.f_20883_ + (float)(180 * (p_82214_1_ - 1))) * ((float)Math.PI / 180);
        float f1 = Mth.m_14089_((float)f);
        return this.m_20185_() + (double)f1 * 13.5;
    }

    private double getHeadY(int p_82208_1_) {
        return p_82208_1_ <= 0 ? this.m_20188_() + 0.0 : this.m_20188_() - 1.5;
    }

    private double getHeadZ(int p_82213_1_) {
        if (p_82213_1_ <= 0) {
            float f = (this.f_20883_ + 90.0f) * ((float)Math.PI / 180);
            float f1 = Mth.m_14031_((float)f);
            return this.m_20189_() + (double)f1 * 5.0;
        }
        float f = (this.f_20883_ + (float)(180 * (p_82213_1_ - 1))) * ((float)Math.PI / 180);
        float f1 = Mth.m_14031_((float)f);
        return this.m_20189_() + (double)f1 * 13.5;
    }

    private void launchProjectiletoEntity(int p_82216_1_, LivingEntity p_82216_2_) {
        this.launchProjectiletoCoords(p_82216_1_, p_82216_2_.m_20185_(), p_82216_2_.m_20186_() + (double)p_82216_2_.m_20192_() * 0.5, p_82216_2_.m_20189_(), p_82216_1_ == 0 && this.f_19796_.nextFloat() < 0.001f);
    }

    private void launchProjectiletoCoords(int p_82209_1_, double x, double y, double z, boolean invulnerable) {
        if (!this.m_20067_()) {
            SoundEvent soundevent = SoundEvents.f_11738_;
            this.m_5496_(soundevent, 20.0f, 0.2f);
        }
        double d0 = this.getHeadX(p_82209_1_);
        double d1 = this.getHeadY(p_82209_1_);
        double d2 = this.getHeadZ(p_82209_1_);
        double d3 = x - d0;
        double d4 = y - d1;
        double d5 = z - d2;
        double d7 = Mth.m_14116_((float)((float)(d3 * d3 + d5 * d5)));
        EntityVoidLaser witherskullentity = new EntityVoidLaser(EntityRegistries.VOIDLASER, this.f_19853_);
        witherskullentity.m_6034_(d0, d1, d2);
        witherskullentity.m_5602_((Entity)this);
        witherskullentity.m_6686_(d3, d4, d5, 5.0f, 0.0f);
        this.f_19853_.m_7967_((Entity)witherskullentity);
    }

    protected void m_6763_(BlockState blockstate) {
        Block block = blockstate.m_60734_();
        if (block != Blocks.f_50016_) {
            EntityUtils.scanBlocksInAABB((LivingEntity)this, (blockPos, blockState) -> {
                this.f_19853_.m_46961_(blockPos, false);
                return false;
            });
        }
        super.m_6763_(blockstate);
    }

    public int getPhase() {
        float healthPercent = this.m_21223_() / this.m_21233_();
        return Mth.m_14167_((float)((1.0f - healthPercent) * 3.0f));
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * 0.5f;
    }

    @Override
    protected EntityExtraPart.ExtraPartType getExtraPartType() {
        return EntityExtraPart.ExtraPartType.VOIDHAND;
    }

    @Override
    protected void initExtraParts(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag) {
        EntityExtraPart leftHand = new EntityExtraPart((Mob)this, "rightHand", 6.0f, 6.0f);
        EntityExtraPart rightHand = new EntityExtraPart((Mob)this, "leftHand", 6.0f, 6.0f);
        this.extraParts.addAll(Arrays.asList(leftHand, rightHand));
    }

    @Override
    protected void updateExtraParts() {
        this.getCustomParts().forEach(extraPart -> {
            extraPart.m_146922_(this.m_146908_());
            extraPart.f_20885_ = this.f_20885_;
        });
        for (EntityExtraPart extraPart2 : this.getCustomParts()) {
            if (extraPart2.m_5448_() != null) continue;
            switch (extraPart2.getPartName()) {
                case "rightHand": {
                    this.setPartBoundingPosition(extraPart2, 50.0f, 20.0f, 15.0);
                    break;
                }
                case "leftHand": {
                    this.setPartBoundingPosition(extraPart2, -50.0f, 20.0f, 15.0);
                }
            }
        }
    }

    protected void m_21226_() {
        this.f_21364_ = (int)((long)this.f_21364_ + (long)Mth.m_14167_((float)((float)this.f_21364_ * 0.1f)) * this.bossInfo.m_8324_().stream().filter(EntitySelector.f_20406_).count());
        super.m_21226_();
    }

    public boolean m_6072_() {
        return false;
    }

    protected void m_8024_() {
        super.m_8024_();
        if (((Boolean)DungeonsModConfig.COMMON.scalingDifficulty.get()).booleanValue()) {
            this.difficultyManager.adjustDifficulty((LivingEntity)this, 0.7f, 0.0f, 0.7f, 0.7f, this.bossInfo.m_8324_());
        }
        if (!this.m_21536_()) {
            this.m_21446_(this.m_142538_(), 3);
        }
        BlockPos pos = this.m_21534_();
        this.m_6034_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        this.m_20256_(Vec3.f_82478_);
        float distance = Float.MAX_VALUE;
        for (Player player : this.bossInfo.m_8324_()) {
            distance = Math.min(player.m_20270_((Entity)this), distance);
        }
        if (distance > 30.0f) {
            this.m_5634_(0.5f);
        }
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
        if (this.bossInfo.m_8324_().isEmpty()) {
            this.m_21153_(this.m_21233_());
        }
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public boolean m_7090_() {
        return true;
    }

    public void m_6043_() {
    }

    static class LaserAttackGoal
    extends AIScheduledTimedAction {
        private int baseMaxTimes;
        private final EntityVoidMaster goalOwner;
        LivingEntity target;

        public LaserAttackGoal(EntityVoidMaster entity, int maxDuration, int maxCooldown, int maxTimes) {
            super((LivingEntity)entity, maxDuration, maxCooldown, maxTimes);
            this.goalOwner = entity;
            this.baseMaxTimes = maxTimes;
        }

        @Override
        public boolean m_8036_() {
            return !this.goalOwner.getAttackTargets().isEmpty() && super.m_8036_();
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            ArrayList<LivingEntity> targetEntities = this.goalOwner.getAttackTargets();
            this.target = targetEntities.get(this.goalOwner.m_21187_().nextInt(targetEntities.size()));
        }

        @Override
        public void onStartCycle() {
            if (this.target != null) {
                int phase = this.goalOwner.getPhase();
                this.goalOwner.launchProjectiletoEntity(0, this.target);
                if (phase == 1) {
                    this.maxTimes = this.baseMaxTimes;
                }
                if (phase == 2) {
                    this.maxTimes = this.baseMaxTimes * 2;
                    this.goalOwner.launchProjectiletoEntity(this.goalOwner.m_21187_().nextBoolean() ? 1 : 2, this.target);
                }
                if (phase == 3) {
                    this.maxTimes = this.baseMaxTimes * 60 * 5;
                    this.goalOwner.launchProjectiletoEntity(1, this.target);
                    this.goalOwner.launchProjectiletoEntity(2, this.target);
                }
            }
        }
    }

    static class BlackHoleAttackGoal
    extends AIScheduledTimedAction {
        private final EntityVoidMaster goalOwner;

        public BlackHoleAttackGoal(EntityVoidMaster entity, int maxDuration, int maxCooldown) {
            super((LivingEntity)entity, maxDuration, maxCooldown);
            this.goalOwner = entity;
        }

        @Override
        public boolean m_8036_() {
            return !this.goalOwner.getAttackTargets().isEmpty() && super.m_8036_();
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            this.goalOwner.setBlackHole(1);
        }

        public void m_8037_() {
            super.m_8037_();
        }

        @Override
        public void onStartCycle() {
            this.goalOwner.setBlackHole(2);
        }

        @Override
        public void m_8041_() {
            super.m_8041_();
        }
    }

    static class NullifyAttackGoal
    extends AIScheduledTimedAction {
        private final EntityVoidMaster goalOwner;

        public NullifyAttackGoal(EntityVoidMaster entity, int maxDuration, int maxCooldown, int maxTimes) {
            super((LivingEntity)entity, maxDuration, maxCooldown, maxTimes);
            this.goalOwner = entity;
        }

        @Override
        public boolean m_8036_() {
            return !this.goalOwner.getAttackTargets().isEmpty() && super.m_8036_();
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            this.goalOwner.setNullify(true);
        }

        @Override
        public void onStartCycle() {
            this.goalOwner.getAttackTargets().forEach(nearEntity -> {
                float damagefactor = 0.95f + (float)(this.goalOwner.getPhase() - 1) * 0.5f;
                if (!nearEntity.m_20077_() && !nearEntity.m_20069_()) {
                    nearEntity.m_6469_(DamageSource.m_19370_((LivingEntity)this.goalOwner).m_19389_(), nearEntity.m_21233_() * damagefactor);
                }
            });
        }

        @Override
        public void m_8041_() {
            super.m_8041_();
            this.goalOwner.setNullify(false);
        }
    }

    static class MeleeMultiAttackGoal
    extends AIScheduledTimedAction {
        private final EntityVoidMaster goalOwner;

        public MeleeMultiAttackGoal(EntityVoidMaster slimeIn, int duration, int cooldown) {
            super((LivingEntity)slimeIn, duration, cooldown);
            this.goalOwner = slimeIn;
        }

        @Override
        public boolean m_8036_() {
            return !this.goalOwner.getAttackTargets().isEmpty() && super.m_8036_();
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            ArrayList<LivingEntity> targetEntities = this.goalOwner.getAttackTargets();
            Collections.shuffle(targetEntities);
            for (int i = 0; i < Math.min(this.goalOwner.getCustomParts().size(), targetEntities.size()); ++i) {
                this.goalOwner.getCustomParts().get(i).m_6710_((LivingEntity)targetEntities.get(i));
            }
            this.goalOwner.setAttackTargets(new ArrayList<LivingEntity>(targetEntities));
            this.goalOwner.m_6674_(InteractionHand.MAIN_HAND);
        }

        public void m_8037_() {
            super.m_8037_();
            this.goalOwner.getCustomParts().stream().filter(extraPart -> extraPart.m_5448_() != null).forEach(hand -> {
                LivingEntity target = hand.m_5448_();
                hand.m_19890_(target.m_20185_(), target.m_20227_(1.0), target.m_20189_(), 0.0f, 0.0f);
                hand.m_20256_(Vec3.f_82478_);
            });
        }

        @Override
        public void onStartCycle() {
            if (this.m_8036_()) {
                this.goalOwner.getCustomParts().stream().filter(extraPart -> extraPart.m_5448_() != null).findAny().ifPresent(hand -> this.goalOwner.m_7327_((Entity)hand.m_5448_()));
            }
        }

        @Override
        public void m_8041_() {
            super.m_8041_();
            this.goalOwner.setAttackTargets(new ArrayList<LivingEntity>());
            this.goalOwner.getCustomParts().forEach(extraPart -> extraPart.m_6710_(null));
        }
    }
}

