/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.entity.dungeons.dungeon4;

import com.dainxt.dungeonsmod.config.DungeonsModConfig;
import com.dainxt.dungeonsmod.difficulty.DifficultyManager;
import com.dainxt.dungeonsmod.entity.boss.EntityKing;
import com.dainxt.dungeonsmod.handlers.ItemRegistries;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class EntityGuard
extends TamableAnimal {
    DifficultyManager difficultyManager = new DifficultyManager();
    private static final EntityDataAccessor<Boolean> IS_GUARD = SynchedEntityData.m_135353_(EntityGuard.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public EntityGuard(EntityType<? extends TamableAnimal> type, Level worldIn) {
        super(type, worldIn);
        this.m_21530_();
    }

    protected void m_6851_(DifficultyInstance difficulty) {
        this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42740_));
        this.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42383_));
        this.m_21409_(EquipmentSlot.OFFHAND, 0.0f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_GUARD, (Object)false);
    }

    public boolean isGuard() {
        return (Boolean)this.m_20088_().m_135370_(IS_GUARD);
    }

    public void setGuard(boolean attack) {
        this.m_20088_().m_135381_(IS_GUARD, (Object)attack);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{EntityGuard.class}));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 0, true, true, entity -> !this.m_21824_()));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, 0, true, true, (Predicate)((Object)new GuardTargetSelector(this))));
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficulty, MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag) {
        SpawnGroupData data = super.m_6518_(worldIn, difficulty, reason, spawnDataIn, dataTag);
        this.m_6851_(difficulty);
        if (data != null && data instanceof GroupData) {
            if (((GroupData)data).isBodyGuard) {
                this.setGuard(true);
                this.m_21051_(Attributes.f_22276_).m_22100_(10.0);
                this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, Integer.MAX_VALUE, 4));
                this.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)Items.f_42469_));
                this.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)Items.f_42470_));
                this.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)Items.f_42471_));
            }
            if (((GroupData)data).isPlayerGuard) {
                this.m_21051_(Attributes.f_22276_).m_22100_(10.0);
                this.m_21051_(Attributes.f_22281_).m_22100_(0.5);
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42430_));
            }
        }
        if (((Boolean)DungeonsModConfig.COMMON.scalingDifficulty.get()).booleanValue()) {
            this.difficultyManager.adjustDifficulty((LivingEntity)this);
        }
        return data;
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_21203_();
    }

    protected void m_8024_() {
        ItemStack stack;
        super.m_8024_();
        if (this.m_21824_() && this.m_142480_() != null && (stack = this.m_142480_().m_6844_(EquipmentSlot.HEAD)).m_41720_() != ItemRegistries.KING_CROWN) {
            this.m_21373_();
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public void m_6667_(DamageSource cause) {
        ItemStack stack;
        super.m_6667_(cause);
        if (this.m_21824_() && this.m_142480_() != null && (stack = this.m_142480_().m_6844_(EquipmentSlot.HEAD)).m_41720_() == ItemRegistries.KING_CROWN) {
            this.m_21373_();
        }
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22284_, 4.0);
    }

    public boolean m_7757_(LivingEntity target, LivingEntity owner) {
        boolean whiteList = !(target instanceof EntityGuard) && !(target instanceof EntityKing) && !(target instanceof ArmorStand);
        return whiteList;
    }

    public AgeableMob m_142606_(ServerLevel p_241840_1_, AgeableMob p_241840_2_) {
        return null;
    }

    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    protected boolean m_8028_() {
        return true;
    }

    protected SoundEvent m_5501_() {
        return SoundEvents.f_12042_;
    }

    protected SoundEvent m_5509_() {
        return SoundEvents.f_12041_;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12039_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12038_;
    }

    protected SoundEvent m_5896_(int heightIn) {
        return heightIn > 4 ? SoundEvents.f_12037_ : SoundEvents.f_12040_;
    }

    protected boolean m_6149_() {
        return !this.m_21824_();
    }

    protected boolean m_6125_() {
        return true;
    }

    public boolean func_230292_f_(Player p_230292_1_) {
        return true;
    }

    public static class GuardTargetSelector
    implements com.google.common.base.Predicate<LivingEntity> {
        private final EntityGuard parentEntity;

        public GuardTargetSelector(EntityGuard guardian) {
            this.parentEntity = guardian;
        }

        public boolean apply(@Nullable LivingEntity p_apply_1_) {
            boolean whiteList = !(p_apply_1_ instanceof EntityGuard) && !(p_apply_1_ instanceof EntityKing) && !(p_apply_1_ instanceof ArmorStand);
            return whiteList && !this.parentEntity.m_21824_();
        }
    }

    public static class GroupData
    extends AgeableMob.AgeableMobGroupData {
        boolean isBodyGuard;
        boolean isPlayerGuard;

        public GroupData(boolean isBodyGuard) {
            super(false);
            this.isBodyGuard = isBodyGuard;
            this.isPlayerGuard = false;
        }

        public GroupData(boolean isBodyGuard, boolean isPlayerGuard) {
            super(false);
            this.isBodyGuard = isBodyGuard;
            this.isPlayerGuard = isPlayerGuard;
        }
    }
}

