/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.entity.projectile;

import com.dainxt.dungeonsmod.entity.boss.EntityKing;
import com.dainxt.dungeonsmod.handlers.EntityRegistries;
import java.util.function.BiConsumer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fmllegacy.network.NetworkHooks;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class EntityItemThrow
extends AbstractHurtingProjectile
implements ItemSupplier {
    private float clientSideRotation = 0.0f;
    private static final EntityDataAccessor<CompoundTag> COMPOUND_STACK = SynchedEntityData.m_135353_(EntityItemThrow.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private BiConsumer<Entity, LivingEntity> onImpact;

    public EntityItemThrow(EntityType<? extends AbstractHurtingProjectile> p_i50173_1_, Level p_i50173_2_) {
        super(p_i50173_1_, p_i50173_2_);
    }

    public EntityItemThrow(Level worldIn, ItemStack thrownStackIn, BiConsumer<Entity, LivingEntity> onImpact) {
        super(EntityRegistries.ITEMTHROW, worldIn);
        this.onImpact = onImpact;
        this.f_19804_.m_135381_(COMPOUND_STACK, (Object)thrownStackIn.m_41777_().m_41739_(new CompoundTag()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public EntityItemThrow(Level worldIn, double x, double y, double z, double accelX, double accelY, double accelZ) {
        super(EntityRegistries.ITEMTHROW, x, y, z, accelX, accelY, accelZ, worldIn);
    }

    public EntityItemThrow(Level worldIn, LivingEntity shooter, double accelX, double accelY, double accelZ) {
        super(EntityRegistries.ITEMTHROW, shooter, accelX, accelY, accelZ, worldIn);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(COMPOUND_STACK, (Object)new CompoundTag());
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_20242_(false);
        Vec3 vector3d = this.m_20184_();
        float f = Mth.m_14116_((float)((float)(vector3d.f_82479_ * vector3d.f_82479_ + vector3d.f_82481_ * vector3d.f_82481_)));
        this.m_146922_((float)(Mth.m_14136_((double)vector3d.f_82479_, (double)vector3d.f_82481_) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)vector3d.f_82480_, (double)f) * 57.2957763671875));
        if (this.m_20184_().m_82526_(this.m_20184_()) < 0.001) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
    }

    protected void m_5790_(EntityHitResult p_213868_1_) {
        if (!this.f_19853_.f_46443_) {
            Entity entity = p_213868_1_.m_82443_();
            Entity entity1 = this.m_37282_();
            if (entity != null && !(entity instanceof EntityKing) && entity instanceof LivingEntity) {
                this.onImpact.accept((Entity)this, (LivingEntity)entity);
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            if (entity1 instanceof LivingEntity) {
                this.m_19970_((LivingEntity)entity1, entity);
            }
        }
    }

    protected float m_6380_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * 0.5f;
    }

    protected float m_6884_() {
        return 0.95f;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return false;
    }

    protected ParticleOptions m_5967_() {
        return ParticleTypes.f_123808_;
    }

    protected boolean m_5931_() {
        return false;
    }

    public void setItemStack(ItemStack stack) {
        this.m_20088_().m_135381_(COMPOUND_STACK, (Object)stack.m_41739_(new CompoundTag()));
    }

    public ItemStack getItemStack() {
        return ItemStack.m_41712_((CompoundTag)((CompoundTag)this.m_20088_().m_135370_(COMPOUND_STACK)));
    }

    public ItemStack m_7846_() {
        return this.getItemStack();
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getRotationAnimation(float partialTicks) {
        if (!this.f_19861_) {
            this.clientSideRotation = 1.0f * ((float)this.f_19797_ + partialTicks) * 50.0f;
        }
        return this.clientSideRotation;
    }
}

