/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.entity.projectile;

import com.dainxt.dungeonsmod.entity.boss.EntitySun;
import com.dainxt.dungeonsmod.handlers.EntityRegistries;
import java.util.function.BiConsumer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fmllegacy.network.NetworkHooks;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class EntitySunPlanet
extends AbstractHurtingProjectile
implements ItemSupplier {
    public boolean isShooted = false;
    private float clientSideRotation = 0.0f;
    private static final EntityDataAccessor<CompoundTag> COMPOUND_STACK = SynchedEntityData.m_135353_(EntitySunPlanet.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private BiConsumer<Entity, LivingEntity> onImpact;

    public EntitySunPlanet(EntityType<? extends AbstractHurtingProjectile> p_i50173_1_, Level p_i50173_2_) {
        super(p_i50173_1_, p_i50173_2_);
    }

    public EntitySunPlanet(Level worldIn, ItemStack thrownStackIn, BiConsumer<Entity, LivingEntity> onImpact) {
        super(EntityRegistries.SUNPLANET, worldIn);
        this.onImpact = onImpact;
        this.f_19804_.m_135381_(COMPOUND_STACK, (Object)thrownStackIn.m_41777_().m_41739_(new CompoundTag()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public EntitySunPlanet(Level worldIn, double x, double y, double z, double accelX, double accelY, double accelZ) {
        super(EntityRegistries.SUNPLANET, x, y, z, accelX, accelY, accelZ, worldIn);
    }

    public EntitySunPlanet(Level worldIn, LivingEntity shooter, double accelX, double accelY, double accelZ) {
        super(EntityRegistries.SUNPLANET, shooter, accelX, accelY, accelZ, worldIn);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(COMPOUND_STACK, (Object)new CompoundTag());
    }

    protected void m_6763_(BlockState state) {
        super.m_6763_(state);
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_20242_(false);
        Vec3 vector3d = this.m_20184_();
        float f = Mth.m_14116_((float)((float)(vector3d.f_82479_ * vector3d.f_82479_ + vector3d.f_82481_ * vector3d.f_82481_)));
        if (this.m_20184_().m_82526_(this.m_20184_()) < 0.001 && this.isShooted) {
            this.explode();
        }
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
    }

    public void explode() {
        boolean flag = ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this.m_37282_());
        this.f_19853_.m_46518_((Entity)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), 10.0f, flag, flag ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.NONE);
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    protected void m_8060_(BlockHitResult p_230299_1_) {
        super.m_8060_(p_230299_1_);
        this.explode();
    }

    protected void m_5790_(EntityHitResult p_213868_1_) {
        if (!this.f_19853_.f_46443_) {
            Entity entity = p_213868_1_.m_82443_();
            Entity entity1 = this.m_37282_();
            if (entity != null && !(entity instanceof EntitySun) && entity instanceof LivingEntity) {
                this.onImpact.accept((Entity)this, (LivingEntity)entity);
                this.explode();
            }
            if (entity1 instanceof LivingEntity) {
                this.m_19970_((LivingEntity)entity1, entity);
            }
        }
    }

    protected float m_6380_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * 0.5f;
    }

    protected float m_6884_() {
        return 0.95f;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return false;
    }

    protected ParticleOptions m_5967_() {
        return ParticleTypes.f_123815_;
    }

    public void m_6686_(double x, double y, double z, float velocity, float inaccuracy) {
        super.m_6686_(x, y, z, velocity, inaccuracy);
        this.isShooted = true;
    }

    protected boolean m_5931_() {
        return false;
    }

    public void setItemStack(ItemStack stack) {
        this.m_20088_().m_135381_(COMPOUND_STACK, (Object)stack.m_41739_(new CompoundTag()));
    }

    public ItemStack getItemStack() {
        return ItemStack.m_41712_((CompoundTag)((CompoundTag)this.m_20088_().m_135370_(COMPOUND_STACK)));
    }

    public ItemStack m_7846_() {
        return this.getItemStack();
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getRotationAnimation(float partialTicks) {
        if (!this.f_19861_) {
            this.clientSideRotation = 1.0f * ((float)this.f_19797_ + partialTicks) * 1.0f;
        }
        return this.clientSideRotation;
    }
}

