/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.handlers;

import com.dainxt.dungeonsmod.config.DungeonsModConfig;
import com.dainxt.dungeonsmod.entity.EntityAnthermite;
import com.dainxt.dungeonsmod.entity.EntityCrow;
import com.dainxt.dungeonsmod.entity.EntityDeadhound;
import com.dainxt.dungeonsmod.entity.EntityExtraPart;
import com.dainxt.dungeonsmod.entity.EntityHaunter;
import com.dainxt.dungeonsmod.entity.EntityLeech;
import com.dainxt.dungeonsmod.entity.EntityLordSkeleton;
import com.dainxt.dungeonsmod.entity.EntityMimic;
import com.dainxt.dungeonsmod.entity.EntityNoteHead;
import com.dainxt.dungeonsmod.entity.EntityPice;
import com.dainxt.dungeonsmod.entity.EntityPiranha;
import com.dainxt.dungeonsmod.entity.EntityPitcher;
import com.dainxt.dungeonsmod.entity.EntityRogue;
import com.dainxt.dungeonsmod.entity.EntitySandCloud;
import com.dainxt.dungeonsmod.entity.EntitySlimond;
import com.dainxt.dungeonsmod.entity.EntityWhirlwind;
import com.dainxt.dungeonsmod.entity.EntityWinterHunter;
import com.dainxt.dungeonsmod.entity.boss.EntityCrawler;
import com.dainxt.dungeonsmod.entity.boss.EntityDeserted;
import com.dainxt.dungeonsmod.entity.boss.EntityIronSlime;
import com.dainxt.dungeonsmod.entity.boss.EntityKing;
import com.dainxt.dungeonsmod.entity.boss.EntityKraken;
import com.dainxt.dungeonsmod.entity.boss.EntitySun;
import com.dainxt.dungeonsmod.entity.boss.EntityVoidMaster;
import com.dainxt.dungeonsmod.entity.dungeons.dungeon4.EntityGuard;
import com.dainxt.dungeonsmod.entity.dungeons.dungeon5.EntityScientist;
import com.dainxt.dungeonsmod.entity.dungeons.dungeon5.EntitySlimewolf;
import com.dainxt.dungeonsmod.entity.projectile.EntityChargedFireball;
import com.dainxt.dungeonsmod.entity.projectile.EntityItemThrow;
import com.dainxt.dungeonsmod.entity.projectile.EntitySunPlanet;
import com.dainxt.dungeonsmod.entity.projectile.EntityVoidLaser;
import com.dainxt.dungeonsmod.sclasses.TravelerEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.world.MobSpawnInfoBuilder;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class EntityRegistries {
    public static final EntityType<EntityExtraPart> EXTRAPART = EntityRegistries.register("extrapart", EntityType.Builder.m_20704_(EntityExtraPart::new, (MobCategory)MobCategory.MONSTER).m_20699_(1.5f, 1.5f).setTrackingRange(100));
    public static final EntityType<EntityVoidLaser> VOIDLASER = EntityRegistries.register("voidlaser", EntityType.Builder.m_20704_(EntityVoidLaser::new, (MobCategory)MobCategory.MISC).m_20699_(1.0f, 1.0f).setTrackingRange(100));
    public static final EntityType<EntityItemThrow> ITEMTHROW = EntityRegistries.register("itemthrowed", EntityType.Builder.m_20704_(EntityItemThrow::new, (MobCategory)MobCategory.MISC).m_20699_(1.0f, 1.0f).setTrackingRange(100));
    public static final EntityType<EntitySandCloud> SANDCLOUD = EntityRegistries.register("sandcloud", EntityType.Builder.m_20704_(EntitySandCloud::new, (MobCategory)MobCategory.MISC).m_20699_(2.0f, 1.5f).setTrackingRange(100));
    public static final EntityType<EntityChargedFireball> CHARGEDFIREBALL = EntityRegistries.register("chargedfireball", EntityType.Builder.m_20704_(EntityChargedFireball::new, (MobCategory)MobCategory.MISC).m_20699_(1.0f, 1.0f).m_20702_(4).m_20717_(10));
    public static final EntityType<TravelerEntity> TRAVELER = EntityRegistries.register("traveler", EntityType.Builder.m_20704_(TravelerEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.6f, 1.95f).m_20702_(10));
    public static final EntityType<EntitySunPlanet> SUNPLANET = EntityRegistries.register("sunplanet", EntityType.Builder.m_20704_(EntitySunPlanet::new, (MobCategory)MobCategory.MISC).m_20699_(2.0f, 2.0f).setTrackingRange(100));
    public static final EntityType<EntityAnthermite> ANTHERMITE = EntityRegistries.register("anthermite", EntityType.Builder.m_20704_(EntityAnthermite::new, (MobCategory)MobCategory.MONSTER).m_20699_(1.0f, 0.75f).setTrackingRange(100));
    public static final EntityType<EntityMimic> MIMIC = EntityRegistries.register("mimic", EntityType.Builder.m_20704_(EntityMimic::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.9f, 0.9f).setTrackingRange(100));
    public static final EntityType<EntityPiranha> PIRANHA = EntityRegistries.register("piranha", EntityType.Builder.m_20704_(EntityPiranha::new, (MobCategory)MobCategory.WATER_CREATURE).m_20699_(0.8f, 0.8f).setTrackingRange(100));
    public static final EntityType<EntityRogue> ROGUE = EntityRegistries.register("rogue", EntityType.Builder.m_20704_(EntityRogue::new, (MobCategory)MobCategory.MONSTER).setTrackingRange(100));
    public static final EntityType<EntitySlimond> SLIMOND = EntityRegistries.register("slimond", EntityType.Builder.m_20704_(EntitySlimond::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.9f, 0.9f).setTrackingRange(100));
    public static final EntityType<EntityHaunter> HAUNTER = EntityRegistries.register("haunter", EntityType.Builder.m_20704_(EntityHaunter::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.8f, 1.5f).setTrackingRange(100));
    public static final EntityType<EntityLordSkeleton> LORDSKELETON = EntityRegistries.register("lordskeleton", EntityType.Builder.m_20704_(EntityLordSkeleton::new, (MobCategory)MobCategory.MONSTER).m_20699_(2.0f, 6.9f).setTrackingRange(100));
    public static final EntityType<EntityDeadhound> DEADHOUND = EntityRegistries.register("deadhound", EntityType.Builder.m_20704_(EntityDeadhound::new, (MobCategory)MobCategory.MONSTER).m_20699_(1.9f, 1.9f).setTrackingRange(100));
    public static final EntityType<EntityCrow> CROW = EntityRegistries.register("crow", EntityType.Builder.m_20704_(EntityCrow::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.5f, 0.6f).setTrackingRange(100));
    public static final EntityType<EntityNoteHead> NOTEHEAD = EntityRegistries.register("notehead", EntityType.Builder.m_20704_(EntityNoteHead::new, (MobCategory)MobCategory.MONSTER).m_20699_(3.5f, 22.1f).setTrackingRange(100));
    public static final EntityType<EntityWinterHunter> WINTERHUNTER = EntityRegistries.register("winterhunter", EntityType.Builder.m_20704_(EntityWinterHunter::new, (MobCategory)MobCategory.MONSTER).m_20699_(2.5f, 10.0f).setTrackingRange(100));
    public static final EntityType<EntityPice> PICE = EntityRegistries.register("pice", EntityType.Builder.m_20704_(EntityPice::new, (MobCategory)MobCategory.CREATURE).m_20699_(1.5f, 1.5f).setTrackingRange(100));
    public static final EntityType<EntityLeech> LEECH = EntityRegistries.register("leech", EntityType.Builder.m_20704_(EntityLeech::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.9f, 0.9f).setTrackingRange(100));
    public static final EntityType<EntityPitcher> PITCHER = EntityRegistries.register("pitcher", EntityType.Builder.m_20704_(EntityPitcher::new, (MobCategory)MobCategory.MONSTER).m_20699_(1.0f, 1.2f).setTrackingRange(100));
    public static final EntityType<EntityWhirlwind> WHIRLWIND = EntityRegistries.register("whirlwind", EntityType.Builder.m_20704_(EntityWhirlwind::new, (MobCategory)MobCategory.MONSTER).m_20699_(3.0f, 5.0f).setTrackingRange(100));
    public static final EntityType<EntityCrawler> CRAWLER = EntityRegistries.register("crawler", EntityType.Builder.m_20704_(EntityCrawler::new, (MobCategory)MobCategory.CREATURE).m_20719_().m_20699_(5.0f, 5.0f).setTrackingRange(100));
    public static final EntityType<EntityDeserted> DESERTED = EntityRegistries.register("deserted", EntityType.Builder.m_20704_(EntityDeserted::new, (MobCategory)MobCategory.CREATURE).m_20699_(1.5f, 2.5f).setTrackingRange(100));
    public static final EntityType<EntityIronSlime> IRONSLIME = EntityRegistries.register("ironslime", EntityType.Builder.m_20704_(EntityIronSlime::new, (MobCategory)MobCategory.CREATURE).m_20699_(3.0f, 3.0f).setTrackingRange(100));
    public static final EntityType<EntityKing> KING = EntityRegistries.register("king", EntityType.Builder.m_20704_(EntityKing::new, (MobCategory)MobCategory.CREATURE).m_20699_(1.8f, 5.0f).setTrackingRange(100));
    public static final EntityType<EntityKraken> KRAKEN = EntityRegistries.register("kraken", EntityType.Builder.m_20704_(EntityKraken::new, (MobCategory)MobCategory.CREATURE).m_20699_(5.0f, 5.0f).setTrackingRange(100));
    public static final EntityType<EntitySun> SUN = EntityRegistries.register("sun", EntityType.Builder.m_20704_(EntitySun::new, (MobCategory)MobCategory.CREATURE).m_20719_().m_20699_(25.0f, 25.0f).setTrackingRange(100));
    public static final EntityType<EntityVoidMaster> VOIDMASTER = EntityRegistries.register("voidmaster", EntityType.Builder.m_20704_(EntityVoidMaster::new, (MobCategory)MobCategory.CREATURE).m_20719_().m_20699_(12.0f, 12.0f).setTrackingRange(100));
    public static final EntityType<EntityGuard> GUARD = EntityRegistries.register("guard", EntityType.Builder.m_20704_(EntityGuard::new, (MobCategory)MobCategory.CREATURE).setTrackingRange(100));
    public static final EntityType<EntityScientist> SCIENTIST = EntityRegistries.register("scientist", EntityType.Builder.m_20704_(EntityScientist::new, (MobCategory)MobCategory.CREATURE).setTrackingRange(100));
    public static final EntityType<EntitySlimewolf> SLIMEWOLF = EntityRegistries.register("slimewolf", EntityType.Builder.m_20704_(EntitySlimewolf::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 0.9f).setTrackingRange(100));

    @SubscribeEvent
    public static void onEntityRegistry(RegistryEvent.Register<EntityType<?>> e) {
        e.getRegistry().register(EXTRAPART);
        e.getRegistry().register(VOIDLASER);
        e.getRegistry().register(ITEMTHROW);
        e.getRegistry().register(SANDCLOUD);
        e.getRegistry().register(CHARGEDFIREBALL);
        e.getRegistry().register(TRAVELER);
        e.getRegistry().register(SUNPLANET);
        e.getRegistry().register(ANTHERMITE);
        SpawnPlacements.m_21754_(ANTHERMITE, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EntityAnthermite::canSpawn);
        e.getRegistry().register(MIMIC);
        SpawnPlacements.m_21754_(MIMIC, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EntityMimic::canSpawn);
        e.getRegistry().register(PIRANHA);
        SpawnPlacements.m_21754_(PIRANHA, (SpawnPlacements.Type)SpawnPlacements.Type.IN_WATER, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EntityPiranha::canSpawn);
        e.getRegistry().register(ROGUE);
        SpawnPlacements.m_21754_(ROGUE, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EntityRogue::canSpawn);
        e.getRegistry().register(SLIMOND);
        SpawnPlacements.m_21754_(SLIMOND, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EntitySlimond::canSpawn);
        e.getRegistry().register(HAUNTER);
        SpawnPlacements.m_21754_(HAUNTER, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EntityHaunter::canSpawn);
        e.getRegistry().register(LORDSKELETON);
        e.getRegistry().register(DEADHOUND);
        e.getRegistry().register(CROW);
        SpawnPlacements.m_21754_(CROW, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EntityCrow::canSpawn);
        e.getRegistry().register(NOTEHEAD);
        SpawnPlacements.m_21754_(NOTEHEAD, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EntityNoteHead::canSpawn);
        e.getRegistry().register(WINTERHUNTER);
        SpawnPlacements.m_21754_(WINTERHUNTER, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EntityWinterHunter::canSpawn);
        e.getRegistry().register(PICE);
        SpawnPlacements.m_21754_(PICE, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EntityPice::canSpawn);
        e.getRegistry().register(LEECH);
        SpawnPlacements.m_21754_(LEECH, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EntityLeech::canSpawn);
        e.getRegistry().register(PITCHER);
        SpawnPlacements.m_21754_(PITCHER, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EntityPitcher::canSpawn);
        e.getRegistry().register(WHIRLWIND);
        SpawnPlacements.m_21754_(WHIRLWIND, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EntityWhirlwind::canSpawn);
        e.getRegistry().register(CRAWLER);
        e.getRegistry().register(DESERTED);
        e.getRegistry().register(IRONSLIME);
        e.getRegistry().register(KING);
        e.getRegistry().register(KRAKEN);
        e.getRegistry().register(SUN);
        e.getRegistry().register(VOIDMASTER);
        e.getRegistry().register(GUARD);
        e.getRegistry().register(SCIENTIST);
        e.getRegistry().register(SLIMEWOLF);
    }

    private static <T extends Entity> EntityType<T> register(String name, EntityType.Builder<T> entityTypeBuilder) {
        EntityType entityType = entityTypeBuilder.m_20712_(name);
        entityType.setRegistryName(name);
        return entityType;
    }

    @SubscribeEvent
    public static <T extends Entity> void registerAttributes(EntityAttributeCreationEvent event) {
        event.put(EXTRAPART, EntityExtraPart.createMobAttributes().m_22265_());
        event.put(SANDCLOUD, EntitySandCloud.createMobAttributes().m_22265_());
        event.put(TRAVELER, Villager.m_35503_().m_22265_());
        event.put(ANTHERMITE, EntityAnthermite.createMobAttributes().m_22265_());
        event.put(MIMIC, EntityMimic.createMobAttributes().m_22265_());
        event.put(PIRANHA, EntityPiranha.createMobAttributes().m_22265_());
        event.put(ROGUE, EntityRogue.createMobAttributes().m_22265_());
        event.put(SLIMOND, EntitySlimond.createMobAttributes().m_22265_());
        event.put(HAUNTER, EntityHaunter.createMobAttributes().m_22265_());
        event.put(LORDSKELETON, EntityLordSkeleton.createMobAttributes().m_22265_());
        event.put(DEADHOUND, EntityDeadhound.createMobAttributes().m_22265_());
        event.put(CROW, EntityCrow.createMobAttributes().m_22265_());
        event.put(NOTEHEAD, EntityNoteHead.createMobAttributes().m_22265_());
        event.put(WINTERHUNTER, EntityWinterHunter.createMobAttributes().m_22265_());
        event.put(PICE, EntityPice.createMobAttributes().m_22265_());
        event.put(LEECH, EntityLeech.createMobAttributes().m_22265_());
        event.put(PITCHER, EntityPitcher.createMobAttributes().m_22265_());
        event.put(WHIRLWIND, EntityWhirlwind.createMobAttributes().m_22265_());
        event.put(CRAWLER, EntityCrawler.createMobAttributes().m_22265_());
        event.put(DESERTED, EntityDeserted.createMobAttributes().m_22265_());
        event.put(IRONSLIME, EntityIronSlime.createMobAttributes().m_22265_());
        event.put(KING, EntityKing.createMobAttributes().m_22265_());
        event.put(KRAKEN, EntityKraken.createMobAttributes().m_22265_());
        event.put(SUN, EntitySun.createMobAttributes().m_22265_());
        event.put(VOIDMASTER, EntityVoidMaster.createMobAttributes().m_22265_());
        event.put(GUARD, EntityGuard.createMobAttributes().m_22265_());
        event.put(SCIENTIST, EntityScientist.createMobAttributes().m_22265_());
        event.put(SLIMEWOLF, EntitySlimewolf.createMobAttributes().m_22265_());
    }

    public static void registerEntityWorldSpawn(MobSpawnInfoBuilder builder, EntityType<?> type, int weight, int min, int max) {
        if (weight > 0) {
            builder.m_48376_(type.m_20674_(), new MobSpawnSettings.SpawnerData(type, weight, min, max));
        }
    }

    public static void registerOnBiomes(BiomeLoadingEvent e) {
        boolean blackFlag = false;
        for (Biome biome : DungeonsModConfig.COMMON.blackMobs.get()) {
            if (!biome.getRegistryName().equals((Object)e.getName())) continue;
            blackFlag = true;
        }
        if (!blackFlag) {
            if (e.getCategory() == Biome.BiomeCategory.DESERT) {
                EntityRegistries.registerEntityWorldSpawn(e.getSpawns(), ANTHERMITE, DungeonsModConfig.COMMON.anthermite.getWeight(), 2, 5);
            }
            if (e.getCategory() == Biome.BiomeCategory.PLAINS) {
                EntityRegistries.registerEntityWorldSpawn(e.getSpawns(), MIMIC, DungeonsModConfig.COMMON.mimic.getWeight(), 1, 1);
            }
            if (e.getCategory() == Biome.BiomeCategory.OCEAN) {
                EntityRegistries.registerEntityWorldSpawn(e.getSpawns(), PIRANHA, DungeonsModConfig.COMMON.piranha.getWeight(), 2, 3);
            }
            if (e.getCategory() == Biome.BiomeCategory.FOREST) {
                EntityRegistries.registerEntityWorldSpawn(e.getSpawns(), ROGUE, DungeonsModConfig.COMMON.rogue.getWeight(), 1, 1);
            }
            if (e.getCategory() == Biome.BiomeCategory.SWAMP) {
                EntityRegistries.registerEntityWorldSpawn(e.getSpawns(), SLIMOND, DungeonsModConfig.COMMON.slimond.getWeight(), 1, 1);
            }
            if (e.getCategory() == Biome.BiomeCategory.SWAMP) {
                EntityRegistries.registerEntityWorldSpawn(e.getSpawns(), HAUNTER, DungeonsModConfig.COMMON.haunter.getWeight(), 1, 1);
                EntityRegistries.registerEntityWorldSpawn(e.getSpawns(), NOTEHEAD, DungeonsModConfig.COMMON.notehead.getWeight(), 1, 1);
                EntityRegistries.registerEntityWorldSpawn(e.getSpawns(), CROW, DungeonsModConfig.COMMON.notehead.getWeight(), 1, 1);
            }
            if (e.getCategory() == Biome.BiomeCategory.TAIGA || e.getCategory() == Biome.BiomeCategory.ICY) {
                EntityRegistries.registerEntityWorldSpawn(e.getSpawns(), NOTEHEAD, DungeonsModConfig.COMMON.notehead.getWeight(), 1, 1);
            }
            if (e.getCategory() == Biome.BiomeCategory.MESA || e.getCategory() == Biome.BiomeCategory.DESERT || e.getCategory() == Biome.BiomeCategory.FOREST) {
                EntityRegistries.registerEntityWorldSpawn(e.getSpawns(), CROW, DungeonsModConfig.COMMON.crow.getWeight(), 1, 1);
            }
            if (e.getCategory() == Biome.BiomeCategory.TAIGA || e.getCategory() == Biome.BiomeCategory.ICY) {
                EntityRegistries.registerEntityWorldSpawn(e.getSpawns(), WHIRLWIND, DungeonsModConfig.COMMON.whirlwind.getWeight(), 1, 1);
                EntityRegistries.registerEntityWorldSpawn(e.getSpawns(), PICE, DungeonsModConfig.COMMON.pice.getWeight(), 1, 2);
            }
        }
    }
}

