/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.handlers;

import com.dainxt.dungeonsmod.config.DungeonsModConfig;
import com.dainxt.dungeonsmod.entity.EntityHaunter;
import com.dainxt.dungeonsmod.entity.boss.EntityKing;
import com.dainxt.dungeonsmod.entity.boss.EntitySun;
import com.dainxt.dungeonsmod.entity.boss.EntityVoidMaster;
import com.dainxt.dungeonsmod.handlers.EntityRegistries;
import com.dainxt.dungeonsmod.handlers.ItemRegistries;
import com.dainxt.dungeonsmod.handlers.StructureRegistries;
import com.dainxt.dungeonsmod.items.ItemArmorMaterials;
import com.dainxt.dungeonsmod.util.EntityUtils;
import com.dainxt.dungeonsmod.util.Location;
import com.dainxt.dungeonsmod.util.SpawnUtils;
import com.dainxt.dungeonsmod.util.TeleportHelper;
import java.util.List;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EventsHandler {
    @SubscribeEvent
    public void onExplosionEvent(ExplosionEvent.Start event) {
        if (!event.getWorld().f_46443_) {
            Entity exploder;
            if (event.getWorld().m_46472_().equals((Object)Level.f_46430_)) {
                Vec3 position = event.getExplosion().getPosition();
                if (LocationPredicate.m_52627_(StructureRegistries.dungeon7_feature).m_52617_((ServerLevel)event.getWorld(), position.m_7096_(), position.m_7098_(), position.m_7094_())) {
                    event.setCanceled(true);
                }
            }
            if (event.getWorld().m_46472_().equals((Object)Level.f_46429_) && (exploder = event.getExplosion().getExploder()) != null && event.getExplosion().getExploder() instanceof PrimedTnt) {
                BlockPos explosionPos = exploder.m_142538_();
                AABB box = new AABB(explosionPos);
                List kings = event.getWorld().m_45976_(EntitySun.class, box.m_82400_(10.0));
                if (!kings.isEmpty()) {
                    for (EntitySun king : kings) {
                        int leftIce = EntityUtils.scanBlocksInAABB(exploder, box.m_82400_(0.5), (pos, state, distance) -> {
                            if (distance == null) {
                                distance = 25;
                            } else if (state.m_60734_().equals(Blocks.f_50568_)) {
                                Integer n = distance;
                                distance = distance - 1;
                            }
                            return distance;
                        });
                        if (leftIce > 0) continue;
                        king.m_6469_(EntitySun.causeBlueDamage(), king.m_21233_() / 6.0f);
                        double maxDistance = 10.0;
                        EntityUtils.scanBlocksInAABB(exploder, box.m_82400_(maxDistance), (blockPos, blockState, dsitance) -> {
                            double distance;
                            Block block = blockState.m_60734_();
                            boolean flag = false;
                            if (!block.equals(Blocks.f_50752_) && (distance = blockPos.m_123331_((Vec3i)explosionPos)) < maxDistance * maxDistance) {
                                flag = distance > 81.0 && event.getExplosion().getExploder().f_19853_.f_46441_.nextInt(25) == 0 ? exploder.f_19853_.m_46597_(blockPos, Blocks.f_50126_.m_49966_()) || flag : exploder.f_19853_.m_46597_(blockPos, Blocks.f_50016_.m_49966_()) || flag;
                            }
                            return flag;
                        });
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onLivingDamageEvent(LivingDamageEvent event) {
        SpawnUtils.invokeSun(event);
        if (event.getEntityLiving() instanceof Player && event.getSource().equals(DamageSource.f_19315_) && EntityUtils.entityHaveAllArmor(event.getEntityLiving(), ItemArmorMaterials.CRAWLER)) {
            LivingEntity attacker = event.getEntityLiving();
            Level world = attacker.f_19853_;
            world.m_6249_((Entity)attacker, attacker.m_142469_().m_82400_(7.0), EntitySelector.f_20402_).forEach(entity -> {
                if (entity instanceof LivingEntity) {
                    entity.m_6469_(DamageSource.m_19370_((LivingEntity)attacker).m_19389_(), 7.0f);
                }
            });
            world.m_5594_(null, attacker.m_142538_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 10.0f, 0.1f);
            if (attacker instanceof Player) {
                world.m_7605_((Entity)attacker, (byte)43);
            }
        }
    }

    @SubscribeEvent
    public void onInteractEvent(PlayerInteractEvent event) {
        SpawnUtils.invokeLordSkeleton(event);
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getWorld().f_46443_) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void onEntityPlace(BlockEvent.EntityPlaceEvent e) {
        if (e.getWorld() != null || e.getEntity() != null) {
            BlockSnapshot blockSnap = e.getBlockSnapshot();
            Level world = null;
            BlockPos pos = blockSnap.getPos();
            if (e.getWorld() instanceof Level) {
                world = (Level)e.getWorld();
            } else if (e.getEntity() != null) {
                pos = e.getEntity().m_142538_();
                world = e.getEntity().f_19853_;
            }
            if (world != null && !world.m_5776_()) {
                List kings;
                AABB box;
                ServerLevel serverWorld = (ServerLevel)world;
                if (serverWorld.m_46472_().equals((Object)Level.f_46428_)) {
                    box = new AABB(e.getPos()).m_82400_(12.0);
                    if (LocationPredicate.m_52627_(StructureRegistries.dungeon4_feature).m_52617_(serverWorld, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) && !(kings = serverWorld.m_45976_(EntityKing.class, box)).isEmpty()) {
                        for (EntityKing king : kings) {
                            king.DESTROY_BLOCKS_2.put(e.getPos(), e.getState());
                        }
                    }
                }
                if (serverWorld.m_46472_().equals((Object)Level.f_46430_) && LocationPredicate.m_52627_(StructureRegistries.dungeon7_feature).m_52617_(serverWorld, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) && !(kings = serverWorld.m_45976_(EntityVoidMaster.class, box = new AABB(e.getPos()).m_82400_(128.0))).isEmpty()) {
                    if (e.getEntity() != null) {
                        if (!((Player)e.getEntity()).m_150110_().f_35937_) {
                            e.setCanceled(true);
                        }
                    } else {
                        e.setCanceled(true);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityBreak(BlockEvent.BreakEvent e) {
        if (!e.getPlayer().f_19853_.f_46443_) {
            List kings;
            AABB box;
            ServerPlayer player = (ServerPlayer)e.getPlayer();
            if (e.getPlayer().f_19853_.m_46472_().equals((Object)Level.f_46428_)) {
                box = new AABB(e.getPos()).m_82400_(12.0);
                if (LocationPredicate.m_52627_(StructureRegistries.dungeon4_feature).m_52617_(player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_()) && !(kings = e.getWorld().m_45976_(EntityKing.class, box)).isEmpty() && !e.getWorld().m_5776_()) {
                    for (EntityKing king : kings) {
                        king.FIX_BLOCKS_2.put(e.getPos(), e.getState());
                        if (!king.m_142469_().m_82400_(3.5).m_82381_(new AABB(e.getPos()))) continue;
                        e.setCanceled(true);
                    }
                }
            }
            if (e.getPlayer().f_19853_.m_46472_().equals((Object)Level.f_46430_) && LocationPredicate.m_52627_(StructureRegistries.dungeon7_feature).m_52617_(player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_())) {
                if (e.getPlayer() instanceof Player) {
                    box = new AABB(e.getPos()).m_82400_(128.0);
                    kings = e.getWorld().m_45976_(EntityVoidMaster.class, box);
                    if (!(kings.isEmpty() || e.getWorld().m_5776_() || e.getPlayer().m_150110_().f_35937_)) {
                        e.setCanceled(true);
                    }
                } else {
                    e.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public void onBiomeLoading(BiomeLoadingEvent e) {
        StructureRegistries.registerOnBiomes(e);
        EntityRegistries.registerOnBiomes(e);
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (((Boolean)DungeonsModConfig.COMMON.applyDatapackFix.get()).booleanValue()) {
            StructureRegistries.patchStructuresIfGone(event);
        }
    }

    @SubscribeEvent
    public void dieEvent(LivingDeathEvent event) {
        Wolf dog;
        ServerPlayer player;
        if (!event.getEntity().f_19853_.f_46443_ && event.getEntityLiving() instanceof ServerPlayer && event.getEntity().f_19853_.m_46472_().equals((Object)Level.f_46430_)) {
            List voidMasters;
            player = (ServerPlayer)event.getEntityLiving();
            if (LocationPredicate.m_52627_(StructureRegistries.dungeon7_feature).m_52617_(player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_()) && !(voidMasters = player.m_9236_().m_143280_(EntityRegistries.VOIDMASTER, EntitySelector.f_20402_)).isEmpty()) {
                voidMasters.forEach(voidMaster -> {
                    if (voidMaster instanceof EntityVoidMaster) {
                        voidMaster.tombPlayer((Player)player);
                    }
                });
            }
        }
        if (!event.getEntity().f_19853_.f_46443_ && event.getEntityLiving() instanceof ServerPlayer) {
            player = (ServerPlayer)event.getEntityLiving();
            int chance = (Integer)DungeonsModConfig.COMMON.playerLeaveGhost.get();
            if (chance >= 1 && player.m_21187_().nextInt(chance) == 0) {
                EntityHaunter haunter = new EntityHaunter(EntityRegistries.HAUNTER, event.getEntityLiving().f_19853_);
                haunter.m_7678_(event.getEntityLiving().m_20185_(), event.getEntityLiving().m_20186_(), event.getEntityLiving().m_20189_(), 0.0f, 0.0f);
            }
            TeleportHelper.playerBackMap.put(player.m_142081_(), new Location(event.getEntity().m_142538_(), (ResourceKey<Level>)event.getEntity().f_19853_.m_46472_()));
        }
        if (!event.getEntity().f_19853_.f_46443_ && event.getEntityLiving() instanceof Wolf && (dog = (Wolf)event.getEntityLiving()).m_142480_() instanceof Player) {
            Player player2 = (Player)dog.m_142480_();
            ItemStack goldenBone = new ItemStack((ItemLike)ItemRegistries.GOLDEN_BONE);
            if (DungeonsModConfig.COMMON.enableGoldenBone.isEnabled()) {
                if (player2.m_150109_().m_36063_(goldenBone)) {
                    int spottedInventorySlot = player2.m_150109_().m_36043_(goldenBone);
                    boolean spottedOffhandSlot = player2.m_21206_().m_41720_().equals(ItemRegistries.GOLDEN_BONE);
                    if (spottedInventorySlot > 0) {
                        player2.m_150109_().m_7407_(spottedInventorySlot, 1);
                    } else if (spottedOffhandSlot) {
                        player2.m_21206_().m_41774_(1);
                    } else {
                        return;
                    }
                    event.setCanceled(true);
                    dog.m_21153_(dog.m_21233_());
                    dog.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 3600, 10));
                    dog.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 3600));
                    dog.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 3600, 3));
                    dog.m_20324_(player2.m_20185_(), player2.m_20186_(), player2.m_20189_());
                    dog.f_19853_.m_7605_((Entity)dog, (byte)35);
                    dog.f_19853_.m_7605_((Entity)dog, (byte)8);
                }
            } else if (player2 instanceof Player) {
                player2.m_5661_((Component)new TranslatableComponent("item.dungeonsmod.golden_bone.denied"), true);
            }
        }
    }
}

