/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.handlers;

import com.dainxt.dungeonsmod.config.DungeonsModConfig;
import com.dainxt.dungeonsmod.interfaces.IDungeon;
import com.dainxt.dungeonsmod.world.gen.config.SewerConfig;
import com.dainxt.dungeonsmod.world.gen.generators.Dungeon0Generator;
import com.dainxt.dungeonsmod.world.gen.generators.Dungeon1Generator;
import com.dainxt.dungeonsmod.world.gen.generators.Dungeon2Generator;
import com.dainxt.dungeonsmod.world.gen.generators.Dungeon3Generator;
import com.dainxt.dungeonsmod.world.gen.generators.Dungeon4Generator;
import com.dainxt.dungeonsmod.world.gen.generators.Dungeon5Generator;
import com.dainxt.dungeonsmod.world.gen.generators.Dungeon6Generator;
import com.dainxt.dungeonsmod.world.gen.generators.Dungeon7Generator;
import com.dainxt.dungeonsmod.world.gen.generators.DungeonSide11Generator;
import com.dainxt.dungeonsmod.world.gen.generators.DungeonSide21Generator;
import com.dainxt.dungeonsmod.world.gen.generators.DungeonSide22Generator;
import com.dainxt.dungeonsmod.world.gen.generators.DungeonSide31Generator;
import com.dainxt.dungeonsmod.world.gen.pools.DungeonSide31Pools;
import com.dainxt.dungeonsmod.world.gen.structures.Dungeon0;
import com.dainxt.dungeonsmod.world.gen.structures.Dungeon1;
import com.dainxt.dungeonsmod.world.gen.structures.Dungeon2;
import com.dainxt.dungeonsmod.world.gen.structures.Dungeon3;
import com.dainxt.dungeonsmod.world.gen.structures.Dungeon4;
import com.dainxt.dungeonsmod.world.gen.structures.Dungeon5;
import com.dainxt.dungeonsmod.world.gen.structures.Dungeon6;
import com.dainxt.dungeonsmod.world.gen.structures.Dungeon7;
import com.dainxt.dungeonsmod.world.gen.structures.DungeonSide11;
import com.dainxt.dungeonsmod.world.gen.structures.DungeonSide21;
import com.dainxt.dungeonsmod.world.gen.structures.DungeonSide22;
import com.dainxt.dungeonsmod.world.gen.structures.DungeonSide31;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.StructurePieceType;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.structures.StructurePoolElementType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class StructureRegistries {
    private static final ResourceLocation dungeonside1_identifier = new ResourceLocation("dungeonsmod", "the_chapel");
    public static final StructurePieceType dungeonside1_piece = (StructurePieceType)Registry.m_122965_((Registry)Registry.f_122843_, (ResourceLocation)new ResourceLocation("dungeonsmod:dungeonside1_piece"), DungeonSide11Generator.Piece::new);
    public static final StructureFeature<NoneFeatureConfiguration> dungeonside1_feature = new DungeonSide11(dungeonside1_identifier, (Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_);
    public static final ConfiguredStructureFeature<NoneFeatureConfiguration, ? extends StructureFeature<NoneFeatureConfiguration>> dungeonside1_configured_feature = (ConfiguredStructureFeature)BuiltinRegistries.m_123880_((Registry)BuiltinRegistries.f_123862_, (ResourceLocation)dungeonside1_identifier, (Object)dungeonside1_feature.m_67065_((FeatureConfiguration)NoneFeatureConfiguration.f_67816_));
    private static final ResourceLocation dungeonside21_identifier = new ResourceLocation("dungeonsmod", "the_nest");
    public static final StructurePieceType dungeonside21_piece = (StructurePieceType)Registry.m_122965_((Registry)Registry.f_122843_, (ResourceLocation)new ResourceLocation("dungeonsmod:dungeonside21_piece"), DungeonSide21Generator.Piece::new);
    public static final StructureFeature<NoneFeatureConfiguration> dungeonside21_feature = new DungeonSide21(dungeonside21_identifier, (Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_);
    public static final ConfiguredStructureFeature<NoneFeatureConfiguration, ? extends StructureFeature<NoneFeatureConfiguration>> dungeonside21_configured_feature = (ConfiguredStructureFeature)BuiltinRegistries.m_123880_((Registry)BuiltinRegistries.f_123862_, (ResourceLocation)dungeonside21_identifier, (Object)dungeonside21_feature.m_67065_((FeatureConfiguration)NoneFeatureConfiguration.f_67816_));
    private static final ResourceLocation dungeonside22_identifier = new ResourceLocation("dungeonsmod", "the_pitcher");
    public static final StructurePieceType dungeonside22_piece = (StructurePieceType)Registry.m_122965_((Registry)Registry.f_122843_, (ResourceLocation)new ResourceLocation("dungeonsmod:dungeonside22_piece"), DungeonSide22Generator.Piece::new);
    public static final StructureFeature<NoneFeatureConfiguration> dungeonside22_feature = new DungeonSide22(dungeonside22_identifier, (Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_);
    public static final ConfiguredStructureFeature<NoneFeatureConfiguration, ? extends StructureFeature<NoneFeatureConfiguration>> dungeonside22_configured_feature = (ConfiguredStructureFeature)BuiltinRegistries.m_123880_((Registry)BuiltinRegistries.f_123862_, (ResourceLocation)dungeonside22_identifier, (Object)dungeonside22_feature.m_67065_((FeatureConfiguration)NoneFeatureConfiguration.f_67816_));
    private static final ResourceLocation dungeon0_identifier = new ResourceLocation("dungeonsmod", "the_camp");
    public static final StructurePieceType dungeon0_piece = (StructurePieceType)Registry.m_122965_((Registry)Registry.f_122843_, (ResourceLocation)new ResourceLocation("dungeonsmod:dungeon0_piece"), Dungeon0Generator.Piece::new);
    public static final StructureFeature<NoneFeatureConfiguration> dungeon0_feature = new Dungeon0(dungeon0_identifier, (Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_);
    public static final ConfiguredStructureFeature<NoneFeatureConfiguration, ? extends StructureFeature<NoneFeatureConfiguration>> dungeon0_configured_feature = (ConfiguredStructureFeature)BuiltinRegistries.m_123880_((Registry)BuiltinRegistries.f_123862_, (ResourceLocation)dungeon0_identifier, (Object)dungeon0_feature.m_67065_((FeatureConfiguration)NoneFeatureConfiguration.f_67816_));
    private static final ResourceLocation dungeon1_identifier = new ResourceLocation("dungeonsmod", "the_house");
    public static final StructurePieceType dungeon1_piece = (StructurePieceType)Registry.m_122965_((Registry)Registry.f_122843_, (ResourceLocation)new ResourceLocation("dungeonsmod:dungeon1_piece"), Dungeon1Generator.Piece::new);
    public static final StructureFeature<NoneFeatureConfiguration> dungeon1_feature = new Dungeon1(dungeon1_identifier, (Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_);
    public static final ConfiguredStructureFeature<NoneFeatureConfiguration, ? extends StructureFeature<NoneFeatureConfiguration>> dungeon1_configured_feature = (ConfiguredStructureFeature)BuiltinRegistries.m_123880_((Registry)BuiltinRegistries.f_123862_, (ResourceLocation)dungeon1_identifier, (Object)dungeon1_feature.m_67065_((FeatureConfiguration)NoneFeatureConfiguration.f_67816_));
    private static final ResourceLocation dungeon2_identifier = new ResourceLocation("dungeonsmod", "the_mines");
    public static final StructurePieceType dungeon2_piece = (StructurePieceType)Registry.m_122965_((Registry)Registry.f_122843_, (ResourceLocation)new ResourceLocation("dungeonsmod:dungeon2_piece"), Dungeon2Generator.Piece::new);
    public static final StructureFeature<NoneFeatureConfiguration> dungeon2_feature = new Dungeon2(dungeon2_identifier, (Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_);
    public static final ConfiguredStructureFeature<NoneFeatureConfiguration, ? extends StructureFeature<NoneFeatureConfiguration>> dungeon2_configured_feature = (ConfiguredStructureFeature)BuiltinRegistries.m_123880_((Registry)BuiltinRegistries.f_123862_, (ResourceLocation)dungeon2_identifier, (Object)dungeon2_feature.m_67065_((FeatureConfiguration)NoneFeatureConfiguration.f_67816_));
    private static final ResourceLocation dungeon3_identifier = new ResourceLocation("dungeonsmod", "the_ship");
    public static final StructurePieceType dungeon3_piece = (StructurePieceType)Registry.m_122965_((Registry)Registry.f_122843_, (ResourceLocation)new ResourceLocation("dungeonsmod:dungeon3_piece"), Dungeon3Generator.Piece::new);
    public static final StructureFeature<NoneFeatureConfiguration> dungeon3_feature = new Dungeon3(dungeon3_identifier, (Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_);
    public static final ConfiguredStructureFeature<NoneFeatureConfiguration, ? extends StructureFeature<NoneFeatureConfiguration>> dungeon3_configured_feature = (ConfiguredStructureFeature)BuiltinRegistries.m_123880_((Registry)BuiltinRegistries.f_123862_, (ResourceLocation)dungeon3_identifier, (Object)dungeon3_feature.m_67065_((FeatureConfiguration)NoneFeatureConfiguration.f_67816_));
    private static final ResourceLocation dungeon4_identifier = new ResourceLocation("dungeonsmod", "the_castle");
    public static final StructurePieceType dungeon4_piece = (StructurePieceType)Registry.m_122965_((Registry)Registry.f_122843_, (ResourceLocation)new ResourceLocation("dungeonsmod:dungeon4_piece"), Dungeon4Generator.Piece::new);
    public static final StructureFeature<NoneFeatureConfiguration> dungeon4_feature = new Dungeon4(dungeon4_identifier, (Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_);
    public static final ConfiguredStructureFeature<NoneFeatureConfiguration, ? extends StructureFeature<NoneFeatureConfiguration>> dungeon4_configured_feature = (ConfiguredStructureFeature)BuiltinRegistries.m_123880_((Registry)BuiltinRegistries.f_123862_, (ResourceLocation)dungeon4_identifier, (Object)dungeon4_feature.m_67065_((FeatureConfiguration)NoneFeatureConfiguration.f_67816_));
    private static final ResourceLocation dungeon5_identifier = new ResourceLocation("dungeonsmod", "the_lab");
    public static final StructurePieceType dungeon5_piece = (StructurePieceType)Registry.m_122965_((Registry)Registry.f_122843_, (ResourceLocation)new ResourceLocation("dungeonsmod:dungeon5_piece"), Dungeon5Generator.Piece::new);
    public static final StructureFeature<NoneFeatureConfiguration> dungeon5_feature = new Dungeon5(dungeon5_identifier, (Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_);
    public static final ConfiguredStructureFeature<NoneFeatureConfiguration, ? extends StructureFeature<NoneFeatureConfiguration>> dungeon5_configured_feature = (ConfiguredStructureFeature)BuiltinRegistries.m_123880_((Registry)BuiltinRegistries.f_123862_, (ResourceLocation)dungeon5_identifier, (Object)dungeon5_feature.m_67065_((FeatureConfiguration)NoneFeatureConfiguration.f_67816_));
    private static final ResourceLocation dungeon6_identifier = new ResourceLocation("dungeonsmod", "the_catacombs");
    public static final StructurePieceType dungeon6_piece = (StructurePieceType)Registry.m_122965_((Registry)Registry.f_122843_, (ResourceLocation)new ResourceLocation("dungeonsmod:dungeon6_piece"), Dungeon6Generator.Piece::new);
    public static final StructureFeature<NoneFeatureConfiguration> dungeon6_feature = new Dungeon6(dungeon6_identifier, (Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_);
    public static final ConfiguredStructureFeature<NoneFeatureConfiguration, ? extends StructureFeature<NoneFeatureConfiguration>> dungeon6_configured_feature = (ConfiguredStructureFeature)BuiltinRegistries.m_123880_((Registry)BuiltinRegistries.f_123862_, (ResourceLocation)dungeon6_identifier, (Object)dungeon6_feature.m_67065_((FeatureConfiguration)NoneFeatureConfiguration.f_67816_));
    private static final ResourceLocation dungeon7_identifier = new ResourceLocation("dungeonsmod", "the_origin");
    public static final StructurePieceType dungeon7_piece = (StructurePieceType)Registry.m_122965_((Registry)Registry.f_122843_, (ResourceLocation)new ResourceLocation("dungeonsmod:dungeon7_piece"), Dungeon7Generator.Piece::new);
    public static final StructureFeature<NoneFeatureConfiguration> dungeon7_feature = new Dungeon7(dungeon7_identifier, (Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_);
    public static final ConfiguredStructureFeature<NoneFeatureConfiguration, ? extends StructureFeature<NoneFeatureConfiguration>> dungeon7_configured_feature = (ConfiguredStructureFeature)BuiltinRegistries.m_123880_((Registry)BuiltinRegistries.f_123862_, (ResourceLocation)dungeon7_identifier, (Object)dungeon7_feature.m_67065_((FeatureConfiguration)NoneFeatureConfiguration.f_67816_));
    public static final ResourceLocation dungeonside31_identifier = new ResourceLocation("dungeonsmod", "the_sewers");
    public static final StructurePoolElementType<DungeonSide31Generator> dungeonside31_piece = (StructurePoolElementType)Registry.m_122965_((Registry)Registry.f_122892_, (ResourceLocation)new ResourceLocation("dungeonsmod:dungeonside31_piece"), () -> DungeonSide31Generator.CODEC);
    public static final StructureFeature<SewerConfig> dungeonside31_feature = new DungeonSide31(dungeonside31_identifier, SewerConfig.CODEC);
    public static final ConfiguredStructureFeature<SewerConfig, ? extends StructureFeature<SewerConfig>> dungeonside31_configured_feature = (ConfiguredStructureFeature)BuiltinRegistries.m_123880_((Registry)BuiltinRegistries.f_123862_, (ResourceLocation)dungeonside31_identifier, (Object)dungeonside31_feature.m_67065_((FeatureConfiguration)new SewerConfig(() -> DungeonSide31Pools.BASE_POOL, 9)));

    public static List<StructureFeature<?>> getAllStructures() {
        return Arrays.asList(dungeonside1_feature, dungeonside21_feature, dungeonside22_feature, dungeonside31_feature, dungeon0_feature, dungeon1_feature, dungeon2_feature, dungeon3_feature, dungeon4_feature, dungeon5_feature, dungeon6_feature, dungeon7_feature);
    }

    @SubscribeEvent
    public static void onStructureRegistry(RegistryEvent.Register<StructureFeature<?>> e) {
        for (StructureFeature<?> structure : StructureRegistries.getAllStructures()) {
            e.getRegistry().register(structure);
            StructureFeature.f_67012_.put((Object)structure.getRegistryName().toString().toLowerCase(), structure);
        }
    }

    public static void setupStructures() {
        ConcurrentHashMap customStructures = new ConcurrentHashMap();
        for (StructureFeature<?> structure : StructureRegistries.getAllStructures()) {
            customStructures.put(structure, ((IDungeon)structure).getConfig());
            ((NoiseGeneratorSettings)BuiltinRegistries.f_123866_.m_123013_(((IDungeon)structure).getDimensionSettings())).m_64457_().m_64590_().put(structure, ((IDungeon)structure).getConfig());
        }
        StructureSettings.f_64580_ = ImmutableMap.builder().putAll((Map)StructureSettings.f_64580_).putAll(customStructures).build();
    }

    public static void patchStructuresIfGone(WorldEvent.Load event) {
        if (!event.getWorld().m_5776_()) {
            ServerLevel serverLevel = (ServerLevel)event.getWorld();
            HashMap tempMap = new HashMap(serverLevel.m_7726_().f_8328_.m_62205_().m_64590_());
            for (StructureFeature<?> structure : StructureRegistries.getAllStructures()) {
                tempMap.putIfAbsent(structure, (StructureFeatureConfiguration)StructureSettings.f_64580_.get(structure));
            }
            serverLevel.m_7726_().f_8328_.m_62205_().f_64582_ = tempMap;
        }
    }

    public static void registerOnBiomes(BiomeLoadingEvent e) {
        boolean blackFlag = false;
        for (Biome biome : DungeonsModConfig.COMMON.blackStructures.get()) {
            if (!biome.getRegistryName().equals((Object)e.getName())) continue;
            blackFlag = true;
        }
        if (!blackFlag) {
            if (e.getCategory() == Biome.BiomeCategory.SWAMP) {
                e.getGeneration().m_47849_(dungeonside1_configured_feature);
            }
            if (e.getCategory() == Biome.BiomeCategory.ICY || e.getCategory() == Biome.BiomeCategory.TAIGA) {
                e.getGeneration().m_47849_(dungeonside21_configured_feature);
                e.getGeneration().m_47849_(dungeonside22_configured_feature);
            }
            if (e.getCategory() == Biome.BiomeCategory.BEACH) {
                e.getGeneration().m_47849_(dungeonside31_configured_feature);
            }
            if (e.getCategory() == Biome.BiomeCategory.PLAINS) {
                e.getGeneration().m_47849_(dungeon0_configured_feature);
            }
            if (e.getCategory() == Biome.BiomeCategory.DESERT) {
                e.getGeneration().m_47849_(dungeon1_configured_feature);
            }
            if (e.getCategory() == Biome.BiomeCategory.PLAINS) {
                e.getGeneration().m_47849_(dungeon2_configured_feature);
            }
            if (e.getCategory() == Biome.BiomeCategory.OCEAN) {
                e.getGeneration().m_47849_(dungeon3_configured_feature);
            }
            if (e.getCategory() == Biome.BiomeCategory.EXTREME_HILLS) {
                e.getGeneration().m_47849_(dungeon4_configured_feature);
            }
            if (e.getCategory() == Biome.BiomeCategory.JUNGLE) {
                e.getGeneration().m_47849_(dungeon5_configured_feature);
            }
            if (e.getCategory() == Biome.BiomeCategory.NETHER) {
                e.getGeneration().m_47849_(dungeon6_configured_feature);
            }
            if (e.getCategory() == Biome.BiomeCategory.THEEND && e.getName().equals((Object)Biomes.f_48164_.m_135782_())) {
                e.getGeneration().m_47849_(dungeon7_configured_feature);
            }
        }
    }
}

