/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.handlers;

import com.dainxt.dungeonsmod.config.DungeonsModConfig;
import com.dainxt.dungeonsmod.handlers.BlocksHandler;
import com.dainxt.dungeonsmod.handlers.ItemRegistries;
import com.dainxt.dungeonsmod.handlers.StructureRegistries;
import com.dainxt.dungeonsmod.interfaces.IDungeon;
import com.dainxt.dungeonsmod.util.WrittenBooks;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class VillagerRegistries {
    public static PoiType TRAVELER_PoI = new PoiType("traveler", VillagerRegistries.getJobSites(), 1, 1);
    public static VillagerProfession TRAVELER_Prof = new VillagerProfession("traveler", TRAVELER_PoI, ImmutableSet.of(), ImmutableSet.of(), null);

    private static Set<BlockState> getJobSites() {
        HashSet<BlockState> JOB_SITES = new HashSet<BlockState>();
        JOB_SITES.addAll(PoiType.m_27372_((Block)BlocksHandler.HAYCOAL_BLOCK));
        return JOB_SITES;
    }

    @SubscribeEvent
    public static void onPoIRegistry(RegistryEvent.Register<PoiType> e) {
        e.getRegistry().register((IForgeRegistryEntry)((PoiType)TRAVELER_PoI.setRegistryName("traveler")));
    }

    @SubscribeEvent
    public static void onProfessionRegistry(RegistryEvent.Register<VillagerProfession> e) {
        e.getRegistry().register((IForgeRegistryEntry)((VillagerProfession)TRAVELER_Prof.setRegistryName("traveler")));
        VillagerTrades.f_35627_.put(TRAVELER_Prof, VillagerRegistries.gatAsIntMap((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new EmeraldForMapTrade(DungeonsModConfig.COMMON.dungeon1, StructureRegistries.dungeon1_feature, MapDecoration.Type.TARGET_X, 12, 5), new ItemsForEmeraldsTrade(ItemRegistries.BACK_PERGAMINE, 2, 1, 32)}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new EmeraldForMapTrade(DungeonsModConfig.COMMON.dungeon2, StructureRegistries.dungeon2_feature, MapDecoration.Type.TARGET_X, 12, 5)}, (Object)3, (Object)new VillagerTrades.ItemListing[]{new EmeraldForMapTrade(DungeonsModConfig.COMMON.dungeon3, StructureRegistries.dungeon3_feature, MapDecoration.Type.TARGET_X, 12, 5)}, (Object)4, (Object)new VillagerTrades.ItemListing[]{new EmeraldForMapTrade(DungeonsModConfig.COMMON.dungeon4, StructureRegistries.dungeon4_feature, MapDecoration.Type.TARGET_X, 12, 5)}, (Object)5, (Object)new VillagerTrades.ItemListing[]{new EmeraldForMapTrade(DungeonsModConfig.COMMON.dungeon5, StructureRegistries.dungeon5_feature, MapDecoration.Type.TARGET_X, 12, 5), new SunTrade(Item.m_41439_((Block)Blocks.f_50112_), 1, 1, 32)})));
    }

    private static Int2ObjectMap<VillagerTrades.ItemListing[]> gatAsIntMap(ImmutableMap<Integer, VillagerTrades.ItemListing[]> of) {
        return new Int2ObjectOpenHashMap(of);
    }

    static class EmeraldForMapTrade
    implements VillagerTrades.ItemListing {
        private final DungeonsModConfig.Server.StructureConfiguration configuration;
        private final StructureFeature<?> structureName;
        private final MapDecoration.Type mapDecorationType;
        private final int maxUses;
        private final int xpValue;

        public EmeraldForMapTrade(DungeonsModConfig.Server.StructureConfiguration configuration, StructureFeature<?> structureName, MapDecoration.Type mapDecorationType, int maxUses, int xpValue) {
            this.configuration = configuration;
            this.structureName = structureName;
            this.mapDecorationType = mapDecorationType;
            this.maxUses = maxUses;
            this.xpValue = xpValue;
        }

        @Nullable
        public MerchantOffer m_5670_(Entity trader, Random rand) {
            if (!(trader.f_19853_ instanceof ServerLevel)) {
                return null;
            }
            if ((Integer)this.configuration.chance.get() >= 1) {
                int count = (Integer)this.configuration.price.get();
                ServerLevel ServerLevel2 = (ServerLevel)trader.f_19853_;
                BlockPos blockpos = ServerLevel2.m_8717_(this.structureName, trader.m_142538_(), 100, true);
                if (blockpos != null) {
                    if (this.structureName instanceof IDungeon) {
                        ItemStack stack = ((IDungeon)this.structureName).getWrittenBook();
                        ItemEntity itemEntity = new ItemEntity(trader.f_19853_, trader.m_20185_(), trader.m_20186_() + (double)1.4f, trader.m_20189_(), stack);
                        itemEntity.m_32060_();
                        trader.f_19853_.m_7967_((Entity)itemEntity);
                    }
                    ItemStack itemstack = MapItem.m_42886_((Level)ServerLevel2, (int)blockpos.m_123341_(), (int)blockpos.m_123343_(), (byte)2, (boolean)true, (boolean)true);
                    MapItem.m_42850_((ServerLevel)ServerLevel2, (ItemStack)itemstack);
                    MapItemSavedData.m_77925_((ItemStack)itemstack, (BlockPos)blockpos, (String)"+", (MapDecoration.Type)this.mapDecorationType);
                    itemstack.m_41714_((Component)new TranslatableComponent("filled_map." + this.structureName.m_67098_().toLowerCase(Locale.ROOT)));
                    return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, count), new ItemStack((ItemLike)Items.f_42676_), itemstack, this.maxUses, this.xpValue, 0.2f);
                }
                return null;
            }
            return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, ((Integer)this.configuration.price.get()).intValue()), new ItemStack((ItemLike)Items.f_42413_), this.maxUses, this.xpValue, 0.2f);
        }
    }

    static class ItemsForEmeraldsTrade
    implements VillagerTrades.ItemListing {
        private final ItemStack sellingItem;
        private final int emeraldCount;
        private final int sellingItemCount;
        private final int maxUses;
        private final int xpValue;
        private final float priceMultiplier;

        public ItemsForEmeraldsTrade(Block sellingItem, int emeraldCount, int sellingItemCount, int maxUses, int xpValue) {
            this(new ItemStack((ItemLike)sellingItem), emeraldCount, sellingItemCount, maxUses, xpValue);
        }

        public ItemsForEmeraldsTrade(Item sellingItem, int emeraldCount, int sellingItemCount, int xpValue) {
            this(new ItemStack((ItemLike)sellingItem), emeraldCount, sellingItemCount, 12, xpValue);
        }

        public ItemsForEmeraldsTrade(Item sellingItem, int emeraldCount, int sellingItemCount, int maxUses, int xpValue) {
            this(new ItemStack((ItemLike)sellingItem), emeraldCount, sellingItemCount, maxUses, xpValue);
        }

        public ItemsForEmeraldsTrade(ItemStack sellingItem, int emeraldCount, int sellingItemCount, int maxUses, int xpValue) {
            this(sellingItem, emeraldCount, sellingItemCount, maxUses, xpValue, 0.05f);
        }

        public ItemsForEmeraldsTrade(ItemStack sellingItem, int emeraldCount, int sellingItemCount, int maxUses, int xpValue, float priceMultiplier) {
            this.sellingItem = sellingItem;
            this.emeraldCount = emeraldCount;
            this.sellingItemCount = sellingItemCount;
            this.maxUses = maxUses;
            this.xpValue = xpValue;
            this.priceMultiplier = priceMultiplier;
        }

        public MerchantOffer m_5670_(Entity trader, Random rand) {
            return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, this.emeraldCount), new ItemStack((ItemLike)this.sellingItem.m_41720_(), this.sellingItemCount), this.maxUses, this.xpValue, this.priceMultiplier);
        }
    }

    static class SunTrade
    implements VillagerTrades.ItemListing {
        private final ItemStack sellingItem;
        private final int emeraldCount;
        private final int sellingItemCount;
        private final int maxUses;
        private final int xpValue;
        private final float priceMultiplier;

        public SunTrade(Block sellingItem, int emeraldCount, int sellingItemCount, int maxUses, int xpValue) {
            this(new ItemStack((ItemLike)sellingItem), emeraldCount, sellingItemCount, maxUses, xpValue);
        }

        public SunTrade(Item sellingItem, int emeraldCount, int sellingItemCount, int xpValue) {
            this(new ItemStack((ItemLike)sellingItem), emeraldCount, sellingItemCount, 12, xpValue);
        }

        public SunTrade(Item sellingItem, int emeraldCount, int sellingItemCount, int maxUses, int xpValue) {
            this(new ItemStack((ItemLike)sellingItem), emeraldCount, sellingItemCount, maxUses, xpValue);
        }

        public SunTrade(ItemStack sellingItem, int emeraldCount, int sellingItemCount, int maxUses, int xpValue) {
            this(sellingItem, emeraldCount, sellingItemCount, maxUses, xpValue, 0.05f);
        }

        public SunTrade(ItemStack sellingItem, int emeraldCount, int sellingItemCount, int maxUses, int xpValue, float priceMultiplier) {
            this.sellingItem = sellingItem;
            this.emeraldCount = emeraldCount;
            this.sellingItemCount = sellingItemCount;
            this.maxUses = maxUses;
            this.xpValue = xpValue;
            this.priceMultiplier = priceMultiplier;
        }

        public MerchantOffer m_5670_(Entity trader, Random rand) {
            ItemStack stack = WrittenBooks.getTranslatableBook("6");
            ItemEntity itemEntity = new ItemEntity(trader.f_19853_, trader.m_20185_(), trader.m_20186_() + (double)1.4f, trader.m_20189_(), stack);
            itemEntity.m_32060_();
            trader.f_19853_.m_7967_((Entity)itemEntity);
            return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, this.emeraldCount), new ItemStack((ItemLike)this.sellingItem.m_41720_(), this.sellingItemCount), this.maxUses, this.xpValue, this.priceMultiplier);
        }
    }
}

