/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.items;

import com.dainxt.dungeonsmod.config.DungeonsModConfig;
import com.dainxt.dungeonsmod.items.ItemArmorMaterials;
import com.dainxt.dungeonsmod.sclasses.SItemGroup;
import com.dainxt.dungeonsmod.util.EntityUtils;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;

public class CrawlerArmorItem
extends ArmorItem {
    public CrawlerArmorItem(ArmorMaterial materialIn, EquipmentSlot slot, Item.Properties builderIn) {
        super(materialIn, slot, builderIn);
    }

    public CrawlerArmorItem(String name, EquipmentSlot slot) {
        super((ArmorMaterial)ItemArmorMaterials.CRAWLER, slot, new Item.Properties().m_41491_((CreativeModeTab)SItemGroup.MISC).m_41497_(Rarity.RARE));
        this.setRegistryName(name);
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        super.onArmorTick(stack, world, player);
        boolean haveAllPieces = EntityUtils.entityHaveAllArmor((LivingEntity)player, ItemArmorMaterials.CRAWLER);
        if (haveAllPieces) {
            boolean canApplyRegeneration;
            long redstoneStacks = player.m_150109_().f_35974_.stream().filter(redstoneStack -> {
                if (redstoneStack.m_41720_().equals(Items.f_42153_)) {
                    return redstoneStack.m_41613_() >= redstoneStack.m_41741_();
                }
                return false;
            }).count();
            int regenerationLevel = Mth.m_14045_((int)(Mth.m_14167_((float)(redstoneStacks / 3L)) - 1), (int)-1, (int)2);
            boolean bl = canApplyRegeneration = !player.m_21221_().containsKey(MobEffects.f_19605_);
            if (player.m_21221_().containsKey(MobEffects.f_19605_)) {
                boolean bl2 = canApplyRegeneration = ((MobEffectInstance)player.m_21221_().get(MobEffects.f_19605_)).m_19564_() < regenerationLevel;
            }
            if (regenerationLevel >= 0 && player instanceof LivingEntity && canApplyRegeneration) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 200, regenerationLevel));
            }
        }
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
        int amount = (Integer)((List)DungeonsModConfig.COMMON.crawlerArmor.get()).get(this.f_40377_.m_20749_());
        int defaultAmount = ItemArmorMaterials.CRAWLER.m_7365_(this.f_40377_);
        if (defaultAmount != amount) {
            Multimap defaultModifiers = stack.m_41638_(this.f_40377_);
            if (!stack.m_41782_() || !stack.m_41783_().m_128425_("AttributeModifiers", 9)) {
                defaultModifiers.forEach((attribute, defaultModifier) -> {
                    if (attribute.equals(Attributes.f_22284_)) {
                        AttributeModifier config = new AttributeModifier(defaultModifier.m_22209_(), defaultModifier.m_22214_(), (double)amount, defaultModifier.m_22217_());
                        stack.m_41643_(attribute, config, this.f_40377_);
                    } else {
                        stack.m_41643_(attribute, defaultModifier, this.f_40377_);
                    }
                });
            }
        }
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        int amount;
        int defaultAmount;
        Multimap defaultModifiers = super.m_7167_(equipmentSlot);
        HashMultimap modifiedAttributes = HashMultimap.create();
        if (this.f_40377_ == equipmentSlot && (defaultAmount = ItemArmorMaterials.CRAWLER.m_7365_(this.f_40377_)) != (amount = ((Integer)((List)DungeonsModConfig.COMMON.crawlerArmor.get()).get(this.f_40377_.m_20749_())).intValue())) {
            defaultModifiers.forEach((arg_0, arg_1) -> CrawlerArmorItem.lambda$getDefaultAttributeModifiers$2(amount, (Multimap)modifiedAttributes, arg_0, arg_1));
        }
        return modifiedAttributes.isEmpty() ? defaultModifiers : modifiedAttributes;
    }

    public int getMaxDamage(ItemStack stack) {
        int factor = (Integer)DungeonsModConfig.COMMON.crawlerDurabilityFactor.get();
        if (ItemArmorMaterials.CRAWLER.getDefaultMaxDamageFactor() == factor) {
            return super.m_41462_();
        }
        return ItemArmorMaterials.MAX_DAMAGE_ARRAY[this.f_40377_.m_20749_()] * factor;
    }

    private static /* synthetic */ void lambda$getDefaultAttributeModifiers$2(int amount, Multimap modifiedAttributes, Attribute attribute, AttributeModifier defaultModifier) {
        if (attribute.equals(Attributes.f_22284_)) {
            AttributeModifier config = new AttributeModifier(defaultModifier.m_22209_(), defaultModifier.m_22214_(), (double)amount, defaultModifier.m_22217_());
            modifiedAttributes.put((Object)attribute, (Object)config);
        } else {
            modifiedAttributes.put((Object)attribute, (Object)defaultModifier);
        }
    }
}

