/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.items;

import com.dainxt.dungeonsmod.items.ItemBase;
import com.dainxt.dungeonsmod.util.EntityUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.OreBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemOreDetector
extends ItemBase {
    public Iterator<Block> ores;
    public Block selectedOre = Blocks.f_49997_;

    public ItemOreDetector(String name) {
        super(name, new Item.Properties().m_41487_(1).m_41497_(Rarity.RARE));
    }

    public ArrayList<Block> getOres() {
        return ForgeRegistries.BLOCKS.getValues().stream().filter(block -> block instanceof OreBlock).collect(Collectors.toCollection(ArrayList::new));
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
        if ((itemSlot == 0 || isSelected) && entityIn instanceof Player && !worldIn.f_46443_ && entityIn.f_19797_ % 40 == 0) {
            CompoundTag tag = stack.m_41783_();
            if (tag == null) {
                tag = new CompoundTag();
            }
            tag.m_128405_("selectedBlock", Block.m_49956_((BlockState)this.selectedOre.m_49966_()));
            stack.m_41751_(tag);
            double nearestDistance = EntityUtils.scanBlocksInAABB((Entity)((LivingEntity)entityIn), entityIn.m_142469_().m_82400_(10.0), (pos, state, distance) -> {
                if (distance == null) {
                    distance = 3.0 * Math.pow(10.0, 2.0);
                } else if (state.m_60734_().equals(this.selectedOre)) {
                    distance = Math.min(distance, ((LivingEntity)entityIn).m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()));
                }
                return distance;
            });
            worldIn.m_5594_(null, entityIn.m_142538_(), SoundEvents.f_12210_, SoundSource.PLAYERS, 1.0f, (float)(1.0 - nearestDistance / 300.0));
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (!worldIn.f_46443_) {
            if (this.ores == null || !this.ores.hasNext()) {
                this.ores = this.getOres().listIterator();
            } else if (this.ores.hasNext()) {
                this.selectedOre = this.ores.next();
            }
            worldIn.m_5594_(null, playerIn.m_142538_(), SoundEvents.f_12444_, SoundSource.PLAYERS, 1.0f, 0.5f);
            if (this.selectedOre != null) {
                playerIn.m_5661_((Component)new TranslatableComponent(this.selectedOre.m_7705_()), true);
            }
        }
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            tooltip.add((Component)new TranslatableComponent("item.dungeonsmod.ore_detector.tooltip_1", new Object[]{Block.m_49803_((int)tag.m_128451_("selectedBlock")).m_60734_().m_49954_().getString()}));
        }
    }
}

