/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.items;

import com.dainxt.dungeonsmod.config.DungeonsModConfig;
import com.dainxt.dungeonsmod.items.ItemBase;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class ItemSunOverdrive
extends ItemBase {
    public ItemSunOverdrive(String name) {
        super(name, new Item.Properties().m_41487_(1).m_41486_());
    }

    private int getMaxCooldown() {
        return (Integer)DungeonsModConfig.COMMON.cooldownSunOverdrive.get();
    }

    private int getMaxUseTime() {
        return (Integer)DungeonsModConfig.COMMON.usageSunOverdrive.get();
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
        if (!worldIn.f_46443_) {
            int cooldown;
            CompoundTag tag = stack.m_41783_();
            if (tag == null) {
                tag = new CompoundTag();
            }
            if ((cooldown = tag.m_128451_("cooldown")) > 0) {
                long prevTime = tag.m_128454_("prevTime");
                long time = worldIn.m_46468_();
                if (prevTime > 0L && time - prevTime <= 12000L) {
                    ((ServerLevel)worldIn).m_8615_(time + 60L);
                } else if (time - prevTime >= 12000L) {
                    tag.m_128356_("prevTime", 0L);
                }
                tag.m_128405_("cooldown", --cooldown);
            }
            stack.m_41751_(tag);
        }
    }

    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity entityIn, int timeLeft) {
        super.m_5551_(stack, worldIn, entityIn, timeLeft);
        if (!worldIn.f_46443_ && entityIn.m_21211_() == stack) {
            Player entityplayer = (Player)entityIn;
            entityplayer.m_36335_().m_41524_(stack.m_41720_(), 0);
        }
    }

    public ItemStack m_5922_(ItemStack stack, Level worldIn, LivingEntity entityLiving) {
        CompoundTag tag;
        Player entityplayer;
        Player player = entityplayer = entityLiving instanceof Player ? (Player)entityLiving : null;
        if (!worldIn.f_46443_ && (tag = stack.m_41783_()) != null) {
            ServerLevel world = (ServerLevel)worldIn;
            long time = worldIn.m_46468_();
            tag.m_128405_("cooldown", this.getMaxCooldown());
            tag.m_128356_("prevTime", time);
            stack.m_41751_(tag);
            worldIn.m_5594_(null, entityplayer.m_142538_(), SoundEvents.f_12288_, SoundSource.AMBIENT, 10.0f, 1.0f);
        }
        return super.m_5922_(stack, worldIn, entityLiving);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            return tag.m_128451_("cooldown") > 0;
        }
        return super.showDurabilityBar(stack);
    }

    public boolean m_5812_(ItemStack stack) {
        return super.m_5812_(stack);
    }

    public int m_8105_(ItemStack stack) {
        return this.getMaxUseTime();
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            return (double)tag.m_128451_("cooldown") / (double)this.getMaxCooldown();
        }
        return super.getDurabilityForDisplay(stack);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player user, InteractionHand handIn) {
        if (!worldIn.f_46443_) {
            ServerPlayer playerIn = (ServerPlayer)user;
            ItemStack stack = playerIn.m_21120_(handIn);
            CompoundTag tag = stack.m_41783_();
            if (DungeonsModConfig.COMMON.enableSunOverdrive.isEnabled()) {
                if (tag != null) {
                    ServerLevel worldServer = playerIn.m_20193_().m_142572_().m_129880_(playerIn.m_8963_());
                    if ((float)tag.m_128451_("cooldown") == 0.0f) {
                        playerIn.m_6672_(handIn);
                        playerIn.m_36335_().m_41524_(playerIn.m_21205_().m_41720_(), this.getMaxUseTime());
                        return InteractionResultHolder.m_19090_((Object)playerIn.m_21120_(handIn));
                    }
                    stack.m_41751_(tag);
                }
            } else if (playerIn instanceof Player) {
                playerIn.m_5661_((Component)new TranslatableComponent("item.dungeonsmod.sun_overdrive.denied"), true);
            }
        }
        return InteractionResultHolder.m_19098_((Object)user.m_21120_(handIn));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        CompoundTag tagCompound = stack.m_41783_();
        if (tagCompound != null) {
            DecimalFormat df = new DecimalFormat();
            df.setMaximumFractionDigits(3);
            int cooldown = tagCompound.m_128451_("cooldown");
            float minutesExact = cooldown / 1200;
            int minutes = (int)minutesExact;
            float secondsExact = cooldown / 20;
            int seconds = (int)(secondsExact - (float)(minutes * 60));
            tooltip.add((Component)new TranslatableComponent("item.dungeonsmod.cooldown", new Object[]{minutes, seconds}));
        }
    }
}

