/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.items;

import com.dainxt.dungeonsmod.config.DungeonsModConfig;
import com.dainxt.dungeonsmod.entity.dungeons.dungeon4.EntityGuard;
import com.dainxt.dungeonsmod.handlers.EntityRegistries;
import com.dainxt.dungeonsmod.items.ItemArmorMaterials;
import com.dainxt.dungeonsmod.sclasses.SItemGroup;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class KingsCrownItem
extends ArmorItem {
    public KingsCrownItem(ArmorMaterial materialIn, EquipmentSlot slot, Item.Properties builderIn) {
        super(materialIn, slot, builderIn);
    }

    public KingsCrownItem(String name, EquipmentSlot slot) {
        super((ArmorMaterial)ItemArmorMaterials.KINGCROWN, slot, new Item.Properties().m_41491_((CreativeModeTab)SItemGroup.MISC).m_41497_(Rarity.RARE));
        this.setRegistryName(name);
    }

    private int getMaxCooldown() {
        return 200;
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        super.onArmorTick(stack, world, player);
        if (!world.f_46443_) {
            CompoundTag tag = stack.m_41783_();
            if (tag == null) {
                tag = new CompoundTag();
            }
            ServerLevel worldserver = (ServerLevel)world;
            this.updateGuard("Guard1", worldserver, player, stack);
            this.updateGuard("Guard2", worldserver, player, stack);
        }
    }

    public void updateGuard(String name, ServerLevel worldserver, Player player, ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        UUID guard1UUID = tag.m_128441_(name + "UUID") ? tag.m_128342_(name + "UUID") : null;
        int cooldown = tag.m_128451_("cooldown" + name);
        if (cooldown > 0) {
            if (guard1UUID == null || worldserver.m_8791_(guard1UUID) == null) {
                tag.m_128405_("cooldown" + name, --cooldown);
            }
        } else if (guard1UUID == null) {
            guard1UUID = this.summonGuard(worldserver, player);
            if (guard1UUID != null) {
                tag.m_128405_("cooldown" + name, this.getMaxCooldown());
                tag.m_128362_(name + "UUID", guard1UUID);
            }
        } else if (worldserver.m_8791_(guard1UUID) == null) {
            tag.m_128473_(name + "UUID");
        }
        stack.m_41751_(tag);
    }

    public UUID summonGuard(ServerLevel world, Player player) {
        BlockPos pos = player.m_142538_();
        EntityGuard guard = new EntityGuard(EntityRegistries.GUARD, (Level)world);
        guard.m_7678_((float)pos.m_123341_() + 0.5f, pos.m_123342_(), (float)pos.m_123343_() + 0.5f, world.m_5822_().nextFloat() * 360.0f, 0.0f);
        guard.m_6518_((ServerLevelAccessor)world, world.m_6436_(pos), MobSpawnType.MOB_SUMMONED, (SpawnGroupData)new EntityGuard.GroupData(false, true), null);
        world.m_7967_((Entity)guard);
        guard.m_21828_(player);
        return guard.m_142081_();
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
        int amount = (Integer)((List)DungeonsModConfig.COMMON.kingscrownArmor.get()).get(this.f_40377_.m_20749_());
        int defaultAmount = ItemArmorMaterials.KINGCROWN.m_7365_(this.f_40377_);
        if (defaultAmount != amount) {
            Multimap defaultModifiers = stack.m_41638_(this.f_40377_);
            if (!stack.m_41782_() || !stack.m_41783_().m_128425_("AttributeModifiers", 9)) {
                defaultModifiers.forEach((attribute, defaultModifier) -> {
                    if (attribute.equals(Attributes.f_22284_)) {
                        AttributeModifier config = new AttributeModifier(defaultModifier.m_22209_(), defaultModifier.m_22214_(), (double)amount, defaultModifier.m_22217_());
                        stack.m_41643_(attribute, config, this.f_40377_);
                    } else {
                        stack.m_41643_(attribute, defaultModifier, this.f_40377_);
                    }
                });
            }
        }
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        int amount;
        int defaultAmount;
        Multimap defaultModifiers = super.m_7167_(equipmentSlot);
        HashMultimap modifiedAttributes = HashMultimap.create();
        if (this.f_40377_ == equipmentSlot && (defaultAmount = ItemArmorMaterials.KINGCROWN.m_7365_(this.f_40377_)) != (amount = ((Integer)((List)DungeonsModConfig.COMMON.kingscrownArmor.get()).get(this.f_40377_.m_20749_())).intValue())) {
            defaultModifiers.forEach((arg_0, arg_1) -> KingsCrownItem.lambda$getDefaultAttributeModifiers$1(amount, (Multimap)modifiedAttributes, arg_0, arg_1));
        }
        return modifiedAttributes.isEmpty() ? defaultModifiers : modifiedAttributes;
    }

    public int getMaxDamage(ItemStack stack) {
        int factor = (Integer)DungeonsModConfig.COMMON.kingscrownDurabilityFactor.get();
        if (ItemArmorMaterials.KINGCROWN.getDefaultMaxDamageFactor() == factor) {
            return super.m_41462_();
        }
        return ItemArmorMaterials.MAX_DAMAGE_ARRAY[this.f_40377_.m_20749_()] * factor;
    }

    private static /* synthetic */ void lambda$getDefaultAttributeModifiers$1(int amount, Multimap modifiedAttributes, Attribute attribute, AttributeModifier defaultModifier) {
        if (attribute.equals(Attributes.f_22284_)) {
            AttributeModifier config = new AttributeModifier(defaultModifier.m_22209_(), defaultModifier.m_22214_(), (double)amount, defaultModifier.m_22217_());
            modifiedAttributes.put((Object)attribute, (Object)config);
        } else {
            modifiedAttributes.put((Object)attribute, (Object)defaultModifier);
        }
    }
}

