/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.sclasses;

import com.dainxt.dungeonsmod.entity.EntityExtraPart;
import com.dainxt.dungeonsmod.interfaces.IEntityExtraPart;
import java.util.ArrayList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;

public abstract class EntityMultiPart
extends Monster
implements IEntityExtraPart {
    public ArrayList<EntityExtraPart> extraParts = new ArrayList();

    public EntityMultiPart(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag) {
        this.initExtraParts(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.spawnExtraParts(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void spawnExtraParts(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag) {
        for (EntityExtraPart extraPart : this.extraParts) {
            extraPart.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
            extraPart.m_6518_(worldIn, difficultyIn, reason, new EntityExtraPart.GroupData(this.getExtraPartType()), dataTag);
            worldIn.m_7967_((Entity)extraPart);
        }
    }

    public Vec3 getPositionFromVector(Vec3 origin, float yawOffset, float pitchOffset, double distanceOrigin) {
        float yaw = this.f_19859_ + yawOffset;
        float pitch = this.f_19860_ + pitchOffset;
        float yawSin = Mth.m_14031_((float)((float)((double)yaw * (Math.PI / 180))));
        float yawCos = Mth.m_14089_((float)((float)((double)yaw * (Math.PI / 180))));
        float pitchSin = Mth.m_14031_((float)((float)((double)pitch * (Math.PI / 180))));
        float pitchCos = Mth.m_14089_((float)((float)((double)pitch * (Math.PI / 180))));
        double tentaclePosX = origin.f_82479_ - (double)yawSin * (distanceOrigin * (double)Mth.m_14154_((float)pitchCos));
        double tentaclePosZ = origin.f_82481_ + (double)yawCos * (distanceOrigin * (double)Mth.m_14154_((float)pitchCos));
        double tentaclePosY = origin.f_82480_ - (double)pitchSin * distanceOrigin;
        return new Vec3(tentaclePosX, tentaclePosY, tentaclePosZ);
    }

    public void setPartBoundingPosition(EntityExtraPart tentacle, float yawOffset, float pitchOffset, double distanceOrigin) {
        Vec3 origin = this.m_20182_();
        origin = origin.m_82520_(0.0, (this.m_142469_().f_82292_ - this.m_142469_().f_82289_) / 2.0, 0.0);
        this.setPartBoundingPosition(tentacle, origin, yawOffset, pitchOffset, distanceOrigin);
    }

    public void setPartBoundingPosition(EntityExtraPart tentacle, Vec3 origin, float yawOffset, float pitchOffset, double distanceOrigin) {
        if (tentacle != null && tentacle.m_6084_()) {
            Vec3 finalPos = this.getPositionFromVector(origin, yawOffset, pitchOffset, distanceOrigin);
            Vec3 finalTentaclePos = new Vec3(finalPos.f_82479_, finalPos.f_82480_ - (double)(tentacle.m_20206_() / 2.0f), finalPos.f_82481_);
            tentacle.m_19890_(finalTentaclePos.f_82479_, finalTentaclePos.f_82480_, finalTentaclePos.f_82481_, tentacle.m_146908_(), tentacle.m_146909_());
            tentacle.m_20256_(Vec3.f_82478_);
        }
    }

    public void m_8107_() {
        super.m_8107_();
        this.updateExtraParts();
    }

    @Override
    public ArrayList<EntityExtraPart> getCustomParts() {
        return this.extraParts;
    }

    public void m_6667_(DamageSource cause) {
        this.getCustomParts().forEach(extraPart -> extraPart.m_21153_(0.0f));
        super.m_6667_(cause);
    }

    protected abstract EntityExtraPart.ExtraPartType getExtraPartType();

    protected abstract void initExtraParts(ServerLevelAccessor var1, DifficultyInstance var2, MobSpawnType var3, SpawnGroupData var4, CompoundTag var5);

    protected abstract void updateExtraParts();
}

