/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.util;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityUtils {
    public static boolean entityHaveAllArmor(LivingEntity player, ArmorMaterial material) {
        return StreamSupport.stream(player.m_6168_().spliterator(), false).collect(Collectors.toList()).stream().allMatch(piece -> {
            if (piece.m_41720_() instanceof ArmorItem) {
                return ((ArmorItem)piece.m_41720_()).m_40401_().equals(material);
            }
            return false;
        });
    }

    public static void destroyBlocksInAABB(LivingEntity user, Block ... blockList) {
        EntityUtils.destroyBlocksInAABB(user, 0.0, blockList);
    }

    public static void destroyBlocksInAABB(LivingEntity entity, double inflateValue, Block ... blockList) {
        EntityUtils.scanBlocksInAABB(entity, entity.m_142469_().m_82400_(inflateValue), (BlockPos blockPos, BlockState blockState) -> {
            boolean destroyAll = false;
            if (blockList == null) {
                destroyAll = true;
            }
            if (destroyAll) {
                entity.f_19853_.m_46597_(blockPos, Blocks.f_50016_.m_49966_());
            } else {
                for (Block blockInList : blockList) {
                    if (blockState.m_60734_() != blockInList || blockState.m_60734_().equals(Blocks.f_50752_)) continue;
                    entity.f_19853_.m_46597_(blockPos, Blocks.f_50016_.m_49966_());
                }
            }
            return false;
        });
    }

    public static boolean scanBlocksInAABB(LivingEntity user, BiFunction<BlockPos, BlockState, Boolean> blockChecker) {
        return EntityUtils.scanBlocksInAABB(user, user.m_142469_(), blockChecker);
    }

    public static boolean scanBlocksInAABB(LivingEntity user, AABB p_70972_1_, BiFunction<BlockPos, BlockState, Boolean> blockChecker) {
        Level world = user.m_20193_();
        int i = Mth.m_14107_((double)p_70972_1_.f_82288_);
        int j = Mth.m_14107_((double)p_70972_1_.f_82289_);
        int k = Mth.m_14107_((double)p_70972_1_.f_82290_);
        int l = Mth.m_14107_((double)p_70972_1_.f_82291_);
        int i1 = Mth.m_14107_((double)p_70972_1_.f_82292_);
        int j1 = Mth.m_14107_((double)p_70972_1_.f_82293_);
        boolean destroyed = false;
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = j; l1 <= i1; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    BlockPos blockpos = new BlockPos(k1, l1, i2);
                    BlockState blockState = world.m_8055_(blockpos);
                    Block block = blockState.m_60734_();
                    if (!ForgeEventFactory.getMobGriefingEvent((Level)world, (Entity)user) || !block.canEntityDestroy(blockState, (BlockGetter)world, blockpos, (Entity)user) || !ForgeEventFactory.onEntityDestroyBlock((LivingEntity)user, (BlockPos)blockpos, (BlockState)blockState)) continue;
                    destroyed = blockChecker.apply(blockpos, blockState) != false || destroyed;
                }
            }
        }
        return destroyed;
    }

    public static <T> T scanBlocksInAABB(Entity user, AABB p_70972_1_, TriFunction<BlockPos, BlockState, T, T> blockChecker) {
        Level world = user.m_20193_();
        int i = Mth.m_14107_((double)p_70972_1_.f_82288_);
        int j = Mth.m_14107_((double)p_70972_1_.f_82289_);
        int k = Mth.m_14107_((double)p_70972_1_.f_82290_);
        int l = Mth.m_14107_((double)p_70972_1_.f_82291_);
        int i1 = Mth.m_14107_((double)p_70972_1_.f_82292_);
        int j1 = Mth.m_14107_((double)p_70972_1_.f_82293_);
        Object returnValue = null;
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = j; l1 <= i1; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    BlockPos blockpos = new BlockPos(k1, l1, i2);
                    BlockState blockState = world.m_8055_(blockpos);
                    returnValue = blockChecker.apply(blockpos, blockState, returnValue);
                }
            }
        }
        return (T)returnValue;
    }

    @FunctionalInterface
    public static interface TriFunction<A, B, C, R> {
        public R apply(A var1, B var2, C var3);

        default public <V> TriFunction<A, B, C, V> andThen(Function<? super R, ? extends V> after) {
            Objects.requireNonNull(after);
            return (a, b, c) -> after.apply((R)this.apply(a, b, c));
        }
    }
}

