/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.world.gen.generators;

import com.dainxt.dungeonsmod.entity.boss.EntityKraken;
import com.dainxt.dungeonsmod.handlers.EntityRegistries;
import com.dainxt.dungeonsmod.handlers.StructureRegistries;
import com.dainxt.dungeonsmod.world.gen.generators.PieceBase;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;

public class Dungeon3Generator {

    public static class Piece
    extends PieceBase {
        public Piece(StructureManager structureManager, ResourceLocation identifier, BlockPos blockPos, Rotation rotation) {
            super(structureManager, identifier, blockPos, rotation, StructureRegistries.dungeon3_piece, 0);
            this.f_73657_.m_74394_().m_74383_(Piece.getCustomIgnoreProcessor()).m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74046_);
        }

        public Piece(ServerLevel structureManager, CompoundTag compoundTag) {
            super(structureManager, compoundTag, StructureRegistries.dungeon3_piece);
            this.f_73657_.m_74394_().m_74383_(Piece.getCustomIgnoreProcessor()).m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74046_);
        }

        protected void m_7756_(String function, BlockPos pos, ServerLevelAccessor world, Random rand, BoundingBox sbb) {
            BlockEntity tileentity;
            BlockPos blockpos2;
            if ("dispenser".equals(function)) {
                blockpos2 = pos;
                world.m_7731_(blockpos2, Blocks.f_50016_.m_49966_(), 3);
                tileentity = world.m_7702_(blockpos2.m_6625_(2));
                if (tileentity instanceof DispenserBlockEntity) {
                    ((DispenserBlockEntity)tileentity).m_59626_(BuiltInLootTables.f_78687_, world.m_5822_().nextLong());
                }
            }
            if ("chest".equals(function)) {
                blockpos2 = pos;
                world.m_7731_(blockpos2, Blocks.f_50016_.m_49966_(), 3);
                tileentity = world.m_7702_(blockpos2.m_6625_(1));
                if (tileentity instanceof ChestBlockEntity) {
                    RandomizableContainerBlockEntity.m_59620_((BlockGetter)world, (Random)rand, (BlockPos)tileentity.m_58899_(), (ResourceLocation)BuiltInLootTables.f_78695_);
                }
            }
            if ("head".equals(function)) {
                BlockPos initialPos = pos;
                EntityKraken kraken = new EntityKraken(EntityRegistries.KRAKEN, (Level)world.m_6018_());
                kraken.m_7678_(initialPos.m_123341_(), (float)initialPos.m_123342_() + 20.0f, initialPos.m_123343_(), 0.0f, 0.0f);
                kraken.m_6518_(world, world.m_6436_(initialPos), MobSpawnType.STRUCTURE, null, null);
                world.m_7967_((Entity)kraken);
            }
        }

        @Override
        protected int getYOffset() {
            return -21;
        }

        @Override
        protected Heightmap.Types getHeightMapType() {
            return Heightmap.Types.OCEAN_FLOOR_WG;
        }

        public static StructureProcessor getCustomIgnoreProcessor() {
            return new BlockIgnoreProcessor((List)ImmutableList.of((Object)Blocks.f_50016_));
        }
    }
}

