/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.world.gen.generators;

import com.dainxt.dungeonsmod.config.DungeonsModConfig;
import com.dainxt.dungeonsmod.entity.boss.EntityCrawler;
import com.dainxt.dungeonsmod.entity.dungeons.dungeon5.EntityScientist;
import com.dainxt.dungeonsmod.entity.dungeons.dungeon5.EntitySlimewolf;
import com.dainxt.dungeonsmod.handlers.EntityRegistries;
import com.dainxt.dungeonsmod.handlers.StructureRegistries;
import com.dainxt.dungeonsmod.util.WrittenBooks;
import com.dainxt.dungeonsmod.world.gen.generators.PieceBase;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedstoneLampBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraftforge.registries.ForgeRegistries;

public class Dungeon5Generator {
    public static ItemStack getRandomPotion(Level world) {
        ItemStack stack = ItemStack.f_41583_;
        if (world.m_5822_().nextInt(3) == 0) {
            int index = world.m_5822_().nextInt(ForgeRegistries.POTIONS.getValues().size());
            for (Potion potionType : ForgeRegistries.POTIONS.getValues()) {
                stack = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)potionType);
                if (--index > 0) continue;
                break;
            }
        }
        return stack;
    }

    public static class Piece
    extends PieceBase {
        public Piece(StructureManager structureManager, ResourceLocation identifier, BlockPos blockPos, Rotation rotation) {
            super(structureManager, identifier, blockPos, rotation, StructureRegistries.dungeon5_piece, 0);
        }

        public Piece(ServerLevel structureManager, CompoundTag compoundTag) {
            super(structureManager, compoundTag, StructureRegistries.dungeon5_piece);
        }

        protected void m_7756_(String function, BlockPos pos, ServerLevelAccessor world, Random rand, BoundingBox sbb) {
            Monster crawler;
            BlockPos initialPos;
            BlockEntity tileentity;
            BlockPos blockpos2;
            if ("furnace".equals(function)) {
                blockpos2 = pos;
                world.m_7731_(blockpos2, Blocks.f_50016_.m_49966_(), 3);
                tileentity = world.m_7702_(blockpos2.m_7495_());
                if (tileentity instanceof FurnaceBlockEntity) {
                    ItemStack stack = new ItemStack((ItemLike)Items.f_42413_);
                    stack.m_41764_(world.m_5822_().nextInt(31) + 1);
                    ((FurnaceBlockEntity)tileentity).m_6836_(1, stack);
                }
            }
            if ("frame_pickaxe".equals(function)) {
                BlockPos blockpos1 = pos;
                world.m_7731_(blockpos1, Blocks.f_50080_.m_49966_(), 3);
                BlockPos blockpos22 = blockpos1.m_6625_(1);
                for (ItemStack facing : Direction.values()) {
                    BlockPos blockpos3 = blockpos22.m_142300_(facing.m_122424_());
                    BlockState iblockstate = world.m_8055_(blockpos3);
                    Block block = iblockstate.m_60734_();
                    if (block.equals(Blocks.f_50058_) || block.equals(Blocks.f_50080_) || !facing.m_122434_().m_122479_() || !iblockstate.m_60783_((BlockGetter)world, blockpos3, (Direction)facing)) continue;
                    ItemFrame itemframeentity = new ItemFrame((Level)world.m_6018_(), blockpos22, (Direction)facing);
                    itemframeentity.m_31789_(WrittenBooks.getTranslatableBook("7"), false);
                    world.m_7967_((Entity)itemframeentity);
                    break;
                }
            }
            if ("spawn_scientist".equals(function)) {
                world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                if (world.m_5822_().nextFloat() < (float)DungeonsModConfig.COMMON.scientist.getWeight() / 100.0f) {
                    initialPos = pos;
                    crawler = new EntityScientist(EntityRegistries.SCIENTIST, (Level)world.m_6018_());
                    crawler.m_7678_((double)((float)initialPos.m_123341_() + 0.5f), (double)initialPos.m_123342_(), (double)((float)initialPos.m_123343_() + 0.5f), world.m_5822_().nextFloat() * 360.0f, 0.0f);
                    world.m_7967_((Entity)crawler);
                }
            }
            if ("spawn_slimewolf".equals(function)) {
                world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                initialPos = pos;
                if (world.m_5822_().nextFloat() < (float)DungeonsModConfig.COMMON.slimewolf.getWeight() / 100.0f) {
                    crawler = new EntitySlimewolf(EntityRegistries.SLIMEWOLF, (Level)world.m_6018_());
                    crawler.m_7678_((double)((float)initialPos.m_123341_() + 0.5f), (double)initialPos.m_123342_(), (double)((float)initialPos.m_123343_() + 0.5f), world.m_5822_().nextFloat() * 360.0f, 0.0f);
                    world.m_7967_((Entity)crawler);
                }
            }
            if ("brew".equals(function)) {
                blockpos2 = pos;
                world.m_7731_(blockpos2, Blocks.f_50016_.m_49966_(), 3);
                tileentity = world.m_7702_(blockpos2.m_7495_());
                if (tileentity instanceof BrewingStandBlockEntity) {
                    ((BrewingStandBlockEntity)tileentity).m_6836_(0, Dungeon5Generator.getRandomPotion((Level)world.m_6018_()));
                    ((BrewingStandBlockEntity)tileentity).m_6836_(1, Dungeon5Generator.getRandomPotion((Level)world.m_6018_()));
                    ((BrewingStandBlockEntity)tileentity).m_6836_(2, Dungeon5Generator.getRandomPotion((Level)world.m_6018_()));
                }
            }
            if ("lamp".equals(function)) {
                blockpos2 = pos;
                world.m_7731_(blockpos2, Blocks.f_50330_.m_49966_(), 3);
                world.m_7731_(blockpos2.m_7495_(), (BlockState)Blocks.f_50261_.m_49966_().m_61124_((Property)RedstoneLampBlock.f_55654_, (Comparable)Boolean.valueOf(true)), 3);
            }
            if ("shulker".equals(function)) {
                blockpos2 = pos;
                world.m_7731_(blockpos2, Blocks.f_50016_.m_49966_(), 3);
                tileentity = world.m_7702_(blockpos2.m_7495_());
                if (tileentity instanceof ShulkerBoxBlockEntity) {
                    ((ShulkerBoxBlockEntity)tileentity).m_59626_(BuiltInLootTables.f_78692_, world.m_5822_().nextLong());
                }
                if ((tileentity = world.m_7702_(blockpos2.m_7494_())) instanceof ShulkerBoxBlockEntity) {
                    ((ShulkerBoxBlockEntity)tileentity).m_59626_(BuiltInLootTables.f_78692_, world.m_5822_().nextLong());
                }
            }
            if ("dispenser".equals(function)) {
                blockpos2 = pos;
                world.m_7731_(blockpos2, Blocks.f_50333_.m_49966_(), 3);
                tileentity = world.m_7702_(blockpos2.m_7495_());
                if (tileentity instanceof DispenserBlockEntity) {
                    ((DispenserBlockEntity)tileentity).m_59626_(BuiltInLootTables.f_78692_, world.m_5822_().nextLong());
                }
                if ((tileentity = world.m_7702_(blockpos2.m_6625_(2))) instanceof DispenserBlockEntity) {
                    ((DispenserBlockEntity)tileentity).m_59626_(BuiltInLootTables.f_78692_, world.m_5822_().nextLong());
                }
            }
            if ("heart".equals(function)) {
                blockpos2 = pos;
                world.m_7731_(blockpos2, Blocks.f_50330_.m_49966_(), 3);
            }
            if ("crawler".equals(function)) {
                world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                initialPos = pos;
                crawler = new EntityCrawler(EntityRegistries.CRAWLER, (Level)world.m_6018_());
                crawler.m_7678_((double)initialPos.m_123341_(), (double)initialPos.m_123342_(), (double)initialPos.m_123343_(), 0.0f, 0.0f);
                StructurePlaceSettings withoutBoundsSettings = this.f_73657_.m_74374_();
                for (StructureTemplate.StructureBlockInfo template$blockinfo : this.f_73656_.m_74603_(this.f_73658_, withoutBoundsSettings.m_74381_(null), Blocks.f_50677_)) {
                    StructureMode structuremode;
                    if (template$blockinfo.f_74677_ == null || (structuremode = StructureMode.valueOf((String)template$blockinfo.f_74677_.m_128461_("mode"))) != StructureMode.DATA) continue;
                    String metadata = template$blockinfo.f_74677_.m_128461_("metadata");
                    BlockPos heartPos = template$blockinfo.f_74675_;
                    if (!"heart".equals(metadata)) continue;
                    crawler.HEART_PLACES.add(heartPos);
                }
                world.m_7967_((Entity)crawler);
            }
        }

        @Override
        protected int getYOffset() {
            return -25;
        }
    }
}

