/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.world.gen.generators;

import com.dainxt.dungeonsmod.handlers.ItemRegistries;
import com.dainxt.dungeonsmod.handlers.StructureRegistries;
import com.dainxt.dungeonsmod.util.WrittenBooks;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.structures.SinglePoolElement;
import net.minecraft.world.level.levelgen.feature.structures.StructurePoolElementType;
import net.minecraft.world.level.levelgen.feature.structures.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.RandomBlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class DungeonSide31Generator
extends SinglePoolElement {
    public static final Codec<DungeonSide31Generator> CODEC = RecordCodecBuilder.create(p_236841_0_ -> p_236841_0_.group((App)DungeonSide31Generator.m_69149_(), (App)DungeonSide31Generator.m_69146_(), (App)DungeonSide31Generator.m_69229_()).apply((Applicative)p_236841_0_, DungeonSide31Generator::new));

    protected DungeonSide31Generator(Either<ResourceLocation, StructureTemplate> p_69102_, Supplier<StructureProcessorList> p_69103_, StructureTemplatePool.Projection p_69104_) {
        super(p_69102_, p_69103_, p_69104_);
    }

    protected StructurePlaceSettings m_8122_(Rotation p_230379_1_, BoundingBox p_230379_2_, boolean p_230379_3_) {
        StructurePlaceSettings placeSettings = super.m_8122_(p_230379_1_, p_230379_2_, p_230379_3_);
        placeSettings.m_74383_((StructureProcessor)new RuleProcessor((List)ImmutableList.of((Object)new ProcessorRule((RuleTest)new RandomBlockMatchTest(Blocks.f_50752_, 0.7f), (RuleTest)AlwaysTrueTest.f_73954_, Blocks.f_50652_.m_49966_()))));
        placeSettings.m_74383_((StructureProcessor)new RuleProcessor((List)ImmutableList.of((Object)new ProcessorRule((RuleTest)new RandomBlockMatchTest(Blocks.f_50652_, 0.9f), (RuleTest)AlwaysTrueTest.f_73954_, Blocks.f_50079_.m_49966_()))));
        placeSettings.m_74383_(this.getCustomIgnoreProcessor());
        return placeSettings;
    }

    public boolean m_6791_(StructureManager p_230378_1_, WorldGenLevel p_230378_2_, StructureFeatureManager p_230378_3_, ChunkGenerator p_230378_4_, BlockPos p_230378_5_, BlockPos p_230378_6_, Rotation p_230378_7_, BoundingBox p_230378_8_, Random p_230378_9_, boolean p_230378_10_) {
        StructurePlaceSettings placementsettings;
        StructureTemplate template = (StructureTemplate)this.f_69098_.map(arg_0 -> ((StructureManager)p_230378_1_).m_74341_(arg_0), Function.identity());
        if (!template.m_74536_((ServerLevelAccessor)p_230378_2_, p_230378_5_, p_230378_6_, placementsettings = this.m_8122_(p_230378_7_, p_230378_8_, p_230378_10_), p_230378_9_, 18)) {
            return false;
        }
        for (StructureTemplate.StructureBlockInfo template$blockinfo : DungeonSide31Generator.processBlockInfos((LevelAccessor)p_230378_2_, p_230378_5_, p_230378_6_, placementsettings, this.m_69141_(p_230378_1_, p_230378_5_, p_230378_7_, false), template)) {
            this.m_69157_((LevelAccessor)p_230378_2_, template$blockinfo, p_230378_5_, p_230378_7_, p_230378_9_, p_230378_8_);
        }
        return true;
    }

    public static List<StructureTemplate.StructureBlockInfo> processBlockInfos(LevelAccessor p_237145_0_, BlockPos p_237145_1_, BlockPos p_237145_2_, StructurePlaceSettings p_237145_3_, List<StructureTemplate.StructureBlockInfo> p_237145_4_, @Nullable StructureTemplate template) {
        ArrayList list = Lists.newArrayList();
        for (StructureTemplate.StructureBlockInfo template$blockinfo : p_237145_4_) {
            BlockPos blockpos = StructureTemplate.m_74563_((StructurePlaceSettings)p_237145_3_, (BlockPos)template$blockinfo.f_74675_).m_141952_((Vec3i)p_237145_1_);
            StructureTemplate.StructureBlockInfo template$blockinfo1 = new StructureTemplate.StructureBlockInfo(blockpos, template$blockinfo.f_74676_, template$blockinfo.f_74677_ != null ? template$blockinfo.f_74677_.m_6426_() : null);
            if (template$blockinfo1 == null) continue;
            list.add(template$blockinfo1);
        }
        return list;
    }

    public void m_69157_(LevelAccessor world, StructureTemplate.StructureBlockInfo p_214846_2_, BlockPos piecePos, Rotation rotationIn, Random rand, BoundingBox p_214846_6_) {
        String structureMode;
        super.m_69157_(world, p_214846_2_, piecePos, rotationIn, rand, p_214846_6_);
        if (p_214846_2_.f_74677_ != null && (structureMode = p_214846_2_.f_74677_.m_128461_("mode")).toLowerCase().contains("data")) {
            BlockEntity tileentity;
            BlockPos blockpos2;
            String function = p_214846_2_.f_74677_.m_128461_("metadata");
            BlockPos pos = p_214846_2_.f_74675_;
            if ("spawner_bat".equals(function)) {
                blockpos2 = pos;
                if (world.m_5822_().nextInt(5) == 0) {
                    world.m_7731_(blockpos2, Blocks.f_50085_.m_49966_(), 2);
                    tileentity = world.m_7702_(blockpos2);
                    if (tileentity instanceof SpawnerBlockEntity) {
                        ((SpawnerBlockEntity)tileentity).m_59801_().m_45462_(EntityType.f_20549_);
                    }
                } else {
                    world.m_7731_(blockpos2, Blocks.f_50016_.m_49966_(), 3);
                }
            }
            if ("shulker".equals(function)) {
                blockpos2 = pos;
                world.m_7731_(blockpos2, Blocks.f_50016_.m_49966_(), 3);
                tileentity = world.m_7702_(blockpos2.m_7495_());
                if (tileentity instanceof ShulkerBoxBlockEntity) {
                    ((ShulkerBoxBlockEntity)tileentity).m_6836_(0, new ItemStack((ItemLike)ItemRegistries.UNSTABLE_MAP));
                    ((ShulkerBoxBlockEntity)tileentity).m_6836_(13, WrittenBooks.getTranslatableBook("8"));
                }
                if ((tileentity = world.m_7702_(blockpos2.m_7494_())) instanceof ShulkerBoxBlockEntity) {
                    ((ShulkerBoxBlockEntity)tileentity).m_6836_(0, new ItemStack((ItemLike)ItemRegistries.UNSTABLE_MAP));
                    ((ShulkerBoxBlockEntity)tileentity).m_6836_(13, WrittenBooks.getTranslatableBook("8"));
                }
            }
        }
    }

    protected StructureProcessor getCustomIgnoreProcessor() {
        return new BlockIgnoreProcessor((List)ImmutableList.of((Object)Blocks.f_49992_));
    }

    public StructurePoolElementType<?> m_6379_() {
        return StructureRegistries.dungeonside31_piece;
    }

    public String toString() {
        return "DungeonSide31Generator[" + this.f_69098_ + "]";
    }

    public static Function<StructureTemplatePool.Projection, DungeonSide31Generator> createCustom(String p_242849_0_) {
        return p_242860_1_ -> new DungeonSide31Generator((Either<ResourceLocation, StructureTemplate>)Either.left((Object)new ResourceLocation(p_242849_0_)), () -> ProcessorLists.f_127198_, (StructureTemplatePool.Projection)p_242860_1_);
    }
}

