/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.world.gen.generators;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public abstract class PieceBase
extends TemplateStructurePiece {
    public PieceBase(StructureManager p_71244_, ResourceLocation identifier, BlockPos blockPos, Rotation rotation, StructurePieceType structurePieceType, int unused) {
        super(structurePieceType, 0, p_71244_, identifier, identifier.toString(), PieceBase.makeSettings(blockPos, rotation, identifier), blockPos);
        this.f_73383_ = p_71244_.m_74341_(identifier).m_74633_(this.f_73657_, this.f_73658_);
    }

    public PieceBase(ServerLevel p_162441_, CompoundTag p_162442_, StructurePieceType structurePieceType) {
        super(structurePieceType, p_162442_, p_162441_, p_162451_ -> PieceBase.makeSettings(new BlockPos(p_162442_.m_128451_("TPX"), p_162442_.m_128451_("TPY"), p_162442_.m_128451_("TPZ")), Rotation.valueOf((String)p_162442_.m_128461_("Rot")), p_162451_));
    }

    protected void m_142347_(ServerLevel p_163673_, CompoundTag compoundTag_1) {
        super.m_142347_(p_163673_, compoundTag_1);
        compoundTag_1.m_128359_("Rot", this.f_73657_.m_74404_().name());
    }

    private static StructurePlaceSettings makeSettings(BlockPos position, Rotation p_162447_, ResourceLocation p_162448_) {
        return new StructurePlaceSettings().m_74392_(true).m_74379_(p_162447_).m_74377_(Mirror.NONE).m_74385_(position).m_74383_(PieceBase.getCustomIgnoreProcessor()).m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74046_);
    }

    public BlockPos preCheckPlacement(WorldGenLevel iWorld, StructureFeatureManager structureAccessor, ChunkGenerator chunkGenerator, Random random, BoundingBox boundingBox, ChunkPos chunkPos, BlockPos blockPos) {
        if (this.f_73658_.m_123342_() == 1) {
            int yMin = Integer.MAX_VALUE;
            int deltaMin = Integer.MAX_VALUE;
            this.f_73657_.m_74381_(null);
            this.f_73383_ = this.f_73656_.m_74633_(this.f_73657_, this.f_73658_);
            for (StructureTemplate.StructureBlockInfo template$blockinfo : this.f_73656_.m_74603_(this.f_73658_, this.f_73657_, Blocks.f_50677_)) {
                String metadata;
                StructureMode structuremode;
                if (template$blockinfo.f_74677_ == null || (structuremode = StructureMode.valueOf((String)template$blockinfo.f_74677_.m_128461_("mode"))) != StructureMode.DATA || !(metadata = template$blockinfo.f_74677_.m_128461_("metadata")).equals("surface")) continue;
                this.f_73657_.m_74381_(boundingBox);
                int yHeight1 = iWorld.m_6924_(this.getHeightMapType(), template$blockinfo.f_74675_.m_123341_(), template$blockinfo.f_74675_.m_123343_());
                int yHeight = chunkGenerator.m_156174_(template$blockinfo.f_74675_.m_123341_(), template$blockinfo.f_74675_.m_123343_(), this.getHeightMapType(), (LevelHeightAccessor)iWorld);
                if (yHeight >= yMin || yHeight == 0) continue;
                yMin = yHeight;
                deltaMin = template$blockinfo.f_74675_.m_123342_();
            }
            int finalHeight = yMin - deltaMin;
            if (yMin > 256) {
                int yHeight = iWorld.m_6924_(this.getHeightMapType(), this.f_73658_.m_123341_() + 8, this.f_73658_.m_123343_() + 8);
                this.f_73658_ = this.f_73658_.m_142082_(0, yHeight + this.getYOffset(), 0);
            } else {
                this.f_73658_ = this.f_73658_.m_142082_(0, finalHeight - 1, 0);
            }
        }
        return this.f_73658_;
    }

    public boolean m_7832_(WorldGenLevel iWorld, StructureFeatureManager structureAccessor, ChunkGenerator chunkGenerator, Random random, BoundingBox boundingBox, ChunkPos chunkPos, BlockPos blockPos) {
        this.preCheckPlacement(iWorld, structureAccessor, chunkGenerator, random, boundingBox, chunkPos, blockPos);
        boolean flag = super.m_7832_(iWorld, structureAccessor, chunkGenerator, random, boundingBox, chunkPos, blockPos);
        return flag;
    }

    protected abstract int getYOffset();

    protected Heightmap.Types getHeightMapType() {
        return Heightmap.Types.OCEAN_FLOOR_WG;
    }

    protected static StructureProcessor getCustomIgnoreProcessor() {
        return new BlockIgnoreProcessor((List)ImmutableList.of((Object)Blocks.f_49992_));
    }
}

