/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.world.gen.structures;

import com.dainxt.dungeonsmod.config.DungeonsModConfig;
import com.dainxt.dungeonsmod.handlers.EntityRegistries;
import com.dainxt.dungeonsmod.interfaces.IDungeon;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;

abstract class DungeonBase
extends StructureFeature<NoneFeatureConfiguration>
implements IDungeon {
    private static final List<MobSpawnSettings.SpawnerData> field_202381_d = ImmutableList.of((Object)new MobSpawnSettings.SpawnerData(EntityRegistries.MIMIC, 1, 1, 1));

    public DungeonBase(ResourceLocation name, Codec<NoneFeatureConfiguration> codec) {
        super(codec);
        this.setRegistryName(name);
    }

    public List<MobSpawnSettings.SpawnerData> getDefaultSpawnList() {
        return field_202381_d;
    }

    protected boolean isFeatureChunk(ChunkGenerator p_230363_1_, BiomeSource p_230363_2_, long p_230363_3_, WorldgenRandom p_230363_5_, ChunkPos p_160459_, Biome p_230363_8_, ChunkPos p_230363_9_, NoneFeatureConfiguration p_230363_10_, LevelHeightAccessor p_160463_) {
        int chance;
        if (((Boolean)DungeonsModConfig.COMMON.centerOnBiomes.get()).booleanValue()) {
            for (Biome biome : p_230363_2_.m_7901_(p_160459_.f_45578_ * 16 + 9, p_230363_1_.m_6337_(), p_160459_.f_45579_ * 16 + 9, 16)) {
                if (biome.m_47536_().m_47808_((StructureFeature)this)) continue;
                return false;
            }
        }
        return (chance = this.getChance()) >= 1 ? p_230363_5_.nextInt(chance) == 0 : false;
    }

    public BlockPos m_67046_(LevelReader world, StructureFeatureManager manager, BlockPos p_236388_3_, int radius, boolean skipExistingChunks, long seed, StructureFeatureConfiguration separationSettings) {
        return this.getChance() >= 1 ? super.m_67046_(world, manager, p_236388_3_, radius, skipExistingChunks, seed, separationSettings) : null;
    }

    public StructureFeature.StructureStartFactory<NoneFeatureConfiguration> m_6258_() {
        return MyStructureStart::new;
    }

    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    @Override
    public ResourceKey<NoiseGeneratorSettings> getDimensionSettings() {
        return NoiseGeneratorSettings.f_64432_;
    }

    public static class MyStructureStart
    extends StructureStart<NoneFeatureConfiguration> {
        public MyStructureStart(StructureFeature<NoneFeatureConfiguration> p_163595_, ChunkPos p_163596_, int p_163597_, long p_163598_) {
            super(p_163595_, p_163596_, p_163597_, p_163598_);
        }

        public void generatePieces(RegistryAccess p_230364_1_, ChunkGenerator p_230364_2_, StructureManager manager, ChunkPos p_163618_, Biome biome, NoneFeatureConfiguration config, LevelHeightAccessor p_163621_) {
            int x = p_163618_.f_45578_ * 16;
            int z = p_163618_.f_45579_ * 16;
            BlockPos startingPos = new BlockPos(x, 1, z);
            Rotation rotation = Rotation.NONE;
            ((IDungeon)this.m_73610_()).addParts(manager, startingPos, rotation, this.f_73562_, (Random)this.f_73564_, config);
        }
    }
}

