/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.torohealth;

import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.torocraft.torohealth.ToroHealth;
import net.torocraft.torohealth.ToroHealthClient;
import net.torocraft.torohealth.bars.BarStates;
import net.torocraft.torohealth.bars.HealthBarRenderer;
import net.torocraft.torohealth.bars.ParticleRenderer;
import net.torocraft.torohealth.util.HoldingWeaponUpdater;

public class ClientEventHandler {
    private static Minecraft minecraft = Minecraft.m_91087_();

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(ClientEventHandler::playerTick);
        MinecraftForge.EVENT_BUS.addListener(ClientEventHandler::entityRender);
        MinecraftForge.EVENT_BUS.addListener(ClientEventHandler::renderParticles);
        MinecraftForge.EVENT_BUS.addListener(ClientEventHandler::hudRender);
    }

    private static void entityRender(RenderLivingEvent.Post<? extends LivingEntity, ? extends EntityModel<?>> event) {
        HealthBarRenderer.prepareRenderInWorld(event.getEntity());
    }

    private static void renderParticles(RenderWorldLastEvent event) {
        Camera camera = ClientEventHandler.minecraft.f_91063_.m_109153_();
        ParticleRenderer.renderParticles(event.getMatrixStack(), camera);
        HealthBarRenderer.renderInWorld(event.getMatrixStack(), camera);
    }

    private static void playerTick(TickEvent.PlayerTickEvent event) {
        if (!event.player.f_19853_.f_46443_) {
            return;
        }
        ToroHealthClient.HUD.setEntity(ToroHealthClient.RAYTRACE.getEntityInCrosshair(0.0f, ToroHealth.CONFIG.hud.distance));
        BarStates.tick();
        HoldingWeaponUpdater.update();
        ToroHealthClient.HUD.m_96624_();
    }

    private static void hudRender(RenderGameOverlayEvent.Post event) {
        if (event.getType().equals((Object)RenderGameOverlayEvent.ElementType.ALL)) {
            ToroHealthClient.HUD.draw(event.getMatrixStack(), ToroHealth.CONFIG);
        }
    }
}

