/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.config;

import java.io.File;
import java.nio.file.Path;
import javax.annotation.Nullable;
import mezz.jei.config.IFilterTextSource;
import mezz.jei.config.IWorldConfig;
import mezz.jei.config.KeyBindings;
import mezz.jei.config.ServerInfo;
import mezz.jei.config.WorldConfigValues;
import mezz.jei.config.forge.Configuration;
import mezz.jei.config.forge.Property;
import mezz.jei.events.BookmarkOverlayToggleEvent;
import mezz.jei.events.EditModeToggleEvent;
import mezz.jei.events.EventBusHelper;
import mezz.jei.events.OverlayToggleEvent;
import mezz.jei.network.Network;
import mezz.jei.network.packets.PacketRequestCheatPermission;
import mezz.jei.util.Translator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorldConfig
implements IWorldConfig,
IFilterTextSource {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String worldCategory = "world";
    private final WorldConfigValues defaultValues = new WorldConfigValues();
    private final WorldConfigValues values = new WorldConfigValues();
    @Nullable
    private Configuration worldConfig;

    @Nullable
    private static Configuration getConfiguration(File jeiConfigurationDir) {
        Path configPath = ServerInfo.getWorldPath(jeiConfigurationDir.toPath());
        if (configPath == null) {
            return null;
        }
        Path worldConfigPath = configPath.resolve("worldSettings.cfg");
        return new Configuration(worldConfigPath.toFile());
    }

    public WorldConfig(File jeiConfigurationDir) {
        this.worldConfig = WorldConfig.getConfiguration(jeiConfigurationDir);
    }

    @Override
    public String getFilterText() {
        return this.values.filterText;
    }

    @Override
    public boolean setFilterText(String filterText) {
        if (this.values.filterText.equals(filterText)) {
            return false;
        }
        this.values.filterText = filterText;
        return true;
    }

    @Override
    public void saveFilterText() {
        if (this.worldConfig != null) {
            Property property = this.worldConfig.get(worldCategory, "filterText", this.defaultValues.filterText);
            property.set(this.values.filterText);
            if (this.worldConfig.hasChanged()) {
                this.worldConfig.save();
            }
        }
    }

    @Override
    public boolean isOverlayEnabled() {
        return this.values.overlayEnabled || KeyBindings.toggleOverlay.getKey().m_84873_() == -1;
    }

    @Override
    public void toggleOverlayEnabled() {
        boolean bl = this.values.overlayEnabled = !this.values.overlayEnabled;
        if (this.worldConfig != null) {
            Property property = this.worldConfig.get(worldCategory, "overlayEnabled", this.defaultValues.overlayEnabled);
            property.set(this.values.overlayEnabled);
            if (this.worldConfig.hasChanged()) {
                this.worldConfig.save();
            }
        }
        EventBusHelper.post(new OverlayToggleEvent(this.values.overlayEnabled));
    }

    @Override
    public boolean isBookmarkOverlayEnabled() {
        return this.isOverlayEnabled() && this.values.bookmarkOverlayEnabled;
    }

    @Override
    public void toggleBookmarkEnabled() {
        this.setBookmarkEnabled(!this.values.bookmarkOverlayEnabled);
    }

    @Override
    public void setBookmarkEnabled(boolean value) {
        if (this.values.bookmarkOverlayEnabled != value) {
            this.values.bookmarkOverlayEnabled = value;
            if (this.worldConfig != null) {
                Property property = this.worldConfig.get(worldCategory, "bookmarkOverlayEnabled", this.defaultValues.bookmarkOverlayEnabled);
                property.set(this.values.bookmarkOverlayEnabled);
                if (this.worldConfig.hasChanged()) {
                    this.worldConfig.save();
                }
            }
            EventBusHelper.post(new BookmarkOverlayToggleEvent(this.values.bookmarkOverlayEnabled));
        }
    }

    @Override
    public boolean isCheatItemsEnabled() {
        return this.values.cheatItemsEnabled;
    }

    @Override
    public boolean isDeleteItemsInCheatModeActive() {
        return this.values.cheatItemsEnabled && ServerInfo.isJeiOnServer();
    }

    @Override
    public void toggleCheatItemsEnabled() {
        this.setCheatItemsEnabled(!this.values.cheatItemsEnabled);
    }

    @Override
    public void setCheatItemsEnabled(boolean value) {
        if (this.values.cheatItemsEnabled != value) {
            this.values.cheatItemsEnabled = value;
            if (this.worldConfig != null) {
                Property property = this.worldConfig.get(worldCategory, "cheatItemsEnabled", this.defaultValues.cheatItemsEnabled);
                property.set(this.values.cheatItemsEnabled);
                if (this.worldConfig.hasChanged()) {
                    this.worldConfig.save();
                }
            }
            if (this.values.cheatItemsEnabled && ServerInfo.isJeiOnServer()) {
                Network.sendPacketToServer(new PacketRequestCheatPermission());
            }
        }
    }

    @Override
    public boolean isEditModeEnabled() {
        return this.values.editModeEnabled;
    }

    @Override
    public void toggleEditModeEnabled() {
        boolean bl = this.values.editModeEnabled = !this.values.editModeEnabled;
        if (this.worldConfig != null) {
            Property property = this.worldConfig.get(worldCategory, "editModeEnabled", this.defaultValues.editModeEnabled);
            property.set(this.values.editModeEnabled);
            if (this.worldConfig.hasChanged()) {
                this.worldConfig.save();
                EventBusHelper.post(new EditModeToggleEvent(this.values.editModeEnabled));
            }
        }
    }

    public void onWorldSave() {
        try {
            this.saveFilterText();
        }
        catch (RuntimeException e) {
            LOGGER.error("Failed to save filter text.", (Throwable)e);
        }
    }

    public void syncWorldConfig(File jeiConfigurationDir) {
        this.worldConfig = WorldConfig.getConfiguration(jeiConfigurationDir);
        if (this.worldConfig == null) {
            return;
        }
        Property property = this.worldConfig.get(worldCategory, "overlayEnabled", this.defaultValues.overlayEnabled);
        property.setLanguageKey("config.jei.interface.overlayEnabled");
        property.setComment(Translator.translateToLocal("config.jei.interface.overlayEnabled.comment"));
        property.setShowInGui(false);
        this.values.overlayEnabled = property.getBoolean();
        property = this.worldConfig.get(worldCategory, "cheatItemsEnabled", this.defaultValues.cheatItemsEnabled);
        property.setLanguageKey("config.jei.mode.cheatItemsEnabled");
        property.setComment(Translator.translateToLocal("config.jei.mode.cheatItemsEnabled.comment"));
        this.values.cheatItemsEnabled = property.getBoolean();
        property = this.worldConfig.get(worldCategory, "editEnabled", this.defaultValues.editModeEnabled);
        property.setLanguageKey("config.jei.mode.editEnabled");
        property.setComment(Translator.translateToLocal("config.jei.mode.editEnabled.comment"));
        this.values.editModeEnabled = property.getBoolean();
        if (property.hasChanged()) {
            EventBusHelper.post(new EditModeToggleEvent(this.values.editModeEnabled));
        }
        property = this.worldConfig.get(worldCategory, "bookmarkOverlayEnabled", this.defaultValues.bookmarkOverlayEnabled);
        property.setLanguageKey("config.jei.interface.bookmarkOverlayEnabled");
        property.setComment(Translator.translateToLocal("config.jei.interface.bookmarkOverlayEnabled.comment"));
        property.setShowInGui(false);
        this.values.bookmarkOverlayEnabled = property.getBoolean();
        property = this.worldConfig.get(worldCategory, "filterText", this.defaultValues.filterText);
        property.setShowInGui(false);
        this.values.filterText = property.getString();
        boolean configChanged = this.worldConfig.hasChanged();
        if (configChanged) {
            this.worldConfig.save();
        }
    }
}

