/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.util.StringUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;

public final class TooltipRenderer {
    private TooltipRenderer() {
    }

    public static void drawHoveringText(PoseStack poseStack, List<? extends FormattedText> textLines, int x, int y) {
        Minecraft minecraft = Minecraft.m_91087_();
        Font font = minecraft.f_91062_;
        TooltipRenderer.drawHoveringText(poseStack, textLines, x, y, ItemStack.f_41583_, font);
    }

    public static <T> void drawHoveringText(PoseStack poseStack, List<? extends FormattedText> textLines, int x, int y, T ingredient, IIngredientRenderer<T> ingredientRenderer) {
        Minecraft minecraft = Minecraft.m_91087_();
        Font font = ingredientRenderer.getFontRenderer(minecraft, ingredient);
        ItemStack itemStack = ingredient instanceof ItemStack ? (ItemStack)ingredient : ItemStack.f_41583_;
        TooltipRenderer.drawHoveringText(poseStack, textLines, x, y, itemStack, font);
    }

    private static void drawHoveringText(PoseStack poseStack, List<? extends FormattedText> textLines, int x, int y, ItemStack itemStack, Font font) {
        Minecraft minecraft = Minecraft.m_91087_();
        Screen screen = minecraft.f_91080_;
        if (screen == null) {
            return;
        }
        textLines = StringUtil.splitLines(textLines, 150);
        screen.renderComponentTooltip(poseStack, textLines, x, y, font, itemStack);
    }
}

