/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.gui.PageNavigation;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.recipes.IRecipeGuiLogic;
import mezz.jei.gui.recipes.RecipeCategoryTab;
import mezz.jei.gui.recipes.RecipeGuiTab;
import mezz.jei.gui.recipes.RecipesGui;
import mezz.jei.input.IPaged;
import mezz.jei.input.mouse.IUserInputHandler;
import mezz.jei.input.mouse.handlers.CombinedUserInputHandler;
import mezz.jei.util.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;

public class RecipeGuiTabs
implements IPaged {
    private final IRecipeGuiLogic recipeGuiLogic;
    private final List<RecipeGuiTab> tabs = new ArrayList<RecipeGuiTab>();
    private final PageNavigation pageNavigation;
    private IUserInputHandler inputHandler;
    private Rect2i area = new Rect2i(0, 0, 0, 0);
    private int pageCount = 1;
    private int pageNumber = 0;
    private int categoriesPerPage = 1;

    public RecipeGuiTabs(IRecipeGuiLogic recipeGuiLogic) {
        this.recipeGuiLogic = recipeGuiLogic;
        this.pageNavigation = new PageNavigation(this, true);
        this.inputHandler = this.pageNavigation.createInputHandler();
    }

    public void initLayout(RecipesGui recipesGui) {
        ImmutableList<IRecipeCategory<?>> categories = this.recipeGuiLogic.getRecipeCategories();
        if (!categories.isEmpty()) {
            int totalWidth = 0;
            this.categoriesPerPage = 0;
            Rect2i recipeArea = recipesGui.getArea();
            for (int i = 0; i < categories.size() && totalWidth + 24 <= recipeArea.m_110090_() - 4; ++i) {
                totalWidth += 24;
                ++this.categoriesPerPage;
            }
            this.area = new Rect2i(recipeArea.m_110085_() + 2, recipeArea.m_110086_() - 24 + 3, totalWidth, 24);
            this.pageCount = MathUtil.divideCeil(categories.size(), this.categoriesPerPage);
            IRecipeCategory<?> currentCategory = this.recipeGuiLogic.getSelectedRecipeCategory();
            int categoryIndex = categories.indexOf(currentCategory);
            this.pageNumber = categoryIndex / this.categoriesPerPage;
            int navHeight = 20;
            Rect2i navigationArea = new Rect2i(this.area.m_110085_(), this.area.m_110086_() - (2 + navHeight), this.area.m_110090_(), navHeight);
            this.pageNavigation.updateBounds(navigationArea);
            this.updateLayout();
        }
    }

    private void updateLayout() {
        int index;
        this.tabs.clear();
        ArrayList<IUserInputHandler> inputHandlers = new ArrayList<IUserInputHandler>();
        ImmutableList<IRecipeCategory<?>> categories = this.recipeGuiLogic.getRecipeCategories();
        int tabX = this.area.m_110085_();
        int startIndex = this.pageNumber * this.categoriesPerPage;
        for (int i = 0; i < this.categoriesPerPage && (index = i + startIndex) < categories.size(); ++i) {
            IRecipeCategory category = (IRecipeCategory)categories.get(index);
            RecipeCategoryTab tab = new RecipeCategoryTab(this.recipeGuiLogic, category, tabX, this.area.m_110086_());
            this.tabs.add(tab);
            inputHandlers.add(tab);
            tabX += 24;
        }
        inputHandlers.add(this.pageNavigation.createInputHandler());
        this.inputHandler = new CombinedUserInputHandler(inputHandlers);
        this.pageNavigation.updatePageState();
    }

    public void draw(Minecraft minecraft, PoseStack poseStack, int mouseX, int mouseY) {
        IRecipeCategory<?> selectedCategory = this.recipeGuiLogic.getSelectedRecipeCategory();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RecipeGuiTab hovered = null;
        RenderSystem.m_69465_();
        for (RecipeGuiTab tab : this.tabs) {
            boolean selected = tab.isSelected(selectedCategory);
            tab.draw(selected, poseStack, mouseX, mouseY);
            if (!tab.isMouseOver(mouseX, mouseY)) continue;
            hovered = tab;
        }
        RenderSystem.m_69482_();
        this.pageNavigation.draw(minecraft, poseStack, mouseX, mouseY, minecraft.m_91296_());
        if (hovered != null) {
            List<Component> tooltip = hovered.getTooltip();
            TooltipRenderer.drawHoveringText(poseStack, tooltip, mouseX, mouseY);
        }
    }

    public IUserInputHandler getInputHandler() {
        return this.inputHandler;
    }

    @Override
    public boolean nextPage() {
        this.pageNumber = this.hasNext() ? ++this.pageNumber : 0;
        this.updateLayout();
        return true;
    }

    @Override
    public boolean hasNext() {
        return this.pageNumber + 1 < this.pageCount;
    }

    @Override
    public boolean previousPage() {
        this.pageNumber = this.hasPrevious() ? --this.pageNumber : this.pageCount - 1;
        this.updateLayout();
        return true;
    }

    @Override
    public boolean hasPrevious() {
        return this.pageNumber > 0;
    }

    @Override
    public int getPageCount() {
        return this.pageCount;
    }

    @Override
    public int getPageNumber() {
        return this.pageNumber;
    }
}

