/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.ingredients;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import mezz.jei.config.SearchMode;
import mezz.jei.events.EventBusHelper;
import mezz.jei.ingredients.IIngredientListElementInfo;
import mezz.jei.ingredients.PrefixedSearchable;
import mezz.jei.search.PrefixInfo;
import mezz.jei.search.suffixtree.GeneralizedSuffixTree;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.LogicalSide;

public class IngredientFilterBackgroundBuilder {
    private final Map<PrefixInfo, PrefixedSearchable<GeneralizedSuffixTree>> prefixedSearchTrees;
    private final NonNullList<IIngredientListElementInfo<?>> elementList;
    private final Consumer<TickEvent.ClientTickEvent> onTickHandler;

    public IngredientFilterBackgroundBuilder(Map<PrefixInfo, PrefixedSearchable<GeneralizedSuffixTree>> prefixedSearchTrees, NonNullList<IIngredientListElementInfo<?>> elementList) {
        this.prefixedSearchTrees = prefixedSearchTrees;
        this.elementList = elementList;
        this.onTickHandler = this::onClientTick;
    }

    public void start() {
        boolean finished = this.run(10000);
        if (!finished) {
            EventBusHelper.addListener(this, TickEvent.ClientTickEvent.class, this.onTickHandler);
        }
    }

    private void onClientTick(TickEvent.ClientTickEvent event) {
        boolean finished;
        if (event.side == LogicalSide.CLIENT && Minecraft.m_91087_().f_91074_ != null && !(finished = this.run(20))) {
            return;
        }
        EventBusHelper.removeListener(this, this.onTickHandler);
    }

    private boolean run(int timeoutMs) {
        long startTime = System.currentTimeMillis();
        ArrayList<PrefixedSearchable<GeneralizedSuffixTree>> activeTrees = new ArrayList<PrefixedSearchable<GeneralizedSuffixTree>>();
        int startIndex = Integer.MAX_VALUE;
        for (PrefixedSearchable<GeneralizedSuffixTree> prefixedTree : this.prefixedSearchTrees.values()) {
            SearchMode mode = prefixedTree.getMode();
            if (mode == SearchMode.DISABLED) continue;
            GeneralizedSuffixTree generalizedSuffixTree = prefixedTree.getSearchable();
            int nextFreeIndex = generalizedSuffixTree.getHighestIndex() + 1;
            startIndex = Math.min(nextFreeIndex, startIndex);
            if (nextFreeIndex >= this.elementList.size()) continue;
            activeTrees.add(prefixedTree);
        }
        if (activeTrees.isEmpty()) {
            return true;
        }
        for (int i = startIndex; i < this.elementList.size(); ++i) {
            IIngredientListElementInfo info = (IIngredientListElementInfo)this.elementList.get(i);
            for (PrefixedSearchable prefixedSearchable : activeTrees) {
                GeneralizedSuffixTree searchable = (GeneralizedSuffixTree)prefixedSearchable.getSearchable();
                int nextFreeIndex = searchable.getHighestIndex() + 1;
                if (nextFreeIndex < i) continue;
                Collection<String> strings = prefixedSearchable.getStrings(info);
                if (strings.isEmpty()) {
                    searchable.put("", i);
                    continue;
                }
                for (String string : strings) {
                    searchable.put(string, i);
                }
            }
            if (System.currentTimeMillis() - startTime < (long)timeoutMs) continue;
            return false;
        }
        return true;
    }
}

