/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.input;

import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;

public class TextHistory {
    private static final int MAX_HISTORY = 100;
    private final List<String> history = new LinkedList<String>();

    public boolean add(String currentText) {
        if (currentText.length() > 0) {
            this.history.remove(currentText);
            this.history.add(currentText);
            if (this.history.size() > 100) {
                this.history.remove(0);
            }
            return true;
        }
        return false;
    }

    @Nullable
    public String getPrevious(String currentText) {
        int historyIndex = this.history.indexOf(currentText);
        if (historyIndex < 0) {
            historyIndex = this.add(currentText) ? this.history.size() - 1 : this.history.size();
        }
        if (historyIndex <= 0) {
            return null;
        }
        return this.history.get(historyIndex - 1);
    }

    @Nullable
    public String getNext(String currentText) {
        int historyIndex = this.history.indexOf(currentText);
        if (historyIndex < 0) {
            return null;
        }
        String historyString = historyIndex + 1 < this.history.size() ? this.history.get(historyIndex + 1) : "";
        return historyString;
    }
}

