/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.input;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.Collection;
import javax.annotation.Nullable;
import mezz.jei.input.MouseUtil;
import mezz.jei.input.mouse.InputType;
import mezz.jei.util.MathUtil;
import net.minecraft.SharedConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.renderer.Rect2i;
import net.minecraftforge.client.event.GuiScreenEvent;

public class UserInput {
    private final InputConstants.Key key;
    private final double mouseX;
    private final double mouseY;
    private final int modifiers;
    private final InputType clickState;

    public static UserInput fromEvent(GuiScreenEvent.KeyboardKeyEvent keyEvent) {
        InputConstants.Key input = InputConstants.m_84827_((int)keyEvent.getKeyCode(), (int)keyEvent.getScanCode());
        double mouseX = MouseUtil.getX();
        double mouseY = MouseUtil.getY();
        int modifiers = keyEvent.getModifiers();
        return new UserInput(input, mouseX, mouseY, modifiers, InputType.IMMEDIATE);
    }

    @Nullable
    public static UserInput fromEvent(GuiScreenEvent.MouseClickedEvent event) {
        int button = event.getButton();
        if (button < 0) {
            return null;
        }
        InputConstants.Key input = InputConstants.Type.MOUSE.m_84895_(button);
        return new UserInput(input, event.getMouseX(), event.getMouseY(), 0, InputType.SIMULATE);
    }

    @Nullable
    public static UserInput fromEvent(GuiScreenEvent.MouseReleasedEvent event) {
        int button = event.getButton();
        if (button < 0) {
            return null;
        }
        InputConstants.Key input = InputConstants.Type.MOUSE.m_84895_(button);
        return new UserInput(input, event.getMouseX(), event.getMouseY(), 0, InputType.EXECUTE);
    }

    public static UserInput fromVanilla(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key input = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        return new UserInput(input, MouseUtil.getX(), MouseUtil.getY(), modifiers, InputType.IMMEDIATE);
    }

    @Nullable
    public static UserInput fromVanilla(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton < 0) {
            return null;
        }
        InputConstants.Key input = InputConstants.Type.MOUSE.m_84895_(mouseButton);
        return new UserInput(input, mouseX, mouseY, 0, InputType.IMMEDIATE);
    }

    public UserInput(InputConstants.Key key, double mouseX, double mouseY, int modifiers, InputType clickState) {
        this.key = key;
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.modifiers = modifiers;
        this.clickState = clickState;
    }

    public InputConstants.Key getKey() {
        return this.key;
    }

    public double getMouseX() {
        return this.mouseX;
    }

    public double getMouseY() {
        return this.mouseY;
    }

    public InputType getClickState() {
        return this.clickState;
    }

    public boolean isSimulate() {
        return this.clickState == InputType.SIMULATE;
    }

    public boolean isMouse() {
        return this.key.m_84868_() == InputConstants.Type.MOUSE;
    }

    public boolean isLeftClick() {
        return this.isMouse() && this.key.m_84873_() == 0;
    }

    public boolean isKeyboard() {
        return this.key.m_84868_() == InputConstants.Type.KEYSYM;
    }

    public boolean isAllowedChatCharacter() {
        return this.isKeyboard() && SharedConstants.m_136188_((char)((char)this.key.m_84873_()));
    }

    public boolean is(KeyMapping keyMapping) {
        return keyMapping.isActiveAndMatches(this.key);
    }

    public boolean is(Collection<KeyMapping> keyMappings) {
        return keyMappings.stream().anyMatch(this::is);
    }

    public boolean in(Rect2i area) {
        return MathUtil.contains(area, this.mouseX, this.mouseY);
    }

    public boolean isEscapeKey() {
        return this.isKeyboard() && this.key.m_84873_() == 256;
    }

    public boolean isEnterKey() {
        if (this.isKeyboard()) {
            int keyCode = this.key.m_84873_();
            return keyCode == 257 || keyCode == 335;
        }
        return false;
    }

    public boolean callVanilla(MouseOverable mouseOverable, MouseClickable mouseClickable) {
        if (this.key.m_84868_() == InputConstants.Type.MOUSE && mouseOverable.isMouseOver(this.mouseX, this.mouseY)) {
            if (this.isSimulate()) {
                return true;
            }
            return mouseClickable.mouseClicked(this.mouseX, this.mouseY, this.key.m_84873_());
        }
        return false;
    }

    public boolean callVanilla(KeyPressable keyPressable) {
        if (this.key.m_84868_() == InputConstants.Type.KEYSYM) {
            if (this.isSimulate()) {
                return true;
            }
            return keyPressable.keyPressed(this.key.m_84873_(), 0, this.modifiers);
        }
        return false;
    }

    public boolean callVanilla(MouseOverable mouseOverable, MouseClickable mouseClickable, KeyPressable keyPressable) {
        return switch (this.key.m_84868_()) {
            case InputConstants.Type.KEYSYM -> this.callVanilla(keyPressable);
            case InputConstants.Type.MOUSE -> this.callVanilla(mouseOverable, mouseClickable);
            default -> false;
        };
    }

    @FunctionalInterface
    public static interface MouseOverable {
        public boolean isMouseOver(double var1, double var3);
    }

    @FunctionalInterface
    public static interface MouseClickable {
        public boolean mouseClicked(double var1, double var3, int var5);
    }

    @FunctionalInterface
    public static interface KeyPressable {
        public boolean keyPressed(int var1, int var2, int var3);
    }
}

