/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.input.mouse.handlers;

import javax.annotation.Nullable;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.runtime.IRecipesGui;
import mezz.jei.config.KeyBindings;
import mezz.jei.gui.Focus;
import mezz.jei.input.CombinedRecipeFocusSource;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.input.UserInput;
import mezz.jei.input.mouse.IUserInputHandler;
import mezz.jei.input.mouse.handlers.LimitedAreaUserInputHandler;
import net.minecraft.client.gui.screens.Screen;

public class ClickFocusHandler
implements IUserInputHandler {
    private final CombinedRecipeFocusSource focusSource;
    private final IRecipesGui recipesGui;

    public ClickFocusHandler(CombinedRecipeFocusSource focusSource, IRecipesGui recipesGui) {
        this.focusSource = focusSource;
        this.recipesGui = recipesGui;
    }

    @Override
    @Nullable
    public IUserInputHandler handleUserInput(Screen screen, UserInput input) {
        IClickedIngredient<?> clicked = this.focusSource.getIngredientUnderMouse(input);
        if (clicked == null) {
            return null;
        }
        if (input.is(KeyBindings.showRecipe)) {
            if (!input.isSimulate()) {
                Focus focus = new Focus(IFocus.Mode.OUTPUT, clicked.getValue());
                this.recipesGui.show(focus);
            }
            return LimitedAreaUserInputHandler.create(this, clicked.getArea());
        }
        if (input.is(KeyBindings.showUses)) {
            if (!input.isSimulate()) {
                Focus focus = new Focus(IFocus.Mode.INPUT, clicked.getValue());
                this.recipesGui.show(focus);
            }
            return LimitedAreaUserInputHandler.create(this, clicked.getArea());
        }
        return null;
    }
}

