/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.input.mouse.handlers;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import mezz.jei.input.UserInput;
import mezz.jei.input.mouse.IUserInputHandler;
import mezz.jei.input.mouse.InputType;
import net.minecraft.client.gui.screens.Screen;

public class CombinedUserInputHandler
implements IUserInputHandler {
    private final List<IUserInputHandler> inputHandlers;
    private final Map<InputConstants.Key, IUserInputHandler> mousedDown = new HashMap<InputConstants.Key, IUserInputHandler>();
    @Nullable
    private IUserInputHandler dragStarted;

    public CombinedUserInputHandler(IUserInputHandler ... inputHandlers) {
        this.inputHandlers = List.of(inputHandlers);
    }

    public CombinedUserInputHandler(List<IUserInputHandler> inputHandlers) {
        this.inputHandlers = List.copyOf(inputHandlers);
    }

    @Override
    public IUserInputHandler handleUserInput(Screen screen, UserInput input) {
        return switch (input.getClickState()) {
            case InputType.IMMEDIATE -> this.handleImmediateClick(screen, input);
            case InputType.SIMULATE -> this.handleSimulateClick(screen, input);
            case InputType.EXECUTE -> this.handleExecuteClick(screen, input);
            default -> throw new IncompatibleClassChangeError();
        };
    }

    @Nullable
    private IUserInputHandler handleImmediateClick(Screen screen, UserInput input) {
        this.mousedDown.remove(input.getKey());
        IUserInputHandler handled = this.handleClickInternal(screen, input);
        if (handled == null) {
            return null;
        }
        return this;
    }

    @Nullable
    private IUserInputHandler handleSimulateClick(Screen screen, UserInput input) {
        this.mousedDown.remove(input.getKey());
        IUserInputHandler clickHandled = this.handleClickInternal(screen, input);
        if (clickHandled == null) {
            return null;
        }
        this.mousedDown.put(input.getKey(), clickHandled);
        return this;
    }

    @Nullable
    private IUserInputHandler handleExecuteClick(Screen screen, UserInput input) {
        IUserInputHandler inputHandler = this.mousedDown.remove(input.getKey());
        if (inputHandler == null) {
            return null;
        }
        IUserInputHandler handled = inputHandler.handleUserInput(screen, input);
        if (handled == null) {
            return null;
        }
        return this;
    }

    @Nullable
    private IUserInputHandler handleClickInternal(Screen screen, UserInput input) {
        IUserInputHandler firstHandled = null;
        for (IUserInputHandler inputHandler : this.inputHandlers) {
            if (firstHandled == null) {
                firstHandled = inputHandler.handleUserInput(screen, input);
                if (firstHandled != null) continue;
                inputHandler.handleMouseClickedOut(input.getKey());
                continue;
            }
            inputHandler.handleMouseClickedOut(input.getKey());
        }
        return firstHandled;
    }

    @Override
    public void handleMouseClickedOut(InputConstants.Key key) {
        this.mousedDown.remove(key);
        for (IUserInputHandler inputHandler : this.inputHandlers) {
            inputHandler.handleMouseClickedOut(key);
        }
    }

    public void handleGuiChange() {
        Set<InputConstants.Key> keys = Set.copyOf(this.mousedDown.keySet());
        for (InputConstants.Key key : keys) {
            this.handleMouseClickedOut(key);
        }
        this.handleDragCanceled();
    }

    @Override
    public boolean handleMouseScrolled(double mouseX, double mouseY, double scrollDelta) {
        return this.inputHandlers.stream().anyMatch(inputHandler -> inputHandler.handleMouseScrolled(mouseX, mouseY, scrollDelta));
    }

    @Override
    @Nullable
    public IUserInputHandler handleDragStart(Screen screen, UserInput input) {
        if (this.dragStarted != null) {
            this.dragStarted.handleDragCanceled();
        }
        this.dragStarted = this.inputHandlers.stream().map(i -> i.handleDragStart(screen, input)).filter(Objects::nonNull).findFirst().orElse(null);
        if (this.dragStarted == null) {
            return null;
        }
        return this;
    }

    @Override
    @Nullable
    public IUserInputHandler handleDragComplete(Screen screen, UserInput input) {
        if (this.dragStarted == null) {
            return null;
        }
        this.dragStarted.handleDragComplete(screen, input);
        this.dragStarted = null;
        return this;
    }

    @Override
    public void handleDragCanceled() {
        if (this.dragStarted != null) {
            this.dragStarted.handleDragCanceled();
            this.dragStarted = null;
        }
    }
}

