/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.debug;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.Internal;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.IIngredientHelper;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DebugGhostIngredientHandler<T extends AbstractContainerScreen<?>>
implements IGhostIngredientHandler<T> {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public <I> List<IGhostIngredientHandler.Target<I>> getTargets(T gui, I ingredient, boolean doStart) {
        ArrayList<IGhostIngredientHandler.Target<I>> targets = new ArrayList<IGhostIngredientHandler.Target<I>>();
        targets.add(new DebugInfoTarget("Got an Ingredient", new Rect2i(0, 0, 20, 20)));
        if (doStart) {
            IIngredientHelper<I> ingredientHelper = Internal.getIngredientManager().getIngredientHelper(ingredient);
            LOGGER.info("Ghost Ingredient Handling Starting with {}", (Object)ingredientHelper.getErrorInfo(ingredient));
            targets.add(new DebugInfoTarget("Got an Ingredient", new Rect2i(20, 20, 20, 20)));
        }
        if (ingredient instanceof ItemStack) {
            boolean even = true;
            for (Slot slot : gui.m_6262_().f_38839_) {
                if (even) {
                    Rect2i area = new Rect2i(gui.getGuiLeft() + slot.f_40220_, gui.getGuiTop() + slot.f_40221_, 16, 16);
                    targets.add(new DebugInfoTarget("Got an Ingredient in Gui", area));
                }
                even = !even;
            }
        }
        return targets;
    }

    @Override
    public void onComplete() {
        LOGGER.info("Ghost Ingredient Handling Complete");
    }

    private static class DebugInfoTarget<I>
    implements IGhostIngredientHandler.Target<I> {
        private final String message;
        private final Rect2i rectangle;

        public DebugInfoTarget(String message, Rect2i rectangle) {
            this.message = message;
            this.rectangle = rectangle;
        }

        @Override
        public Rect2i getArea() {
            return this.rectangle;
        }

        @Override
        public void accept(I ingredient) {
            IIngredientHelper<I> ingredientHelper = Internal.getIngredientManager().getIngredientHelper(ingredient);
            LOGGER.info("{}: {}", (Object)this.message, (Object)ingredientHelper.getErrorInfo(ingredient));
        }
    }
}

