/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.transfer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public final class BasicRecipeTransferHandlerServer {
    private BasicRecipeTransferHandlerServer() {
    }

    public static void setItems(Player player, Map<Integer, Integer> slotIdMap, List<Integer> craftingSlots, List<Integer> inventorySlots, boolean maxTransfer, boolean requireCompleteSets) {
        AbstractContainerMenu container = player.f_36096_;
        HashMap<Integer, ItemStack> slotMap = new HashMap<Integer, ItemStack>(slotIdMap.size());
        for (Map.Entry<Integer, Integer> entry : slotIdMap.entrySet()) {
            Slot slot = container.m_38853_(entry.getValue().intValue());
            ItemStack slotStack = slot.m_7993_();
            if (slotStack.m_41619_()) {
                return;
            }
            ItemStack stack = slotStack.m_41777_();
            stack.m_41764_(1);
            slotMap.put(entry.getKey(), stack);
        }
        boolean transferAsCompleteSets = requireCompleteSets || !maxTransfer;
        Map<Integer, ItemStack> toTransfer = BasicRecipeTransferHandlerServer.removeItemsFromInventory(player, container, slotMap, craftingSlots, inventorySlots, transferAsCompleteSets, maxTransfer);
        if (toTransfer.isEmpty()) {
            return;
        }
        int minSlotStackLimit = Integer.MAX_VALUE;
        ArrayList<ItemStack> clearedCraftingItems = new ArrayList<ItemStack>();
        for (int craftingSlotNumberIndex = 0; craftingSlotNumberIndex < craftingSlots.size(); ++craftingSlotNumberIndex) {
            ItemStack transferItem;
            int craftingSlotNumber = craftingSlots.get(craftingSlotNumberIndex);
            Slot craftingSlot = container.m_38853_(craftingSlotNumber);
            if (!craftingSlot.m_8010_(player)) continue;
            if (craftingSlot.m_6657_()) {
                ItemStack craftingItem = craftingSlot.m_6201_(Integer.MAX_VALUE);
                clearedCraftingItems.add(craftingItem);
            }
            if (!requireCompleteSets || (transferItem = toTransfer.get(craftingSlotNumberIndex)) == null) continue;
            int slotStackLimit = craftingSlot.m_5866_(transferItem);
            minSlotStackLimit = Math.min(slotStackLimit, minSlotStackLimit);
        }
        for (Map.Entry<Integer, ItemStack> entry : toTransfer.entrySet()) {
            ItemStack stack;
            Integer craftNumber = entry.getKey();
            Integer slotNumber = craftingSlots.get(craftNumber);
            Slot slot = container.m_38853_(slotNumber.intValue());
            if (slot.m_5857_(stack = entry.getValue())) {
                if (stack.m_41613_() > minSlotStackLimit) {
                    ItemStack remainder = stack.m_41620_(stack.m_41613_() - minSlotStackLimit);
                    clearedCraftingItems.add(remainder);
                }
                slot.m_5852_(stack);
                continue;
            }
            clearedCraftingItems.add(stack);
        }
        for (ItemStack oldCraftingItem : clearedCraftingItems) {
            int added = BasicRecipeTransferHandlerServer.addStack(container, inventorySlots, oldCraftingItem);
            if (added >= oldCraftingItem.m_41613_() || player.m_150109_().m_36054_(oldCraftingItem)) continue;
            player.m_36176_(oldCraftingItem, false);
        }
        container.m_38946_();
    }

    @Nonnull
    private static Map<Integer, ItemStack> removeItemsFromInventory(Player player, AbstractContainerMenu container, Map<Integer, ItemStack> required, List<Integer> craftingSlots, List<Integer> inventorySlots, boolean transferAsCompleteSets, boolean maxTransfer) {
        HashMap<Integer, ItemStack> result;
        block8: {
            boolean noItemsFound;
            result = new HashMap<Integer, ItemStack>(required.size());
            do {
                HashMap<Slot, ItemStack> originalSlotContents = null;
                if (transferAsCompleteSets) {
                    originalSlotContents = new HashMap<Slot, ItemStack>();
                }
                HashMap<Integer, ItemStack> foundItemsInSet = new HashMap<Integer, ItemStack>(required.size());
                noItemsFound = true;
                for (Map.Entry<Integer, ItemStack> entry : required.entrySet()) {
                    boolean resultItemStackLimitReached;
                    ItemStack requiredStack = entry.getValue().m_41777_();
                    Slot slot = BasicRecipeTransferHandlerServer.getSlotWithStack(container, requiredStack, craftingSlots, inventorySlots);
                    boolean itemFound = slot != null && !slot.m_7993_().m_41619_() && slot.m_8010_(player);
                    ItemStack resultItemStack = (ItemStack)result.get(entry.getKey());
                    boolean bl = resultItemStackLimitReached = resultItemStack != null && resultItemStack.m_41613_() == resultItemStack.m_41741_();
                    if (!itemFound || resultItemStackLimitReached) {
                        if (!transferAsCompleteSets) continue;
                        for (Map.Entry slotEntry : originalSlotContents.entrySet()) {
                            ItemStack stack = (ItemStack)slotEntry.getValue();
                            ((Slot)slotEntry.getKey()).m_5852_(stack);
                        }
                        break block8;
                    }
                    if (originalSlotContents != null && !originalSlotContents.containsKey(slot)) {
                        originalSlotContents.put(slot, slot.m_7993_().m_41777_());
                    }
                    ItemStack removedItemStack = slot.m_6201_(1);
                    foundItemsInSet.put(entry.getKey(), removedItemStack);
                    noItemsFound = false;
                }
                for (Map.Entry<Integer, Object> entry : foundItemsInSet.entrySet()) {
                    ItemStack resultItemStack = (ItemStack)result.get(entry.getKey());
                    if (resultItemStack == null) {
                        result.put(entry.getKey(), (ItemStack)entry.getValue());
                        continue;
                    }
                    resultItemStack.m_41769_(1);
                }
            } while (maxTransfer && !noItemsFound);
        }
        return result;
    }

    @Nullable
    private static Slot getSlotWithStack(AbstractContainerMenu container, ItemStack stack, List<Integer> craftingSlots, List<Integer> inventorySlots) {
        Slot slot = BasicRecipeTransferHandlerServer.getSlotWithStack(container, craftingSlots, stack);
        if (slot == null) {
            slot = BasicRecipeTransferHandlerServer.getSlotWithStack(container, inventorySlots, stack);
        }
        return slot;
    }

    private static int addStack(AbstractContainerMenu container, Collection<Integer> slotIndexes, ItemStack stack) {
        Slot slot;
        ItemStack inventoryStack;
        int added = 0;
        for (Integer slotIndex : slotIndexes) {
            if (slotIndex < 0 || slotIndex >= container.f_38839_.size() || (inventoryStack = (slot = container.m_38853_(slotIndex.intValue())).m_7993_()).m_41619_() || !inventoryStack.m_41753_() || !inventoryStack.m_41656_(stack) || !ItemStack.m_41658_((ItemStack)inventoryStack, (ItemStack)stack)) continue;
            int remain = stack.m_41613_() - added;
            int maxStackSize = Math.min(slot.m_5866_(inventoryStack), inventoryStack.m_41741_());
            int space = maxStackSize - inventoryStack.m_41613_();
            if (space <= 0) continue;
            if (space >= remain) {
                inventoryStack.m_41769_(remain);
                return stack.m_41613_();
            }
            inventoryStack.m_41764_(inventoryStack.m_41741_());
            added += space;
        }
        if (added >= stack.m_41613_()) {
            return added;
        }
        for (Integer slotIndex : slotIndexes) {
            if (slotIndex < 0 || slotIndex >= container.f_38839_.size() || !(inventoryStack = (slot = container.m_38853_(slotIndex.intValue())).m_7993_()).m_41619_()) continue;
            ItemStack stackToAdd = stack.m_41777_();
            stackToAdd.m_41764_(stack.m_41613_() - added);
            slot.m_5852_(stackToAdd);
            return stack.m_41613_();
        }
        return added;
    }

    @Nullable
    private static Slot getSlotWithStack(AbstractContainerMenu container, Iterable<Integer> slotNumbers, ItemStack itemStack) {
        for (Integer slotNumber : slotNumbers) {
            Slot slot;
            ItemStack slotStack;
            if (slotNumber < 0 || slotNumber >= container.f_38839_.size() || !ItemStack.m_41746_((ItemStack)itemStack, (ItemStack)(slotStack = (slot = container.m_38853_(slotNumber.intValue())).m_7993_())) || !ItemStack.m_41658_((ItemStack)itemStack, (ItemStack)slotStack)) continue;
            return slot;
        }
        return null;
    }
}

