/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.util;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.util.ArrayList;
import javax.annotation.Nullable;
import mezz.jei.config.IServerConfig;
import mezz.jei.config.ServerConfig;
import mezz.jei.network.Network;
import mezz.jei.network.packets.PacketCheatPermission;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.GiveMode;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class CommandUtilServer {
    private static final Logger LOGGER = LogManager.getLogger();

    private CommandUtilServer() {
    }

    public static String[] getGiveCommandParameters(Player sender, ItemStack itemStack, int amount) {
        Component senderName = sender.m_7755_();
        Item item = itemStack.m_41720_();
        ResourceLocation itemResourceLocation = item.getRegistryName();
        if (itemResourceLocation == null) {
            String stackInfo = ErrorUtil.getItemStackInfo(itemStack);
            throw new IllegalArgumentException("item.getRegistryName() returned null for: " + stackInfo);
        }
        ArrayList<String> commandStrings = new ArrayList<String>();
        commandStrings.add(senderName.getString());
        Object itemArgument = itemResourceLocation.toString();
        CompoundTag tagCompound = itemStack.m_41783_();
        if (tagCompound != null) {
            itemArgument = (String)itemArgument + tagCompound;
        }
        commandStrings.add((String)itemArgument);
        commandStrings.add(String.valueOf(amount));
        return commandStrings.toArray(new String[0]);
    }

    public static void writeChatMessage(Player player, String translationKey, ChatFormatting color) {
        TranslatableComponent component = new TranslatableComponent(translationKey);
        component.m_7383_().m_131157_(color);
        player.m_6352_((Component)component, Util.f_137441_);
    }

    public static boolean hasPermissionForCheatMode(Player sender) {
        CommandNode<CommandSourceStack> giveCommand;
        MinecraftServer minecraftServer;
        IServerConfig serverConfig = ServerConfig.getInstance();
        if (serverConfig.isCheatModeEnabledForCreative() && sender.m_7500_()) {
            return true;
        }
        CommandSourceStack commandSource = sender.m_20203_();
        if (serverConfig.isCheatModeEnabledForOp() && (minecraftServer = sender.m_20194_()) != null) {
            int opPermissionLevel = minecraftServer.m_7022_();
            return commandSource.m_6761_(opPermissionLevel);
        }
        if (serverConfig.isCheatModeEnabledForGive() && (giveCommand = CommandUtilServer.getGiveCommand(sender)) != null) {
            return giveCommand.canUse((Object)commandSource);
        }
        return false;
    }

    public static void executeGive(ServerPlayer sender, ItemStack itemStack, GiveMode giveMode) {
        if (CommandUtilServer.hasPermissionForCheatMode((Player)sender)) {
            if (giveMode == GiveMode.INVENTORY) {
                CommandUtilServer.giveToInventory((Player)sender, itemStack);
            } else if (giveMode == GiveMode.MOUSE_PICKUP) {
                CommandUtilServer.mousePickupItemStack((Player)sender, itemStack);
            }
        } else {
            Network.sendPacketToClient(new PacketCheatPermission(false), sender);
        }
    }

    public static void setHotbarSlot(ServerPlayer sender, ItemStack itemStack, int hotbarSlot) {
        if (CommandUtilServer.hasPermissionForCheatMode((Player)sender)) {
            if (!Inventory.m_36045_((int)hotbarSlot)) {
                LOGGER.error("Tried to set slot that is not in the hotbar: {}", (Object)hotbarSlot);
                return;
            }
            ItemStack stackInSlot = sender.m_150109_().m_8020_(hotbarSlot);
            if (ItemStack.m_41728_((ItemStack)stackInSlot, (ItemStack)itemStack)) {
                return;
            }
            ItemStack itemStackCopy = itemStack.m_41777_();
            sender.m_150109_().m_6836_(hotbarSlot, itemStack);
            sender.f_19853_.m_6263_(null, sender.m_20185_(), sender.m_20186_(), sender.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((sender.m_21187_().nextFloat() - sender.m_21187_().nextFloat()) * 0.7f + 1.0f) * 2.0f);
            sender.f_36095_.m_38946_();
            CommandUtilServer.notifyGive((Player)sender, itemStackCopy);
        } else {
            Network.sendPacketToClient(new PacketCheatPermission(false), sender);
        }
    }

    public static void mousePickupItemStack(Player sender, ItemStack itemStack) {
        int giveCount;
        AbstractContainerMenu containerMenu = sender.f_36096_;
        ItemStack itemStackCopy = itemStack.m_41777_();
        ItemStack existingStack = containerMenu.m_142621_();
        if (ItemHandlerHelper.canItemStacksStack((ItemStack)existingStack, (ItemStack)itemStack)) {
            int newCount = Math.min(existingStack.m_41741_(), existingStack.m_41613_() + itemStack.m_41613_());
            giveCount = newCount - existingStack.m_41613_();
            existingStack.m_41764_(newCount);
        } else {
            containerMenu.m_142503_(itemStack);
            giveCount = itemStack.m_41613_();
        }
        Player player = sender;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayerEntity = (ServerPlayer)player;
            itemStackCopy.m_41764_(giveCount);
            CommandUtilServer.notifyGive((Player)serverPlayerEntity, itemStackCopy);
            containerMenu.m_38946_();
        }
    }

    private static void giveToInventory(Player entityplayermp, ItemStack itemStack) {
        ItemStack itemStackCopy = itemStack.m_41777_();
        boolean flag = entityplayermp.m_150109_().m_36054_(itemStack);
        if (flag && itemStack.m_41619_()) {
            itemStack.m_41764_(1);
            ItemEntity entityitem = entityplayermp.m_36176_(itemStack, false);
            if (entityitem != null) {
                entityitem.m_32065_();
            }
            entityplayermp.f_19853_.m_6263_(null, entityplayermp.m_20185_(), entityplayermp.m_20186_(), entityplayermp.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((entityplayermp.m_21187_().nextFloat() - entityplayermp.m_21187_().nextFloat()) * 0.7f + 1.0f) * 2.0f);
            entityplayermp.f_36095_.m_38946_();
        } else {
            ItemEntity entityitem = entityplayermp.m_36176_(itemStack, false);
            if (entityitem != null) {
                entityitem.m_32061_();
                entityitem.m_32047_(entityplayermp.m_142081_());
            }
        }
        CommandUtilServer.notifyGive(entityplayermp, itemStackCopy);
    }

    private static void notifyGive(Player entityPlayerMP, ItemStack stack) {
        CommandSourceStack commandSource = entityPlayerMP.m_20203_();
        int count = stack.m_41613_();
        Component stackTextComponent = stack.m_41611_();
        Component displayName = entityPlayerMP.m_5446_();
        TranslatableComponent message = new TranslatableComponent("commands.give.success.single", new Object[]{count, stackTextComponent, displayName});
        commandSource.m_81354_((Component)message, true);
    }

    @Nullable
    private static CommandNode<CommandSourceStack> getGiveCommand(Player sender) {
        MinecraftServer minecraftServer = sender.m_20194_();
        if (minecraftServer == null) {
            return null;
        }
        Commands commandManager = minecraftServer.m_129892_();
        CommandDispatcher dispatcher = commandManager.m_82094_();
        RootCommandNode root = dispatcher.getRoot();
        return root.getChild("give");
    }
}

