/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.trashslot.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.blay09.mods.balm.mixin.AbstractContainerScreenAccessor;
import net.blay09.mods.balm.mixin.SlotAccessor;
import net.blay09.mods.trashslot.TrashSlotConfig;
import net.blay09.mods.trashslot.TrashSlotSaveState;
import net.blay09.mods.trashslot.api.IGuiContainerLayout;
import net.blay09.mods.trashslot.api.SlotRenderStyle;
import net.blay09.mods.trashslot.api.Snap;
import net.blay09.mods.trashslot.client.ContainerSettings;
import net.blay09.mods.trashslot.client.TrashSlotGuiHandler;
import net.blay09.mods.trashslot.client.TrashSlotSlot;
import net.blay09.mods.trashslot.client.deletion.DeletionProvider;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.Slot;

public class TrashSlotComponent
extends GuiComponent {
    private static final ResourceLocation texture = new ResourceLocation("trashslot", "textures/gui/slot.png");
    private static final int SNAP_SIZE = 7;
    private final AbstractContainerScreen<?> screen;
    private final IGuiContainerLayout layout;
    private final ContainerSettings settings;
    private final TrashSlotSlot trashSlot;
    private SlotRenderStyle renderStyle = SlotRenderStyle.LONE;
    private boolean wasMouseDown;
    private boolean isDragging;
    private int dragStartX;
    private int dragStartY;

    public TrashSlotComponent(AbstractContainerScreen<?> screen, IGuiContainerLayout layout, ContainerSettings settings, TrashSlotSlot trashSlot) {
        this.screen = screen;
        this.layout = layout;
        this.settings = settings;
        this.trashSlot = trashSlot;
    }

    public boolean isInside(int mouseX, int mouseY) {
        int anchoredX = this.getAnchoredX();
        int anchoredY = this.getAnchoredY();
        int renderX = anchoredX + this.renderStyle.getRenderOffsetX() + this.layout.getSlotOffsetX(this.screen, this.renderStyle);
        int renderY = anchoredY + this.renderStyle.getRenderOffsetY() + this.layout.getSlotOffsetY(this.screen, this.renderStyle);
        return mouseX >= renderX && mouseY >= renderY && mouseX < renderX + this.renderStyle.getRenderWidth() && mouseY < renderY + this.renderStyle.getRenderHeight();
    }

    public void update(int mouseX, int mouseY) {
        boolean isMouseOver;
        int anchoredX = this.getAnchoredX();
        int anchoredY = this.getAnchoredY();
        int renderX = anchoredX + this.renderStyle.getRenderOffsetX() + this.layout.getSlotOffsetX(this.screen, this.renderStyle);
        int renderY = anchoredY + this.renderStyle.getRenderOffsetY() + this.layout.getSlotOffsetY(this.screen, this.renderStyle);
        boolean bl = isMouseOver = mouseX >= renderX && mouseY >= renderY && mouseX < renderX + this.renderStyle.getRenderWidth() && mouseY < renderY + this.renderStyle.getRenderHeight();
        if (TrashSlotGuiHandler.isLeftMouseDown()) {
            if (!(this.isDragging || !isMouseOver || this.wasMouseDown || !this.screen.getMinecraft().f_91074_.f_36096_.m_142621_().m_41619_() || this.trashSlot.m_6657_() && ((AbstractContainerScreenAccessor)this.screen).callIsHovering((Slot)this.trashSlot, (double)mouseX, (double)mouseY))) {
                this.dragStartX = renderX - mouseX;
                this.dragStartY = renderY - mouseY;
                this.isDragging = true;
            }
            this.wasMouseDown = true;
        } else {
            if (this.isDragging) {
                TrashSlotSaveState.save();
                this.isDragging = false;
            }
            this.wasMouseDown = false;
        }
        if (this.isDragging) {
            int targetX = mouseX + this.dragStartX;
            int targetY = mouseY + this.dragStartY;
            for (Rect2i collisionArea : this.layout.getCollisionAreas(this.screen)) {
                int targetRight = targetX + this.renderStyle.getWidth();
                int targetBottom = targetY + this.renderStyle.getHeight();
                int rectRight = collisionArea.m_110085_() + collisionArea.m_110090_();
                int rectBottom = collisionArea.m_110086_() + collisionArea.m_110091_();
                if (targetRight < collisionArea.m_110085_() || targetX >= rectRight || targetBottom < collisionArea.m_110086_() || targetY >= rectBottom) continue;
                int distLeft = targetRight - collisionArea.m_110085_();
                int distRight = rectRight - targetX;
                int distTop = targetBottom - collisionArea.m_110086_();
                int distBottom = rectBottom - targetY;
                if (anchoredX >= collisionArea.m_110085_() && anchoredX < collisionArea.m_110085_() + collisionArea.m_110090_()) {
                    targetY = distTop < distBottom ? collisionArea.m_110086_() - this.renderStyle.getHeight() : collisionArea.m_110086_() + collisionArea.m_110091_();
                    continue;
                }
                targetX = distLeft < distRight ? collisionArea.m_110085_() - this.renderStyle.getWidth() : collisionArea.m_110085_() + collisionArea.m_110090_();
            }
            if (!Screen.m_96638_()) {
                int bestSnapDist = Integer.MAX_VALUE;
                Snap bestSnap = null;
                for (Snap snap : this.layout.getSnaps(this.screen, this.renderStyle)) {
                    int dist = Integer.MAX_VALUE;
                    switch (snap.getType()) {
                        case HORIZONTAL: {
                            dist = Math.abs(snap.getY() - targetY);
                            break;
                        }
                        case VERTICAL: {
                            dist = Math.abs(snap.getX() - targetX);
                            break;
                        }
                        case FIXED: {
                            int distX = snap.getX() - targetX;
                            int distY = snap.getY() - targetY;
                            dist = (int)Math.sqrt(distX * distX + distY * distY);
                        }
                    }
                    if (dist >= 7 || dist >= bestSnapDist) continue;
                    bestSnap = snap;
                    bestSnapDist = dist;
                }
                if (bestSnap != null) {
                    if (bestSnap.getType() == Snap.Type.VERTICAL || bestSnap.getType() == Snap.Type.FIXED) {
                        targetX = bestSnap.getX();
                    }
                    if (bestSnap.getType() == Snap.Type.HORIZONTAL || bestSnap.getType() == Snap.Type.FIXED) {
                        targetY = bestSnap.getY();
                    }
                }
            }
            targetX = Mth.m_14045_((int)targetX, (int)0, (int)(this.screen.f_96543_ - this.renderStyle.getRenderWidth()));
            targetY = Mth.m_14045_((int)targetY, (int)0, (int)(this.screen.f_96544_ - this.renderStyle.getRenderHeight()));
            this.settings.setSlotX(this.getUnanchoredX(targetX));
            this.settings.setSlotY(this.getUnanchoredY(targetY));
        }
    }

    public void drawBackground(PoseStack poseStack) {
        int renderX = this.getAnchoredX();
        int renderY = this.getAnchoredY();
        this.renderStyle = this.layout.getSlotRenderStyle(this.screen, renderX, renderY);
        ((SlotAccessor)this.trashSlot).setX(renderX - this.screen.getGuiLeft() + this.renderStyle.getSlotOffsetX() + this.layout.getSlotOffsetX(this.screen, this.renderStyle));
        ((SlotAccessor)this.trashSlot).setY(renderY - this.screen.getGuiTop() + this.renderStyle.getSlotOffsetY() + this.layout.getSlotOffsetY(this.screen, this.renderStyle));
        this.m_93250_(1);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        renderX += this.renderStyle.getRenderOffsetX() + this.layout.getSlotOffsetX(this.screen, this.renderStyle);
        renderY += this.renderStyle.getRenderOffsetY() + this.layout.getSlotOffsetY(this.screen, this.renderStyle);
        DeletionProvider deletionProvider = TrashSlotConfig.getDeletionProvider();
        int texOffsetX = 0;
        if (deletionProvider == null || !deletionProvider.canUndeleteLast()) {
            texOffsetX = 64;
        }
        switch (this.renderStyle) {
            case LONE: {
                this.m_93228_(poseStack, renderX, renderY, texOffsetX, 56, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
                break;
            }
            case ATTACH_BOTTOM_CENTER: {
                this.m_93228_(poseStack, renderX, renderY, texOffsetX, 0, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
                this.m_93228_(poseStack, renderX, renderY, texOffsetX + 50, 29, 4, 4);
                this.m_93228_(poseStack, renderX + this.renderStyle.getRenderWidth() - 4, renderY, texOffsetX + 54, 29, 4, 4);
                break;
            }
            case ATTACH_BOTTOM_LEFT: {
                this.m_93228_(poseStack, renderX, renderY, texOffsetX, 0, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
                this.m_93228_(poseStack, renderX + this.renderStyle.getRenderWidth() - 4, renderY, texOffsetX + 54, 29, 4, 4);
                break;
            }
            case ATTACH_BOTTOM_RIGHT: {
                this.m_93228_(poseStack, renderX, renderY, texOffsetX, 0, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
                this.m_93228_(poseStack, renderX, renderY, texOffsetX + 50, 29, 4, 4);
                break;
            }
            case ATTACH_TOP_CENTER: {
                this.m_93228_(poseStack, renderX, renderY, texOffsetX + 32, 0, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
                this.m_93228_(poseStack, renderX, renderY + this.renderStyle.getRenderHeight() - 4, texOffsetX + 50, 25, 4, 4);
                this.m_93228_(poseStack, renderX + this.renderStyle.getRenderWidth() - 4, renderY + this.renderStyle.getRenderHeight() - 4, texOffsetX + 54, 25, 4, 4);
                break;
            }
            case ATTACH_TOP_LEFT: {
                this.m_93228_(poseStack, renderX, renderY, texOffsetX + 32, 0, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
                this.m_93228_(poseStack, renderX + this.renderStyle.getRenderWidth() - 4, renderY + this.renderStyle.getRenderHeight() - 4, texOffsetX + 54, 25, 4, 4);
                break;
            }
            case ATTACH_TOP_RIGHT: {
                this.m_93228_(poseStack, renderX, renderY, texOffsetX + 32, 0, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
                this.m_93228_(poseStack, renderX, renderY + this.renderStyle.getRenderHeight() - 4, texOffsetX + 50, 25, 4, 4);
                break;
            }
            case ATTACH_LEFT_CENTER: {
                this.m_93228_(poseStack, renderX, renderY, texOffsetX + 25, 25, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
                this.m_93228_(poseStack, renderX + this.renderStyle.getRenderWidth() - 4, renderY, texOffsetX + 50, 33, 4, 4);
                this.m_93228_(poseStack, renderX + this.renderStyle.getRenderWidth() - 4, renderY + this.renderStyle.getRenderHeight() - 4, texOffsetX + 50, 37, 4, 4);
                break;
            }
            case ATTACH_LEFT_TOP: {
                this.m_93228_(poseStack, renderX, renderY, texOffsetX + 25, 25, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
                this.m_93228_(poseStack, renderX + this.renderStyle.getRenderWidth() - 4, renderY + this.renderStyle.getRenderHeight() - 4, texOffsetX + 50, 37, 4, 4);
                break;
            }
            case ATTACH_LEFT_BOTTOM: {
                this.m_93228_(poseStack, renderX, renderY, texOffsetX + 25, 25, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
                this.m_93228_(poseStack, renderX + this.renderStyle.getRenderWidth() - 4, renderY, texOffsetX + 50, 33, 4, 4);
                break;
            }
            case ATTACH_RIGHT_CENTER: {
                this.m_93228_(poseStack, renderX, renderY, texOffsetX, 25, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
                this.m_93228_(poseStack, renderX, renderY, texOffsetX + 54, 33, 4, 4);
                this.m_93228_(poseStack, renderX, renderY + this.renderStyle.getRenderHeight() - 4, texOffsetX + 54, 37, 4, 4);
                break;
            }
            case ATTACH_RIGHT_TOP: {
                this.m_93228_(poseStack, renderX, renderY, texOffsetX, 25, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
                this.m_93228_(poseStack, renderX, renderY + this.renderStyle.getRenderHeight() - 4, texOffsetX + 54, 37, 4, 4);
                break;
            }
            case ATTACH_RIGHT_BOTTOM: {
                this.m_93228_(poseStack, renderX, renderY, texOffsetX, 25, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
                this.m_93228_(poseStack, renderX, renderY, texOffsetX + 54, 33, 4, 4);
            }
        }
        this.m_93250_(0);
    }

    private int getAnchoredX() {
        return Mth.m_14045_((int)(this.settings.getSlotX() + this.screen.getGuiLeft() + (int)((float)this.screen.getXSize() * this.settings.getAnchorX())), (int)0, (int)(this.screen.f_96543_ - this.renderStyle.getRenderWidth()));
    }

    private int getUnanchoredX(int x) {
        return x - this.screen.getGuiLeft() - (int)((float)this.screen.getXSize() * this.settings.getAnchorX());
    }

    private int getAnchoredY() {
        return Mth.m_14045_((int)(this.settings.getSlotY() + this.screen.getGuiTop() + (int)((float)this.screen.getYSize() * this.settings.getAnchorY())), (int)0, (int)(this.screen.f_96543_ - this.renderStyle.getRenderWidth()));
    }

    private int getUnanchoredY(int y) {
        return y - this.screen.getGuiTop() - (int)((float)this.screen.getYSize() * this.settings.getAnchorY());
    }

    public boolean isVisible() {
        return this.settings.isEnabled();
    }

    public Rect2i getRectangle() {
        int anchoredX = this.getAnchoredX();
        int anchoredY = this.getAnchoredY();
        int renderX = anchoredX + this.renderStyle.getRenderOffsetX() + this.layout.getSlotOffsetX(this.screen, this.renderStyle);
        int renderY = anchoredY + this.renderStyle.getRenderOffsetY() + this.layout.getSlotOffsetY(this.screen, this.renderStyle);
        return new Rect2i(renderX, renderY, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
    }
}

