/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.jei.category;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.Create;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.animations.AnimatedSpout;
import com.simibubi.create.content.contraptions.fluids.actors.FillingRecipe;
import com.simibubi.create.content.contraptions.fluids.actors.GenericItemFilling;
import com.simibubi.create.content.contraptions.fluids.potion.PotionFluidHandler;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class SpoutCategory
extends CreateRecipeCategory<FillingRecipe> {
    AnimatedSpout spout = new AnimatedSpout();

    public SpoutCategory() {
        super(SpoutCategory.doubleItemIcon((ItemLike)AllBlocks.SPOUT.get(), (ItemLike)Items.f_42447_), SpoutCategory.emptyBackground(177, 70));
    }

    public static List<FillingRecipe> getRecipes(IIngredientManager ingredientManager) {
        ArrayList<FillingRecipe> recipes = new ArrayList<FillingRecipe>();
        ingredientManager.getAllIngredients(VanillaTypes.ITEM).stream().forEach(stack -> {
            if (stack.m_41720_() instanceof PotionItem) {
                FluidStack fluidFromPotionItem = PotionFluidHandler.getFluidFromPotionItem(stack);
                Ingredient bottle = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42590_});
                recipes.add(new ProcessingRecipeBuilder<FillingRecipe>(FillingRecipe::new, Create.asResource("potions")).withItemIngredients(bottle).withFluidIngredients(FluidIngredient.fromFluidStack(fluidFromPotionItem)).withSingleItemOutput((ItemStack)stack).build());
                return;
            }
            LazyOptional capability = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
            if (!capability.isPresent()) {
                return;
            }
            ingredientManager.getAllIngredients(VanillaTypes.FLUID).stream().forEach(fluidStack -> {
                ItemStack copy = stack.m_41777_();
                copy.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(fhi -> {
                    if (!GenericItemFilling.isFluidHandlerValid(copy, fhi)) {
                        return;
                    }
                    FluidStack fluidCopy = fluidStack.copy();
                    fluidCopy.setAmount(1000);
                    fhi.fill(fluidCopy, IFluidHandler.FluidAction.EXECUTE);
                    ItemStack container = fhi.getContainer();
                    if (container.m_41656_(copy)) {
                        return;
                    }
                    if (container.m_41619_()) {
                        return;
                    }
                    Ingredient bucket = Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack});
                    ResourceLocation itemName = stack.m_41720_().getRegistryName();
                    ResourceLocation fluidName = fluidCopy.getFluid().getRegistryName();
                    recipes.add(new ProcessingRecipeBuilder<FillingRecipe>(FillingRecipe::new, Create.asResource("fill_" + itemName.m_135827_() + "_" + itemName.m_135815_() + "_with_" + fluidName.m_135827_() + "_" + fluidName.m_135815_())).withItemIngredients(bucket).withFluidIngredients(FluidIngredient.fromFluidStack(fluidCopy)).withSingleItemOutput(container).build());
                });
            });
        });
        return recipes;
    }

    public Class<? extends FillingRecipe> getRecipeClass() {
        return FillingRecipe.class;
    }

    public void setIngredients(FillingRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.m_7527_());
        ingredients.setInputLists(VanillaTypes.FLUID, recipe.getFluidIngredients().stream().map(FluidIngredient::getMatchingFluidStacks).collect(Collectors.toList()));
        if (!recipe.getRollableResults().isEmpty()) {
            ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.m_8043_());
        }
        if (!recipe.getFluidResults().isEmpty()) {
            ingredients.setOutputs(VanillaTypes.FLUID, recipe.getFluidResults());
        }
    }

    public void setRecipe(IRecipeLayout recipeLayout, FillingRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup fluidStacks = recipeLayout.getFluidStacks();
        FluidIngredient fluidIngredient = recipe.getRequiredFluid();
        List<ItemStack> matchingIngredients = Arrays.asList(((Ingredient)recipe.m_7527_().get(0)).m_43908_());
        fluidStacks.init(0, true, 27, 32);
        fluidStacks.set(0, SpoutCategory.withImprovedVisibility(fluidIngredient.getMatchingFluidStacks()));
        itemStacks.init(0, true, 26, 50);
        itemStacks.set(0, matchingIngredients);
        itemStacks.init(1, false, 131, 50);
        itemStacks.set(1, recipe.m_8043_());
        SpoutCategory.addFluidTooltip(fluidStacks, (List<FluidIngredient>)ImmutableList.of((Object)fluidIngredient), Collections.emptyList());
    }

    public void draw(FillingRecipe recipe, PoseStack matrixStack, double mouseX, double mouseY) {
        AllGuiTextures.JEI_SLOT.render(matrixStack, 26, 31);
        AllGuiTextures.JEI_SLOT.render(matrixStack, 26, 50);
        SpoutCategory.getRenderedSlot(recipe, 0).render(matrixStack, 131, 50);
        AllGuiTextures.JEI_SHADOW.render(matrixStack, 62, 57);
        AllGuiTextures.JEI_DOWN_ARROW.render(matrixStack, 126, 29);
        this.spout.withFluids(recipe.getRequiredFluid().getMatchingFluidStacks()).draw(matrixStack, this.getBackground().getWidth() / 2 - 13, 22);
    }
}

