/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.base;

import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.contraptions.wrench.IWrenchable;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.utility.Lang;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;

public interface IRotate
extends IWrenchable {
    public boolean hasShaftTowards(LevelReader var1, BlockPos var2, BlockState var3, Direction var4);

    public Direction.Axis getRotationAxis(BlockState var1);

    default public SpeedLevel getMinimumRequiredSpeedLevel() {
        return SpeedLevel.NONE;
    }

    default public boolean hideStressImpact() {
        return false;
    }

    default public boolean showCapacityWithAnnotation() {
        return false;
    }

    public static enum SpeedLevel {
        NONE,
        MEDIUM,
        FAST;


        public ChatFormatting getTextColor() {
            return this == NONE ? ChatFormatting.GREEN : (this == MEDIUM ? ChatFormatting.AQUA : ChatFormatting.LIGHT_PURPLE);
        }

        public int getColor() {
            return this == NONE ? 0x22FF22 : (this == MEDIUM ? 34047 : 0xFF55FF);
        }

        public int getParticleSpeed() {
            return this == NONE ? 10 : (this == MEDIUM ? 20 : 30);
        }

        public static SpeedLevel of(float speed) {
            if ((double)(speed = Math.abs(speed)) >= (Double)AllConfigs.SERVER.kinetics.fastSpeed.get()) {
                return FAST;
            }
            if ((double)speed >= (Double)AllConfigs.SERVER.kinetics.mediumSpeed.get()) {
                return MEDIUM;
            }
            return NONE;
        }

        public float getSpeedValue() {
            switch (this) {
                case FAST: {
                    return ((Double)AllConfigs.SERVER.kinetics.fastSpeed.get()).floatValue();
                }
                case MEDIUM: {
                    return ((Double)AllConfigs.SERVER.kinetics.mediumSpeed.get()).floatValue();
                }
            }
            return 0.0f;
        }

        public static Component getFormattedSpeedText(float speed, boolean overstressed) {
            SpeedLevel speedLevel = SpeedLevel.of(speed);
            TextComponent level = new TextComponent(ItemDescription.makeProgressBar(3, speedLevel.ordinal()));
            if (speedLevel == MEDIUM) {
                level.m_7220_((Component)Lang.translate("tooltip.speedRequirement.medium", new Object[0]));
            }
            if (speedLevel == FAST) {
                level.m_7220_((Component)Lang.translate("tooltip.speedRequirement.high", new Object[0]));
            }
            level.m_130946_(" (" + IHaveGoggleInformation.format(Math.abs(speed))).m_7220_((Component)Lang.translate("generic.unit.rpm", new Object[0])).m_130946_(") ");
            if (overstressed) {
                level.m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.STRIKETHROUGH});
            } else {
                level.m_130940_(speedLevel.getTextColor());
            }
            return level;
        }
    }

    public static enum StressImpact {
        LOW,
        MEDIUM,
        HIGH,
        OVERSTRESSED;


        public ChatFormatting getAbsoluteColor() {
            return this == LOW ? ChatFormatting.YELLOW : (this == MEDIUM ? ChatFormatting.GOLD : ChatFormatting.RED);
        }

        public ChatFormatting getRelativeColor() {
            return this == LOW ? ChatFormatting.GREEN : (this == MEDIUM ? ChatFormatting.YELLOW : (this == HIGH ? ChatFormatting.GOLD : ChatFormatting.RED));
        }

        public static StressImpact of(double stressPercent) {
            if (stressPercent > 1.0) {
                return OVERSTRESSED;
            }
            if (stressPercent > 0.75) {
                return HIGH;
            }
            if (stressPercent > 0.5) {
                return MEDIUM;
            }
            return LOW;
        }

        public static boolean isEnabled() {
            return (Boolean)AllConfigs.SERVER.kinetics.disableStress.get() == false;
        }

        public static Component getFormattedStressText(double stressPercent) {
            StressImpact stressLevel = StressImpact.of(stressPercent);
            ChatFormatting color = stressLevel.getRelativeColor();
            TextComponent level = new TextComponent(ItemDescription.makeProgressBar(3, Math.min(stressLevel.ordinal(), 2)));
            level.m_7220_((Component)Lang.translate("tooltip.stressImpact." + Lang.asId(stressLevel.name()), new Object[0]));
            level.m_130946_(String.format(" (%s%%) ", (int)(stressPercent * 100.0)));
            return level.m_130940_(color);
        }
    }
}

