/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.actors;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.material.MaterialManager;
import com.simibubi.create.content.contraptions.components.actors.HarvesterActorInstance;
import com.simibubi.create.content.contraptions.components.actors.HarvesterBlock;
import com.simibubi.create.content.contraptions.components.actors.HarvesterRenderer;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ActorInstance;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionMatrices;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.worldWrappers.PlacementSimulationWorld;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.GrowingPlantBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.IPlantable;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class HarvesterMovementBehaviour
extends MovementBehaviour {
    @Override
    public boolean isActive(MovementContext context) {
        return !VecHelper.isVecPointingTowards(context.relativeMotion, ((Direction)context.state.m_61143_((Property)HarvesterBlock.f_54117_)).m_122424_());
    }

    @Override
    public boolean hasSpecialInstancedRendering() {
        return true;
    }

    @Override
    @Nullable
    public ActorInstance createInstance(MaterialManager materialManager, PlacementSimulationWorld simulationWorld, MovementContext context) {
        return new HarvesterActorInstance(materialManager, simulationWorld, context);
    }

    @Override
    public void renderInContraption(MovementContext context, PlacementSimulationWorld renderWorld, ContraptionMatrices matrices, MultiBufferSource buffers) {
        if (!Backend.getInstance().canUseInstancing()) {
            HarvesterRenderer.renderInContraption(context, renderWorld, matrices, buffers);
        }
    }

    @Override
    public Vec3 getActiveAreaOffset(MovementContext context) {
        return Vec3.m_82528_((Vec3i)((Direction)context.state.m_61143_((Property)HarvesterBlock.f_54117_)).m_122436_()).m_82490_(0.45);
    }

    @Override
    public void visitNewPosition(MovementContext context, BlockPos pos) {
        Level world = context.world;
        BlockState stateVisited = world.m_8055_(pos);
        boolean notCropButCuttable = false;
        if (world.f_46443_) {
            return;
        }
        if (!this.isValidCrop(world, pos, stateVisited)) {
            if (this.isValidOther(world, pos, stateVisited)) {
                notCropButCuttable = true;
            } else {
                return;
            }
        }
        ItemStack item = ItemStack.f_41583_;
        float effectChance = 1.0f;
        if (stateVisited.m_60620_((Tag)BlockTags.f_13035_)) {
            item = new ItemStack((ItemLike)Items.f_42574_);
            effectChance = 0.45f;
        }
        MutableBoolean seedSubtracted = new MutableBoolean(notCropButCuttable);
        BlockState state = stateVisited;
        BlockHelper.destroyBlockAs(world, pos, null, item, effectChance, stack -> {
            if (((Boolean)AllConfigs.SERVER.kinetics.harvesterReplants.get()).booleanValue() && !seedSubtracted.getValue().booleanValue() && stack.m_41656_(new ItemStack((ItemLike)state.m_60734_()))) {
                stack.m_41774_(1);
                seedSubtracted.setTrue();
            }
            this.dropItem(context, (ItemStack)stack);
        });
        world.m_46597_(pos, this.cutCrop(world, pos, stateVisited));
    }

    private boolean isValidCrop(Level world, BlockPos pos, BlockState state) {
        boolean harvestPartial = (Boolean)AllConfigs.SERVER.kinetics.harvestPartiallyGrown.get();
        boolean replant = (Boolean)AllConfigs.SERVER.kinetics.harvesterReplants.get();
        if (state.m_60734_() instanceof CropBlock) {
            CropBlock crop = (CropBlock)state.m_60734_();
            if (harvestPartial) {
                return (Integer)state.m_61143_((Property)crop.m_7959_()) != 0 || !replant;
            }
            return crop.m_52307_(state);
        }
        if (state.m_60812_((BlockGetter)world, pos).m_83281_() || state.m_60734_() instanceof CocoaBlock) {
            for (Property property : state.m_61147_()) {
                if (!(property instanceof IntegerProperty)) continue;
                IntegerProperty ageProperty = (IntegerProperty)property;
                if (!property.m_61708_().equals(BlockStateProperties.f_61405_.m_61708_())) continue;
                int age = (Integer)state.m_61143_((Property)ageProperty);
                if (state.m_60734_() instanceof SweetBerryBushBlock && age <= 1 && replant || age == 0 && replant || !harvestPartial && ageProperty.m_6908_().size() - 1 != age) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isValidOther(Level world, BlockPos pos, BlockState state) {
        if (state.m_60734_() instanceof CropBlock) {
            return false;
        }
        if (state.m_60734_() instanceof SugarCaneBlock) {
            return true;
        }
        if (state.m_60620_((Tag)BlockTags.f_13035_)) {
            return true;
        }
        if (state.m_60812_((BlockGetter)world, pos).m_83281_() || state.m_60734_() instanceof CocoaBlock) {
            if (state.m_60734_() instanceof GrowingPlantBlock) {
                return true;
            }
            for (Property property : state.m_61147_()) {
                if (!(property instanceof IntegerProperty) || !property.m_61708_().equals(BlockStateProperties.f_61405_.m_61708_())) continue;
                return false;
            }
            if (state.m_60734_() instanceof IPlantable) {
                return true;
            }
        }
        return false;
    }

    private BlockState cutCrop(Level world, BlockPos pos, BlockState state) {
        if (!((Boolean)AllConfigs.SERVER.kinetics.harvesterReplants.get()).booleanValue()) {
            if (state.m_60819_().m_76178_()) {
                return Blocks.f_50016_.m_49966_();
            }
            return state.m_60819_().m_76188_();
        }
        Block block = state.m_60734_();
        if (block instanceof CropBlock) {
            CropBlock crop = (CropBlock)block;
            return crop.m_52289_(0);
        }
        if (block == Blocks.f_50685_) {
            return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61407_, (Comparable)Integer.valueOf(1));
        }
        if (block == Blocks.f_50130_ || block instanceof GrowingPlantBlock) {
            if (state.m_60819_().m_76178_()) {
                return Blocks.f_50016_.m_49966_();
            }
            return state.m_60819_().m_76188_();
        }
        if (state.m_60812_((BlockGetter)world, pos).m_83281_() || block instanceof CocoaBlock) {
            for (Property property : state.m_61147_()) {
                if (!(property instanceof IntegerProperty) || !property.m_61708_().equals(BlockStateProperties.f_61405_.m_61708_())) continue;
                return (BlockState)state.m_61124_((Property)((IntegerProperty)property), (Comparable)Integer.valueOf(0));
            }
        }
        if (state.m_60819_().m_76178_()) {
            return Blocks.f_50016_.m_49966_();
        }
        return state.m_60819_().m_76188_();
    }
}

