/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.crank;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.base.GeneratingKineticTileEntity;
import com.simibubi.create.content.contraptions.components.crank.HandCrankBlock;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class HandCrankTileEntity
extends GeneratingKineticTileEntity {
    public int inUse;
    public boolean backwards;
    public float independentAngle;
    public float chasingVelocity;

    public HandCrankTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void turn(boolean back) {
        boolean update = false;
        if (this.getGeneratedSpeed() == 0.0f || back != this.backwards) {
            update = true;
        }
        this.inUse = 10;
        this.backwards = back;
        if (update && !this.f_58857_.f_46443_) {
            this.updateGeneratedRotation();
        }
    }

    @Override
    public float getGeneratedSpeed() {
        Block block = this.m_58900_().m_60734_();
        if (!(block instanceof HandCrankBlock)) {
            return 0.0f;
        }
        HandCrankBlock crank = (HandCrankBlock)block;
        int speed = (this.inUse == 0 ? 0 : (this.backwards ? -1 : 1)) * crank.getRotationSpeed();
        return HandCrankTileEntity.convertToDirection(speed, (Direction)this.m_58900_().m_61143_((Property)HandCrankBlock.FACING));
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128405_("InUse", this.inUse);
        super.write(compound, clientPacket);
    }

    @Override
    protected void fromTag(CompoundTag compound, boolean clientPacket) {
        this.inUse = compound.m_128451_("InUse");
        super.fromTag(compound, clientPacket);
    }

    @Override
    public void tick() {
        super.tick();
        float actualSpeed = this.getSpeed();
        this.chasingVelocity += (actualSpeed * 10.0f / 3.0f - this.chasingVelocity) * 0.25f;
        this.independentAngle += this.chasingVelocity;
        if (this.inUse > 0) {
            --this.inUse;
            if (this.inUse == 0 && !this.f_58857_.f_46443_) {
                this.updateGeneratedRotation();
            }
        }
    }

    @Override
    protected Block getStressConfigKey() {
        return (Block)AllBlocks.HAND_CRANK.get();
    }

    public boolean shouldRenderNormally() {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void tickAudio() {
        super.tickAudio();
        if (this.inUse > 0 && AnimationTickHolder.getTicks() % 10 == 0) {
            if (!AllBlocks.HAND_CRANK.has(this.m_58900_())) {
                return;
            }
            AllSoundEvents.CRANKING.playAt(this.f_58857_, (Vec3i)this.f_58858_, (float)this.inUse / 2.5f, 0.65f + (float)(10 - this.inUse) / 10.0f, true);
        }
    }
}

