/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.crusher;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.components.crusher.CrushingWheelControllerTileEntity;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.IItemHandler;

public class CrushingWheelControllerBlock
extends DirectionalBlock
implements ITE<CrushingWheelControllerTileEntity> {
    public static final BooleanProperty VALID = BooleanProperty.m_61465_((String)"valid");

    public CrushingWheelControllerBlock(BlockBehaviour.Properties p_i48440_1_) {
        super(p_i48440_1_);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        return false;
    }

    public boolean addRunningEffects(BlockState state, Level world, BlockPos pos, Entity entity) {
        return true;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{VALID});
        builder.m_61104_(new Property[]{f_52588_});
        super.m_7926_(builder);
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        if (!((Boolean)state.m_61143_((Property)VALID)).booleanValue()) {
            return;
        }
        Direction facing = (Direction)state.m_61143_((Property)f_52588_);
        Direction.Axis axis = facing.m_122434_();
        this.checkEntityForProcessing(worldIn, pos, entityIn);
        this.withTileEntityDo((BlockGetter)worldIn, pos, te -> {
            if (te.processingEntity == entityIn) {
                entityIn.m_7601_(state, new Vec3(axis == Direction.Axis.X ? (double)0.05f : 0.25, axis == Direction.Axis.Y ? (double)0.05f : 0.25, axis == Direction.Axis.Z ? (double)0.05f : 0.25));
            }
        });
    }

    public void checkEntityForProcessing(Level worldIn, BlockPos pos, Entity entityIn) {
        CompoundTag data;
        CrushingWheelControllerTileEntity te = (CrushingWheelControllerTileEntity)this.getTileEntity((BlockGetter)worldIn, pos);
        if (te == null) {
            return;
        }
        if (te.crushingspeed == 0.0f) {
            return;
        }
        if (entityIn instanceof ItemEntity) {
            ((ItemEntity)entityIn).m_32010_(10);
        }
        if ((data = entityIn.getPersistentData()).m_128441_("BypassCrushingWheel") && pos.equals((Object)NbtUtils.m_129239_((CompoundTag)data.m_128469_("BypassCrushingWheel")))) {
            return;
        }
        if (te.isOccupied()) {
            return;
        }
        boolean isPlayer = entityIn instanceof Player;
        if (isPlayer && ((Player)entityIn).m_7500_()) {
            return;
        }
        if (isPlayer && entityIn.f_19853_.m_46791_() == Difficulty.PEACEFUL) {
            return;
        }
        te.startCrushing(entityIn);
    }

    public void m_5548_(BlockGetter worldIn, Entity entityIn) {
        super.m_5548_(worldIn, entityIn);
    }

    public void m_7100_(BlockState stateIn, Level worldIn, BlockPos pos, Random rand) {
        if (!((Boolean)stateIn.m_61143_((Property)VALID)).booleanValue()) {
            return;
        }
        if (rand.nextInt(1) != 0) {
            return;
        }
        double d0 = (float)pos.m_123341_() + rand.nextFloat();
        double d1 = (float)pos.m_123342_() + rand.nextFloat();
        double d2 = (float)pos.m_123343_() + rand.nextFloat();
        worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123797_, d0, d1, d2, 0.0, 0.0, 0.0);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        this.updateSpeed(stateIn, worldIn, currentPos);
        return stateIn;
    }

    public void updateSpeed(BlockState state, LevelAccessor world, BlockPos pos) {
        this.withTileEntityDo((BlockGetter)world, pos, te -> {
            if (!((Boolean)state.m_61143_((Property)VALID)).booleanValue()) {
                if (te.crushingspeed != 0.0f) {
                    te.crushingspeed = 0.0f;
                    te.sendData();
                }
                return;
            }
            for (Direction d : Iterate.directions) {
                BlockEntity adjTe;
                BlockState neighbour = world.m_8055_(pos.m_142300_(d));
                if (!AllBlocks.CRUSHING_WHEEL.has(neighbour) || neighbour.m_61143_((Property)BlockStateProperties.f_61365_) == d.m_122434_() || !((adjTe = world.m_7702_(pos.m_142300_(d))) instanceof KineticTileEntity)) continue;
                te.crushingspeed = Math.abs(((KineticTileEntity)adjTe).getSpeed() / 50.0f);
                te.sendData();
                break;
            }
        });
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        VoxelShape standardShape = AllShapes.CRUSHING_WHEEL_CONTROLLER_COLLISION.get((Direction)state.m_61143_((Property)f_52588_));
        if (!((Boolean)state.m_61143_((Property)VALID)).booleanValue()) {
            return standardShape;
        }
        if (!(context instanceof EntityCollisionContext)) {
            return standardShape;
        }
        Entity entity = ((EntityCollisionContext)context).m_166012_().orElse(null);
        if (entity == null) {
            return standardShape;
        }
        CompoundTag data = entity.getPersistentData();
        if (data.m_128441_("BypassCrushingWheel") && pos.equals((Object)NbtUtils.m_129239_((CompoundTag)data.m_128469_("BypassCrushingWheel"))) && state.m_61143_((Property)f_52588_) != Direction.UP) {
            return Shapes.m_83040_();
        }
        CrushingWheelControllerTileEntity te = (CrushingWheelControllerTileEntity)this.getTileEntity(worldIn, pos);
        if (te != null && te.processingEntity == entity) {
            return Shapes.m_83040_();
        }
        return standardShape;
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_155947_() || state.m_60734_() == newState.m_60734_()) {
            return;
        }
        this.withTileEntityDo((BlockGetter)worldIn, pos, te -> ItemHelper.dropContents(worldIn, pos, (IItemHandler)te.inventory));
        worldIn.m_46747_(pos);
    }

    @Override
    public Class<CrushingWheelControllerTileEntity> getTileEntityClass() {
        return CrushingWheelControllerTileEntity.class;
    }

    @Override
    public BlockEntityType<? extends CrushingWheelControllerTileEntity> getTileEntityType() {
        return (BlockEntityType)AllTileEntities.CRUSHING_WHEEL_CONTROLLER.get();
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }
}

