/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.deployer;

import com.jozufozu.flywheel.backend.material.Material;
import com.jozufozu.flywheel.backend.material.MaterialManager;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.jozufozu.flywheel.util.transform.MatrixTransformStack;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.DirectionalAxisKineticBlock;
import com.simibubi.create.content.contraptions.base.DirectionalKineticBlock;
import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.base.KineticTileInstance;
import com.simibubi.create.content.contraptions.base.flwdata.RotatingData;
import com.simibubi.create.content.contraptions.components.deployer.DeployerRenderer;
import com.simibubi.create.content.contraptions.components.deployer.DeployerTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ActorInstance;
import com.simibubi.create.foundation.render.AllMaterialSpecs;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.worldWrappers.PlacementSimulationWorld;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class DeployerActorInstance
extends ActorInstance {
    private final MatrixTransformStack stack = new MatrixTransformStack();
    Direction facing;
    boolean stationaryTimer;
    float yRot;
    float xRot;
    float zRot;
    ModelData pole;
    ModelData hand;
    RotatingData shaft;

    public DeployerActorInstance(MaterialManager materialManager, PlacementSimulationWorld simulationWorld, MovementContext context) {
        super(materialManager, simulationWorld, context);
        Material mat = materialManager.defaultSolid().material(Materials.TRANSFORMED);
        BlockState state = context.state;
        DeployerTileEntity.Mode mode = NBTHelper.readEnum(context.tileData, "Mode", DeployerTileEntity.Mode.class);
        PartialModel handPose = DeployerRenderer.getHandPose(mode);
        this.stationaryTimer = context.data.m_128441_("StationaryTimer");
        this.facing = (Direction)state.m_61143_((Property)DirectionalKineticBlock.FACING);
        boolean rotatePole = (Boolean)state.m_61143_((Property)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE) ^ this.facing.m_122434_() == Direction.Axis.Z;
        this.yRot = AngleHelper.horizontalAngle(this.facing);
        this.xRot = this.facing == Direction.UP ? 270.0f : (this.facing == Direction.DOWN ? 90.0f : 0.0f);
        this.zRot = rotatePole ? 90.0f : 0.0f;
        this.pole = (ModelData)mat.getModel(AllBlockPartials.DEPLOYER_POLE, state).createInstance();
        this.hand = (ModelData)mat.getModel(handPose, state).createInstance();
        Direction.Axis axis = ((IRotate)state.m_60734_()).getRotationAxis(state);
        this.shaft = (RotatingData)materialManager.defaultSolid().material(AllMaterialSpecs.ROTATING).getModel(KineticTileInstance.shaft(axis)).createInstance();
        int blockLight = this.localBlockLight();
        this.shaft.setRotationAxis(axis).setPosition(context.localPos).setBlockLight(blockLight);
        this.pole.setBlockLight(blockLight);
        this.hand.setBlockLight(blockLight);
    }

    @Override
    public void beginFrame() {
        double factor;
        if (this.context.contraption.stalled || this.context.position == null || this.context.data.m_128441_("StationaryTimer")) {
            factor = Mth.m_14031_((float)(AnimationTickHolder.getRenderTime() * 0.5f)) * 0.25f + 0.25f;
        } else {
            Vec3 center = VecHelper.getCenterOf((Vec3i)new BlockPos(this.context.position));
            double distance = this.context.position.m_82554_(center);
            double nextDistance = this.context.position.m_82549_(this.context.motion).m_82554_(center);
            factor = 0.5 - Mth.m_14008_((double)Mth.m_14139_((double)AnimationTickHolder.getPartialTicks(), (double)distance, (double)nextDistance), (double)0.0, (double)1.0);
        }
        Vec3 offset = Vec3.m_82528_((Vec3i)this.facing.m_122436_()).m_82490_(factor);
        ((TransformStack)this.stack.setIdentity().translate((Vec3i)this.context.localPos)).translate(offset);
        DeployerActorInstance.transformModel(this.stack, this.pole, this.hand, this.yRot, this.xRot, this.zRot);
    }

    static void transformModel(MatrixTransformStack msr, ModelData pole, ModelData hand, float yRot, float xRot, float zRot) {
        msr.centre();
        msr.rotate(Direction.UP, (float)((double)(yRot / 180.0f) * Math.PI));
        msr.rotate(Direction.EAST, (float)((double)(xRot / 180.0f) * Math.PI));
        msr.pushPose();
        msr.rotate(Direction.SOUTH, (float)((double)(zRot / 180.0f) * Math.PI));
        msr.unCentre();
        pole.setTransform(msr.unwrap());
        msr.popPose();
        msr.unCentre();
        hand.setTransform(msr.unwrap());
    }
}

