/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.deployer;

import com.google.gson.JsonObject;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.AllTags;
import com.simibubi.create.compat.jei.category.sequencedAssembly.SequencedAssemblySubCategory;
import com.simibubi.create.content.contraptions.itemAssembly.IAssemblyRecipe;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipe;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class DeployerApplicationRecipe
extends ProcessingRecipe<RecipeWrapper>
implements IAssemblyRecipe {
    private boolean keepHeldItem;

    public DeployerApplicationRecipe(ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        super(AllRecipeTypes.DEPLOYING, params);
        this.keepHeldItem = params.keepHeldItem;
    }

    public boolean matches(RecipeWrapper inv, Level p_77569_2_) {
        return ((Ingredient)this.ingredients.get(0)).test(inv.m_8020_(0)) && ((Ingredient)this.ingredients.get(1)).test(inv.m_8020_(1));
    }

    @Override
    protected int getMaxInputCount() {
        return 2;
    }

    @Override
    protected int getMaxOutputCount() {
        return 2;
    }

    public boolean shouldKeepHeldItem() {
        return this.keepHeldItem;
    }

    public Ingredient getRequiredHeldItem() {
        if (this.ingredients.isEmpty()) {
            throw new IllegalStateException("Deploying Recipe: " + this.id.toString() + " has no tool!");
        }
        return (Ingredient)this.ingredients.get(1);
    }

    public Ingredient getProcessedItem() {
        if (this.ingredients.size() < 2) {
            throw new IllegalStateException("Deploying Recipe: " + this.id.toString() + " has no ingredient!");
        }
        return (Ingredient)this.ingredients.get(0);
    }

    public static List<DeployerApplicationRecipe> convert(List<Recipe<?>> sandpaperRecipes) {
        return sandpaperRecipes.stream().map(r -> new ProcessingRecipeBuilder<DeployerApplicationRecipe>(DeployerApplicationRecipe::new, new ResourceLocation(r.m_6423_().m_135827_(), r.m_6423_().m_135815_() + "_using_deployer")).require((Ingredient)r.m_7527_().get(0)).require(AllTags.AllItemTags.SANDPAPER.tag).output(r.m_8043_()).build()).collect(Collectors.toList());
    }

    @Override
    public void addAssemblyIngredients(List<Ingredient> list) {
        list.add((Ingredient)this.ingredients.get(1));
    }

    @Override
    public void readAdditional(JsonObject json) {
        super.readAdditional(json);
        this.keepHeldItem = GsonHelper.m_13855_((JsonObject)json, (String)"keepHeldItem", (boolean)false);
    }

    @Override
    public void writeAdditional(JsonObject json) {
        super.writeAdditional(json);
        if (this.keepHeldItem) {
            json.addProperty("keepHeldItem", Boolean.valueOf(this.keepHeldItem));
        }
    }

    @Override
    public void readAdditional(FriendlyByteBuf buffer) {
        super.readAdditional(buffer);
        this.keepHeldItem = buffer.readBoolean();
    }

    @Override
    public void writeAdditional(FriendlyByteBuf buffer) {
        super.writeAdditional(buffer);
        buffer.writeBoolean(this.keepHeldItem);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Component getDescriptionForAssembly() {
        ItemStack[] matchingStacks = ((Ingredient)this.ingredients.get(1)).m_43908_();
        if (matchingStacks.length == 0) {
            return new TextComponent("Invalid");
        }
        return Lang.translate("recipe.assembly.deploying_item", new TranslatableComponent(matchingStacks[0].m_41778_()).getString());
    }

    @Override
    public void addRequiredMachines(Set<ItemLike> list) {
        list.add((ItemLike)AllBlocks.DEPLOYER.get());
    }

    @Override
    public Supplier<Supplier<SequencedAssemblySubCategory>> getJEISubCategory() {
        return () -> SequencedAssemblySubCategory.AssemblyDeploying::new;
    }
}

