/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.deployer;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.material.MaterialManager;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.contraptions.components.deployer.DeployerActorInstance;
import com.simibubi.create.content.contraptions.components.deployer.DeployerBlock;
import com.simibubi.create.content.contraptions.components.deployer.DeployerFakePlayer;
import com.simibubi.create.content.contraptions.components.deployer.DeployerHandler;
import com.simibubi.create.content.contraptions.components.deployer.DeployerRenderer;
import com.simibubi.create.content.contraptions.components.deployer.DeployerTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ActorInstance;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionMatrices;
import com.simibubi.create.content.logistics.item.filter.FilterItem;
import com.simibubi.create.content.schematics.ItemRequirement;
import com.simibubi.create.content.schematics.SchematicWorld;
import com.simibubi.create.content.schematics.filtering.SchematicInstances;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.NBTProcessors;
import com.simibubi.create.foundation.utility.worldWrappers.PlacementSimulationWorld;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class DeployerMovementBehaviour
extends MovementBehaviour {
    @Override
    public Vec3 getActiveAreaOffset(MovementContext context) {
        return Vec3.m_82528_((Vec3i)((Direction)context.state.m_61143_((Property)DeployerBlock.FACING)).m_122436_()).m_82490_(2.0);
    }

    @Override
    public void visitNewPosition(MovementContext context, BlockPos pos) {
        if (context.world.f_46443_) {
            return;
        }
        this.tryGrabbingItem(context);
        DeployerFakePlayer player = this.getPlayer(context);
        DeployerTileEntity.Mode mode = this.getMode(context);
        if (mode == DeployerTileEntity.Mode.USE && !DeployerHandler.shouldActivate(player.m_21205_(), context.world, pos, null)) {
            return;
        }
        this.activate(context, pos, player, mode);
        this.tryDisposeOfExcess(context);
        context.stall = player.blockBreakingProgress != null;
    }

    public void activate(MovementContext context, BlockPos pos, DeployerFakePlayer player, DeployerTileEntity.Mode mode) {
        Level world = context.world;
        ItemStack filter = this.getFilter(context);
        if (AllItems.SCHEMATIC.isIn(filter)) {
            this.activateAsSchematicPrinter(context, pos, player, world, filter);
        }
        Vec3 facingVec = Vec3.m_82528_((Vec3i)((Direction)context.state.m_61143_((Property)DeployerBlock.FACING)).m_122436_());
        facingVec = (Vec3)context.rotation.apply(facingVec);
        Vec3 vec = context.position.m_82546_(facingVec.m_82490_(2.0));
        player.m_146922_(AbstractContraptionEntity.yawFromVector(facingVec));
        player.m_146926_(AbstractContraptionEntity.pitchFromVector(facingVec) - 90.0f);
        DeployerHandler.activate(player, vec, pos, facingVec, mode);
    }

    protected void activateAsSchematicPrinter(MovementContext context, BlockPos pos, DeployerFakePlayer player, Level world, ItemStack filter) {
        BlockEntity tile;
        ItemStack firstRequired;
        if (!filter.m_41782_()) {
            return;
        }
        if (!world.m_8055_(pos).m_60767_().m_76336_()) {
            return;
        }
        CompoundTag tag = filter.m_41783_();
        if (!tag.m_128471_("Deployed")) {
            return;
        }
        SchematicWorld schematicWorld = SchematicInstances.get(world, filter);
        if (schematicWorld == null) {
            return;
        }
        if (!schematicWorld.getBounds().m_71051_((Vec3i)pos.m_141950_((Vec3i)schematicWorld.anchor))) {
            return;
        }
        BlockState blockState = schematicWorld.m_8055_(pos);
        ItemRequirement requirement = ItemRequirement.of(blockState, schematicWorld.m_7702_(pos));
        if (requirement.isInvalid() || requirement.isEmpty()) {
            return;
        }
        if (AllBlocks.BELT.has(blockState)) {
            return;
        }
        List<ItemRequirement.StackRequirement> requiredItems = requirement.getRequiredItems();
        ItemStack itemStack = firstRequired = requiredItems.isEmpty() ? ItemStack.f_41583_ : requiredItems.get((int)0).item;
        if (!context.contraption.hasUniversalCreativeCrate) {
            Contraption.ContraptionInvWrapper iItemHandler = context.contraption.inventory;
            for (ItemRequirement.StackRequirement required : requiredItems) {
                int amountFound = ItemHelper.extract((IItemHandler)iItemHandler, s -> ItemRequirement.validate(required.item, s), ItemHelper.ExtractionCountMode.UPTO, required.item.m_41613_(), true).m_41613_();
                if (amountFound >= required.item.m_41613_()) continue;
                return;
            }
            for (ItemRequirement.StackRequirement required : requiredItems) {
                ItemHelper.extract((IItemHandler)iItemHandler, s -> ItemRequirement.validate(required.item, s), ItemHelper.ExtractionCountMode.UPTO, required.item.m_41613_(), false);
            }
        }
        CompoundTag data = null;
        if (AllTags.AllBlockTags.SAFE_NBT.matches(blockState) && (tile = schematicWorld.m_7702_(pos)) != null) {
            data = tile.m_6945_(new CompoundTag());
            data = NBTProcessors.process(tile, data, true);
        }
        BlockSnapshot blocksnapshot = BlockSnapshot.create((ResourceKey)world.m_46472_(), (LevelAccessor)world, (BlockPos)pos);
        BlockHelper.placeSchematicBlock(world, blockState, pos, firstRequired, data);
        if (ForgeEventFactory.onBlockPlace((Entity)player, (BlockSnapshot)blocksnapshot, (Direction)Direction.UP)) {
            blocksnapshot.restore(true, false);
        }
    }

    @Override
    public void tick(MovementContext context) {
        if (context.world.f_46443_) {
            return;
        }
        if (!context.stall) {
            return;
        }
        DeployerFakePlayer player = this.getPlayer(context);
        DeployerTileEntity.Mode mode = this.getMode(context);
        Pair<BlockPos, Float> blockBreakingProgress = player.blockBreakingProgress;
        if (blockBreakingProgress != null) {
            int timer = context.data.m_128451_("Timer");
            if (timer < 20) {
                context.data.m_128405_("Timer", ++timer);
                return;
            }
            context.data.m_128473_("Timer");
            this.activate(context, (BlockPos)blockBreakingProgress.getKey(), player, mode);
            this.tryDisposeOfExcess(context);
        }
        context.stall = player.blockBreakingProgress != null;
    }

    @Override
    public void stopMoving(MovementContext context) {
        if (context.world.f_46443_) {
            return;
        }
        DeployerFakePlayer player = this.getPlayer(context);
        if (player == null) {
            return;
        }
        context.tileData.m_128365_("Inventory", (Tag)player.m_150109_().m_36026_(new ListTag()));
        player.m_146870_();
    }

    private void tryGrabbingItem(MovementContext context) {
        DeployerFakePlayer player = this.getPlayer(context);
        if (player == null) {
            return;
        }
        if (player.m_21205_().m_41619_()) {
            ItemStack filter = this.getFilter(context);
            if (AllItems.SCHEMATIC.isIn(filter)) {
                return;
            }
            ItemStack held = ItemHelper.extract((IItemHandler)context.contraption.inventory, stack -> FilterItem.test(context.world, stack, filter), 1, false);
            player.m_21008_(InteractionHand.MAIN_HAND, held);
        }
    }

    private void tryDisposeOfExcess(MovementContext context) {
        DeployerFakePlayer player = this.getPlayer(context);
        if (player == null) {
            return;
        }
        Inventory inv = player.m_150109_();
        ItemStack filter = this.getFilter(context);
        for (List list : Arrays.asList(inv.f_35975_, inv.f_35976_, inv.f_35974_)) {
            for (int i = 0; i < list.size(); ++i) {
                ItemStack itemstack = (ItemStack)list.get(i);
                if (itemstack.m_41619_() || list == inv.f_35974_ && i == inv.f_35977_ && FilterItem.test(context.world, itemstack, filter)) continue;
                this.dropItem(context, itemstack);
                list.set(i, ItemStack.f_41583_);
            }
        }
    }

    @Override
    public void writeExtraData(MovementContext context) {
        DeployerFakePlayer player = this.getPlayer(context);
        if (player == null) {
            return;
        }
        context.data.m_128365_("HeldItem", (Tag)player.m_21205_().serializeNBT());
    }

    private DeployerFakePlayer getPlayer(MovementContext context) {
        if (!(context.temporaryData instanceof DeployerFakePlayer) && context.world instanceof ServerLevel) {
            DeployerFakePlayer deployerFakePlayer = new DeployerFakePlayer((ServerLevel)context.world);
            deployerFakePlayer.m_150109_().m_36035_(context.tileData.m_128437_("Inventory", 10));
            if (context.data.m_128441_("HeldItem")) {
                deployerFakePlayer.m_21008_(InteractionHand.MAIN_HAND, ItemStack.m_41712_((CompoundTag)context.data.m_128469_("HeldItem")));
            }
            context.tileData.m_128473_("Inventory");
            context.temporaryData = deployerFakePlayer;
        }
        return (DeployerFakePlayer)((Object)context.temporaryData);
    }

    private ItemStack getFilter(MovementContext context) {
        return ItemStack.m_41712_((CompoundTag)context.tileData.m_128469_("Filter"));
    }

    private DeployerTileEntity.Mode getMode(MovementContext context) {
        return NBTHelper.readEnum(context.tileData, "Mode", DeployerTileEntity.Mode.class);
    }

    @Override
    public void renderInContraption(MovementContext context, PlacementSimulationWorld renderWorld, ContraptionMatrices matrices, MultiBufferSource buffers) {
        if (!Backend.getInstance().canUseInstancing()) {
            DeployerRenderer.renderInContraption(context, renderWorld, matrices, buffers);
        }
    }

    @Override
    public boolean hasSpecialInstancedRendering() {
        return true;
    }

    @Override
    @Nullable
    public ActorInstance createInstance(MaterialManager materialManager, PlacementSimulationWorld simulationWorld, MovementContext context) {
        return new DeployerActorInstance(materialManager, simulationWorld, context);
    }
}

