/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.deployer;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.util.transform.MatrixTransformStack;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.base.DirectionalAxisKineticBlock;
import com.simibubi.create.content.contraptions.base.DirectionalKineticBlock;
import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.content.contraptions.components.deployer.DeployerTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionMatrices;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionRenderDispatcher;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringRenderer;
import com.simibubi.create.foundation.tileEntity.renderer.SafeTileEntityRenderer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.worldWrappers.PlacementSimulationWorld;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class DeployerRenderer
extends SafeTileEntityRenderer<DeployerTileEntity> {
    public DeployerRenderer(BlockEntityRendererProvider.Context context) {
    }

    @Override
    protected void renderSafe(DeployerTileEntity te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        this.renderItem(te, partialTicks, ms, buffer, light, overlay);
        FilteringRenderer.renderOnTileEntity(te, partialTicks, ms, buffer, light, overlay);
        if (Backend.getInstance().canUseInstancing(te.m_58904_())) {
            return;
        }
        this.renderComponents(te, partialTicks, ms, buffer, light, overlay);
    }

    protected void renderItem(DeployerTileEntity te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        boolean isBlockItem;
        if (te.heldItem.m_41619_()) {
            return;
        }
        BlockState deployerState = te.m_58900_();
        Vec3 offset = this.getHandOffset(te, partialTicks, deployerState).m_82549_(VecHelper.getCenterOf((Vec3i)BlockPos.f_121853_));
        ms.m_85836_();
        ms.m_85837_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
        Direction facing = (Direction)deployerState.m_61143_((Property)DirectionalKineticBlock.FACING);
        boolean punching = te.mode == DeployerTileEntity.Mode.PUNCH;
        float yRot = AngleHelper.horizontalAngle(facing) + 180.0f;
        float xRot = facing == Direction.UP ? 90.0f : (facing == Direction.DOWN ? 270.0f : 0.0f);
        boolean displayMode = facing == Direction.UP && te.getSpeed() == 0.0f && !punching;
        ms.m_85845_(Vector3f.f_122225_.m_122240_(yRot));
        if (!displayMode) {
            ms.m_85845_(Vector3f.f_122223_.m_122240_(xRot));
            ms.m_85837_(0.0, 0.0, -0.6875);
        }
        if (punching) {
            ms.m_85837_(0.0, 0.125, -0.0625);
        }
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        ItemTransforms.TransformType transform = ItemTransforms.TransformType.NONE;
        boolean bl = isBlockItem = te.heldItem.m_41720_() instanceof BlockItem && itemRenderer.m_174264_(te.heldItem, te.m_58904_(), null, 0).m_7539_();
        if (displayMode) {
            float scale = isBlockItem ? 1.25f : 1.0f;
            ms.m_85837_(0.0, isBlockItem ? 0.5625 : 0.6875, 0.0);
            ms.m_85841_(scale, scale, scale);
            transform = ItemTransforms.TransformType.GROUND;
            ms.m_85845_(Vector3f.f_122225_.m_122240_(AnimationTickHolder.getRenderTime((LevelAccessor)te.m_58904_())));
        } else {
            float scale = punching ? 0.75f : (isBlockItem ? 0.734375f : 0.5f);
            ms.m_85841_(scale, scale, scale);
            transform = punching ? ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND : ItemTransforms.TransformType.FIXED;
        }
        itemRenderer.m_174269_(te.heldItem, transform, light, overlay, ms, buffer, 0);
        ms.m_85849_();
    }

    protected void renderComponents(DeployerTileEntity te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        VertexConsumer vb = buffer.m_6299_(RenderType.m_110451_());
        if (!Backend.getInstance().canUseInstancing(te.m_58904_())) {
            KineticTileEntityRenderer.renderRotatingKineticBlock(te, this.getRenderedBlockState(te), ms, vb, light);
        }
        BlockState blockState = te.m_58900_();
        Vec3 offset = this.getHandOffset(te, partialTicks, blockState);
        SuperByteBuffer pole = CachedBufferer.partial(AllBlockPartials.DEPLOYER_POLE, blockState);
        SuperByteBuffer hand = CachedBufferer.partial(te.getHandPose(), blockState);
        DeployerRenderer.transform(pole.translate(offset.f_82479_, offset.f_82480_, offset.f_82481_), blockState, true).light(light).renderInto(ms, vb);
        DeployerRenderer.transform(hand.translate(offset.f_82479_, offset.f_82480_, offset.f_82481_), blockState, false).light(light).renderInto(ms, vb);
    }

    protected Vec3 getHandOffset(DeployerTileEntity te, float partialTicks, BlockState blockState) {
        float distance = te.getHandOffset(partialTicks);
        return Vec3.m_82528_((Vec3i)((Direction)blockState.m_61143_((Property)DirectionalKineticBlock.FACING)).m_122436_()).m_82490_((double)distance);
    }

    protected BlockState getRenderedBlockState(KineticTileEntity te) {
        return KineticTileEntityRenderer.shaft(KineticTileEntityRenderer.getRotationAxisOf(te));
    }

    private static SuperByteBuffer transform(SuperByteBuffer buffer, BlockState deployerState, boolean axisDirectionMatters) {
        float xRot;
        Direction facing = (Direction)deployerState.m_61143_((Property)DirectionalKineticBlock.FACING);
        float yRot = AngleHelper.horizontalAngle(facing);
        float f = facing == Direction.UP ? 270.0f : (xRot = facing == Direction.DOWN ? 90.0f : 0.0f);
        float zRot = axisDirectionMatters && (Boolean)deployerState.m_61143_((Property)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE) ^ facing.m_122434_() == Direction.Axis.Z ? 90.0f : 0.0f;
        buffer.rotateCentered(Direction.UP, (float)((double)(yRot / 180.0f) * Math.PI));
        buffer.rotateCentered(Direction.EAST, (float)((double)(xRot / 180.0f) * Math.PI));
        buffer.rotateCentered(Direction.SOUTH, (float)((double)(zRot / 180.0f) * Math.PI));
        return buffer;
    }

    public static void renderInContraption(MovementContext context, PlacementSimulationWorld renderWorld, ContraptionMatrices matrices, MultiBufferSource buffer) {
        double factor;
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110451_());
        BlockState blockState = context.state;
        DeployerTileEntity.Mode mode = NBTHelper.readEnum(context.tileData, "Mode", DeployerTileEntity.Mode.class);
        PartialModel handPose = DeployerRenderer.getHandPose(mode);
        float speed = context.getAnimationSpeed();
        if (context.contraption.stalled) {
            speed = 0.0f;
        }
        SuperByteBuffer shaft = CachedBufferer.block(AllBlocks.SHAFT.getDefaultState());
        SuperByteBuffer pole = CachedBufferer.partial(AllBlockPartials.DEPLOYER_POLE, blockState);
        SuperByteBuffer hand = CachedBufferer.partial(handPose, blockState);
        if (context.contraption.stalled || context.position == null || context.data.m_128441_("StationaryTimer")) {
            factor = Mth.m_14031_((float)(AnimationTickHolder.getRenderTime() * 0.5f)) * 0.25f + 0.25f;
        } else {
            Vec3 center = VecHelper.getCenterOf((Vec3i)new BlockPos(context.position));
            double distance = context.position.m_82554_(center);
            double nextDistance = context.position.m_82549_(context.motion).m_82554_(center);
            factor = 0.5 - Mth.m_14008_((double)Mth.m_14139_((double)AnimationTickHolder.getPartialTicks(), (double)distance, (double)nextDistance), (double)0.0, (double)1.0);
        }
        Vec3 offset = Vec3.m_82528_((Vec3i)((Direction)blockState.m_61143_((Property)DirectionalKineticBlock.FACING)).m_122436_()).m_82490_(factor);
        PoseStack m = matrices.getModel();
        m.m_85836_();
        m.m_85836_();
        Direction.Axis axis = Direction.Axis.Y;
        if (context.state.m_60734_() instanceof IRotate) {
            IRotate def = (IRotate)context.state.m_60734_();
            axis = def.getRotationAxis(context.state);
        }
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)context.world) / 20.0f;
        float angle = time * speed % 360.0f;
        ((TransformStack)((TransformStack)((TransformStack)new MatrixTransformStack(m).centre()).rotateY(axis == Direction.Axis.Z ? 90.0 : 0.0)).rotateZ(axis.m_122479_() ? 90.0 : 0.0)).unCentre();
        shaft.transform(m);
        shaft.rotateCentered(Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)Direction.Axis.Y), angle);
        m.m_85849_();
        m.m_85837_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
        pole.transform(m);
        hand.transform(m);
        DeployerRenderer.transform(pole, blockState, true);
        DeployerRenderer.transform(hand, blockState, false);
        shaft.light(matrices.getWorld(), ContraptionRenderDispatcher.getContraptionWorldLight(context, renderWorld)).renderInto(matrices.getViewProjection(), builder);
        pole.light(matrices.getWorld(), ContraptionRenderDispatcher.getContraptionWorldLight(context, renderWorld)).renderInto(matrices.getViewProjection(), builder);
        hand.light(matrices.getWorld(), ContraptionRenderDispatcher.getContraptionWorldLight(context, renderWorld)).renderInto(matrices.getViewProjection(), builder);
        m.m_85849_();
    }

    static PartialModel getHandPose(DeployerTileEntity.Mode mode) {
        return mode == DeployerTileEntity.Mode.PUNCH ? AllBlockPartials.DEPLOYER_HAND_PUNCHING : AllBlockPartials.DEPLOYER_HAND_POINTING;
    }
}

