/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.fan;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.contraptions.base.GeneratingKineticTileEntity;
import com.simibubi.create.content.contraptions.components.fan.AirCurrent;
import com.simibubi.create.content.contraptions.components.fan.EncasedFanBlock;
import com.simibubi.create.content.contraptions.components.fan.IAirCurrentSource;
import com.simibubi.create.content.contraptions.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.logistics.block.chute.ChuteTileEntity;
import com.simibubi.create.foundation.config.AllConfigs;
import javax.annotation.Nullable;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

@MethodsReturnNonnullByDefault
public class EncasedFanTileEntity
extends GeneratingKineticTileEntity
implements IAirCurrentSource {
    public AirCurrent airCurrent = new AirCurrent(this);
    protected int airCurrentUpdateCooldown;
    protected int entitySearchCooldown;
    protected boolean isGenerator = false;
    protected boolean updateAirFlow = true;
    protected boolean updateGenerator = false;

    public EncasedFanTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    protected void fromTag(CompoundTag compound, boolean clientPacket) {
        super.fromTag(compound, clientPacket);
        if (!this.wasMoved) {
            this.isGenerator = compound.m_128471_("Generating");
        }
        if (clientPacket) {
            this.airCurrent.rebuild();
        }
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128379_("Generating", this.isGenerator);
        super.write(compound, clientPacket);
    }

    @Override
    public float calculateAddedStressCapacity() {
        this.lastCapacityProvided = this.isGenerator ? super.calculateAddedStressCapacity() : 0.0f;
        return this.lastCapacityProvided;
    }

    @Override
    public float calculateStressApplied() {
        return this.isGenerator ? 0.0f : super.calculateStressApplied();
    }

    @Override
    public float getGeneratedSpeed() {
        return this.isGenerator ? (float)((Integer)AllConfigs.SERVER.kinetics.generatingFanSpeed.get()).intValue() : 0.0f;
    }

    public void queueGeneratorUpdate() {
        this.updateGenerator = true;
    }

    public void updateGenerator() {
        BlockState blockState = this.m_58900_();
        boolean shouldGenerate = true;
        if (!AllBlocks.ENCASED_FAN.has(blockState)) {
            shouldGenerate = false;
        }
        if (shouldGenerate && blockState.m_61143_((Property)EncasedFanBlock.FACING) != Direction.DOWN) {
            shouldGenerate = false;
        }
        if (shouldGenerate) {
            boolean bl = shouldGenerate = this.f_58857_ != null && this.f_58857_.m_46753_(this.f_58858_) && this.f_58857_.m_46749_(this.f_58858_.m_7495_()) && this.blockBelowIsHot();
        }
        if (shouldGenerate == this.isGenerator) {
            return;
        }
        this.isGenerator = shouldGenerate;
        this.updateGeneratedRotation();
    }

    public boolean blockBelowIsHot() {
        if (this.f_58857_ == null) {
            return false;
        }
        BlockState checkState = this.f_58857_.m_8055_(this.f_58858_.m_7495_());
        if (!checkState.m_60620_(AllTags.AllBlockTags.FAN_HEATERS.tag)) {
            return false;
        }
        if (checkState.m_61138_(BlazeBurnerBlock.HEAT_LEVEL) && !((BlazeBurnerBlock.HeatLevel)((Object)checkState.m_61143_(BlazeBurnerBlock.HEAT_LEVEL))).isAtLeast(BlazeBurnerBlock.HeatLevel.FADING)) {
            return false;
        }
        return !checkState.m_61138_((Property)BlockStateProperties.f_61443_) || (Boolean)checkState.m_61143_((Property)BlockStateProperties.f_61443_) != false;
    }

    @Override
    public AirCurrent getAirCurrent() {
        return this.airCurrent;
    }

    @Override
    @Nullable
    public Level getAirCurrentWorld() {
        return this.f_58857_;
    }

    @Override
    public BlockPos getAirCurrentPos() {
        return this.f_58858_;
    }

    @Override
    public Direction getAirflowOriginSide() {
        return (Direction)this.m_58900_().m_61143_((Property)EncasedFanBlock.FACING);
    }

    @Override
    public Direction getAirFlowDirection() {
        float speed = this.getSpeed();
        if (speed == 0.0f) {
            return null;
        }
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
        return (speed = EncasedFanTileEntity.convertToDirection(speed, facing)) > 0.0f ? facing : facing.m_122424_();
    }

    @Override
    public boolean isSourceRemoved() {
        return this.f_58859_;
    }

    @Override
    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        this.updateAirFlow = true;
        this.updateChute();
    }

    public void updateChute() {
        Direction direction = (Direction)this.m_58900_().m_61143_((Property)EncasedFanBlock.FACING);
        if (!direction.m_122434_().m_122478_()) {
            return;
        }
        BlockEntity poweredChute = this.f_58857_.m_7702_(this.f_58858_.m_142300_(direction));
        if (!(poweredChute instanceof ChuteTileEntity)) {
            return;
        }
        ChuteTileEntity chuteTE = (ChuteTileEntity)poweredChute;
        if (direction == Direction.DOWN) {
            chuteTE.updatePull();
        } else {
            chuteTE.updatePush(1);
        }
    }

    public void blockInFrontChanged() {
        this.updateAirFlow = true;
    }

    @Override
    public void tick() {
        boolean server;
        super.tick();
        boolean bl = server = !this.f_58857_.f_46443_ || this.isVirtual();
        if (server && this.airCurrentUpdateCooldown-- <= 0) {
            this.airCurrentUpdateCooldown = (Integer)AllConfigs.SERVER.kinetics.fanBlockCheckRate.get();
            this.updateAirFlow = true;
        }
        if (this.updateAirFlow) {
            this.updateAirFlow = false;
            this.airCurrent.rebuild();
            this.sendData();
        }
        if (this.updateGenerator) {
            this.updateGenerator = false;
            this.updateGenerator();
        }
        if (this.getSpeed() == 0.0f || this.isGenerator) {
            return;
        }
        if (this.entitySearchCooldown-- <= 0) {
            this.entitySearchCooldown = 5;
            this.airCurrent.findEntities();
        }
        this.airCurrent.tick();
    }
}

