/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.flywheel.engine;

import com.jozufozu.flywheel.backend.instancing.IInstanceRendered;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.components.flywheel.FlywheelBlock;
import com.simibubi.create.content.contraptions.components.flywheel.FlywheelTileEntity;
import com.simibubi.create.content.contraptions.components.flywheel.engine.EngineBlock;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EngineTileEntity
extends SmartTileEntity
implements IInstanceRendered {
    public float appliedCapacity;
    public float appliedSpeed;
    protected FlywheelTileEntity poweredWheel;
    protected AABB cachedBoundingBox;

    public EngineTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        if (this.cachedBoundingBox == null) {
            this.cachedBoundingBox = super.getRenderBoundingBox().m_82400_(1.5);
        }
        return this.cachedBoundingBox;
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.poweredWheel != null && this.poweredWheel.m_58901_()) {
            this.poweredWheel = null;
        }
        if (this.poweredWheel == null) {
            this.attachWheel();
        }
    }

    public void attachWheel() {
        Direction engineFacing = (Direction)this.m_58900_().m_61143_((Property)EngineBlock.f_54117_);
        BlockPos wheelPos = this.f_58858_.m_5484_(engineFacing, 2);
        BlockState wheelState = this.f_58857_.m_8055_(wheelPos);
        if (!AllBlocks.FLYWHEEL.has(wheelState)) {
            return;
        }
        Direction wheelFacing = (Direction)wheelState.m_61143_(FlywheelBlock.HORIZONTAL_FACING);
        if (wheelFacing.m_122434_() != engineFacing.m_122427_().m_122434_()) {
            return;
        }
        if (FlywheelBlock.isConnected(wheelState) && FlywheelBlock.getConnection(wheelState) != engineFacing.m_122424_()) {
            return;
        }
        BlockEntity te = this.f_58857_.m_7702_(wheelPos);
        if (te.m_58901_()) {
            return;
        }
        if (te instanceof FlywheelTileEntity) {
            if (!FlywheelBlock.isConnected(wheelState)) {
                FlywheelBlock.setConnection(this.f_58857_, te.m_58899_(), te.m_58900_(), engineFacing.m_122424_());
            }
            this.poweredWheel = (FlywheelTileEntity)te;
            this.refreshWheelSpeed();
        }
    }

    public void detachWheel() {
        if (this.poweredWheel == null || this.poweredWheel.m_58901_()) {
            return;
        }
        this.poweredWheel.setRotation(0.0f, 0.0f);
        FlywheelBlock.setConnection(this.f_58857_, this.poweredWheel.m_58899_(), this.poweredWheel.m_58900_(), null);
        this.poweredWheel = null;
    }

    @Override
    public void m_7651_() {
        this.detachWheel();
        super.m_7651_();
    }

    protected void refreshWheelSpeed() {
        if (this.poweredWheel == null) {
            return;
        }
        this.poweredWheel.setRotation(this.appliedSpeed, this.appliedCapacity);
    }
}

